/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.handlers;

import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.dotwebstack.framework.backend.ResultType;
import org.dotwebstack.framework.frontend.openapi.entity.AbstractEntity;
import org.dotwebstack.framework.frontend.openapi.entity.Entity;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntity;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntity;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestParameterMapper;
import org.dotwebstack.framework.informationproduct.InformationProduct;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.glassfish.jersey.process.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GetRequestHandler
implements Inflector<ContainerRequestContext, Response> {
    private static final Logger LOG = LoggerFactory.getLogger(GetRequestHandler.class);
    private final Operation operation;
    private final InformationProduct informationProduct;
    private final Map<MediaType, Property> schemaMap;
    private final RequestParameterMapper requestParameterMapper;
    private final Swagger swagger;

    GetRequestHandler(@NonNull Operation operation, @NonNull InformationProduct informationProduct, @NonNull Map<MediaType, Property> schemaMap, @NonNull RequestParameterMapper requestParameterMapper, @NonNull Swagger swagger) {
        if (operation == null) {
            throw new NullPointerException("operation");
        }
        if (informationProduct == null) {
            throw new NullPointerException("informationProduct");
        }
        if (schemaMap == null) {
            throw new NullPointerException("schemaMap");
        }
        if (requestParameterMapper == null) {
            throw new NullPointerException("requestParameterMapper");
        }
        if (swagger == null) {
            throw new NullPointerException("swagger");
        }
        this.operation = operation;
        this.informationProduct = informationProduct;
        this.schemaMap = schemaMap;
        this.requestParameterMapper = requestParameterMapper;
        this.swagger = swagger;
    }

    public InformationProduct getInformationProduct() {
        return this.informationProduct;
    }

    public Response apply(@NonNull ContainerRequestContext context) {
        AbstractEntity entity;
        TupleQueryResult result;
        if (context == null) {
            throw new NullPointerException("context");
        }
        String path = context.getUriInfo().getPath();
        LOG.debug("Handling GET request for path {}", (Object)path);
        Map<String, Object> parameterValues = this.requestParameterMapper.map(this.operation, this.informationProduct, context);
        Response responseOk = null;
        if (ResultType.TUPLE.equals((Object)this.informationProduct.getResultType())) {
            result = (TupleQueryResult)this.informationProduct.getResult(parameterValues);
            entity = TupleEntity.builder().withQueryResult(result).withSchemaMap(this.schemaMap).build();
            responseOk = this.responseOk(entity);
        }
        if (ResultType.GRAPH.equals((Object)this.informationProduct.getResultType())) {
            result = (GraphQueryResult)this.informationProduct.getResult(parameterValues);
            entity = (GraphEntity)GraphEntity.builder().withSchemaMap(this.schemaMap).withQueryResult((QueryResult)result).withApiDefinitions(this.swagger).withLdPathNamespaces(this.swagger).build();
            responseOk = this.responseOk(entity);
        }
        if (responseOk != null) {
            return responseOk;
        }
        LOG.error("Result type {} not supported for information product {}", (Object)this.informationProduct.getResultType(), (Object)this.informationProduct.getIdentifier());
        return Response.serverError().build();
    }

    private Response responseOk(Entity entity) {
        if (entity != null) {
            return Response.ok((Object)entity).build();
        }
        return null;
    }

    public Map<MediaType, Property> getSchemaMap() {
        return this.schemaMap;
    }
}

