/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.handlers;

import io.swagger.models.Operation;
import io.swagger.models.parameters.Parameter;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import lombok.NonNull;
import org.dotwebstack.framework.config.ConfigurationException;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.informationproduct.InformationProduct;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
class RequestParameterMapper {
    private static final Logger LOG = LoggerFactory.getLogger(RequestParameterMapper.class);
    private static final ValueFactory VALUE_FACTORY = SimpleValueFactory.getInstance();

    RequestParameterMapper() {
    }

    private static org.dotwebstack.framework.param.Parameter<?> getParameter(InformationProduct product, IRI iri) {
        for (org.dotwebstack.framework.param.Parameter parameter : product.getParameters()) {
            if (!parameter.getIdentifier().equals((Object)iri)) continue;
            return parameter;
        }
        return null;
    }

    private static String getOpenApiParameterValue(ContainerRequestContext context, Parameter openApiParameter) {
        switch (openApiParameter.getIn()) {
            case "header": {
                return (String)context.getHeaders().getFirst((Object)openApiParameter.getName());
            }
            case "path": {
                return (String)context.getUriInfo().getPathParameters().getFirst((Object)openApiParameter.getName());
            }
            case "query": {
                return (String)context.getUriInfo().getQueryParameters().getFirst((Object)openApiParameter.getName());
            }
        }
        throw new ConfigurationException(String.format("Unknown parameter location: '%s'", openApiParameter.getIn()));
    }

    Map<String, Object> map(@NonNull Operation operation, @NonNull InformationProduct product, @NonNull ContainerRequestContext context) {
        if (operation == null) {
            throw new NullPointerException("operation");
        }
        if (product == null) {
            throw new NullPointerException("product");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Parameter openApiParameter : operation.getParameters()) {
            Map vendorExtensions = openApiParameter.getVendorExtensions();
            LOG.debug("Vendor extensions for parameter '{}': {}", (Object)openApiParameter.getName(), (Object)vendorExtensions);
            Object parameterIdString = vendorExtensions.get(OpenApiSpecificationExtensions.PARAMETER);
            if (parameterIdString == null) continue;
            IRI parameterId = VALUE_FACTORY.createIRI((String)parameterIdString);
            org.dotwebstack.framework.param.Parameter<?> parameter = RequestParameterMapper.getParameter(product, parameterId);
            if (parameter == null) {
                throw new ConfigurationException(String.format("No parameter found for vendor extension value: '%s'", parameterIdString));
            }
            String value = RequestParameterMapper.getOpenApiParameterValue(context, openApiParameter);
            result.put(parameter.getName(), value);
        }
        return result;
    }
}

