/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.ldpath;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import lombok.NonNull;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;

public final class KeepAfterLastFunction<N>
extends SelectorFunction<N> {
    private static final int NO_ARGS = 2;

    @SafeVarargs
    public final Collection<N> apply(@NonNull RDFBackend<N> backend, N context, Collection<N> ... args) {
        if (backend == null) {
            throw new NullPointerException("backend");
        }
        if (args.length != 2) {
            throw new IllegalArgumentException(String.format("LdPath function %s requires %d arguments.", this.getLocalName(), 2));
        }
        N node = args[0].iterator().next();
        String separator = backend.stringValue(args[1].iterator().next());
        String str = backend.stringValue(node);
        int separatorIndex = str.lastIndexOf(separator);
        if (separatorIndex != -1) {
            str = str.substring(str.lastIndexOf(separator) + 1);
        }
        return ImmutableList.of((Object)backend.createLiteral(str));
    }

    public String getSignature() {
        return "fn:keepAfterLast(node::Node, separator::StringLiteral) :: StringLiteral";
    }

    public String getDescription() {
        return "Returns the last part of the string representation of a node after the given separator";
    }

    protected String getLocalName() {
        return "keepAfterLast";
    }
}

