/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.ldpath;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import lombok.NonNull;
import org.apache.marmotta.ldpath.LDPath;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.exception.LDPathParseException;
import org.apache.marmotta.ldpath.model.transformers.StringTransformer;
import org.eclipse.rdf4j.sail.memory.model.IntegerMemLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortByPropertyFunction<N>
extends SelectorFunction<N> {
    private static final Logger LOG = LoggerFactory.getLogger(SortByPropertyFunction.class);
    private static final int OBJECT_ARRAY_INDEX = 0;
    private static final int PROPERTY_INDEX = 1;
    private static final int PROPERTY_TYPE_INDEX = 2;
    private static final int DIRECTION_INDEX = 3;
    private final ImmutableMap<String, String> ldPathNamespaces;
    private final StringTransformer<N> transformer = new StringTransformer();

    public SortByPropertyFunction(ImmutableMap<String, String> ns) {
        this.ldPathNamespaces = ns;
    }

    @SafeVarargs
    public final Collection<N> apply(@NonNull RDFBackend<N> nodeRdfBackend, N context, Collection<N> ... args) {
        if (nodeRdfBackend == null) {
            throw new NullPointerException("nodeRdfBackend");
        }
        Iterator<N> iterator = this.getIterator(args[0]);
        String property = this.getProperty(nodeRdfBackend, args);
        Type propertyType = this.getPropertyType(nodeRdfBackend, args);
        InnerComparator comparator = new InnerComparator(this.getSortDirection(nodeRdfBackend, args));
        LDPath ldpath = new LDPath(nodeRdfBackend);
        TreeMap sortedMap = new TreeMap(comparator);
        while (iterator.hasNext()) {
            N child = iterator.next();
            try {
                Object result = ldpath.pathQuery(child, property, this.ldPathNamespaces).iterator().next();
                sortedMap.put(this.determineValue(propertyType, result), child);
            }
            catch (IllegalStateException | NoSuchElementException | LDPathParseException exception) {
                LOG.error("LDPath expression could not be parsed", exception);
            }
        }
        return new ArrayList(sortedMap.values());
    }

    private Iterator<N> getIterator(Collection<N> arg) {
        return arg.iterator();
    }

    private String getProperty(RDFBackend<N> nodeRdfBackend, Collection<N> ... args) {
        try {
            return this.transformer.transform(nodeRdfBackend, args[1].iterator().next(), null);
        }
        catch (IndexOutOfBoundsException ex) {
            LOG.warn("Error determining property. Defaulting to 'ROOT'", (Throwable)ex);
            return ".";
        }
    }

    private Type getPropertyType(RDFBackend<N> nodeRdfBackend, Collection<N> ... args) {
        if (args.length > 2) {
            String arg = this.transformer.transform(nodeRdfBackend, args[2].iterator().next(), null).toUpperCase();
            try {
                return Type.valueOf(arg);
            }
            catch (IllegalArgumentException ex) {
                LOG.warn(String.format("Unknown property '%s'", arg), (Throwable)ex);
                return Type.STRING;
            }
        }
        return Type.STRING;
    }

    private Direction getSortDirection(RDFBackend<N> nodeRdfBackend, Collection<N> ... args) {
        if (args.length > 3) {
            String arg = this.transformer.transform(nodeRdfBackend, args[3].iterator().next(), null).toUpperCase();
            try {
                return Direction.valueOf(arg);
            }
            catch (IllegalArgumentException ex) {
                LOG.warn(String.format("Unknown property '%s'", arg), (Throwable)ex);
                return Direction.ASC;
            }
        }
        return Direction.ASC;
    }

    private Comparable<?> determineValue(Type propertyType, N result) {
        switch (propertyType) {
            case STRING: {
                return result.toString();
            }
            case NUMBER: {
                return ((IntegerMemLiteral)result).intValue();
            }
        }
        throw new IllegalStateException("Unsupported property type supplied");
    }

    public String getLocalName() {
        return "sortByProperty";
    }

    public String getSignature() {
        return "fn:sortByProperty(nodes : NodeList, property : String , (\"string\"|\"number\") [, (\"asc\"|\"desc\") ]) : NodeList ";
    }

    public String getDescription() {
        return "Sort the node list passed as first argument on the property evaluated by the LD path expression specified in the second argument. The third argument specifies the property type. The fourth argument is used to determine the sort direction.";
    }

    static class InnerComparator
    implements Comparator<Comparable<?>> {
        private final Direction direction;

        InnerComparator(Direction direction) {
            this.direction = direction;
        }

        @Override
        public int compare(Comparable o1, Comparable o2) {
            if (this.direction == Direction.ASC) {
                return o1.compareTo(o2);
            }
            return o2.compareTo(o1);
        }
    }

    static enum Direction {
        ASC,
        DESC;

    }

    private static enum Type {
        STRING,
        NUMBER;

    }
}

