/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi;

import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.http.client.utils.URIBuilder;
import org.glassfish.jersey.server.ContainerRequest;

public final class BaseUriFactory {
    public static String newBaseUri(@NonNull ContainerRequest containerRequest, @NonNull Swagger swagger) {
        String baseUri;
        if (containerRequest == null) {
            throw new NullPointerException("containerRequest");
        }
        if (swagger == null) {
            throw new NullPointerException("swagger");
        }
        try {
            URI base = new URIBuilder().setScheme(BaseUriFactory.getScheme(swagger)).setHost(BaseUriFactory.getHost(containerRequest)).setPath(swagger.getBasePath()).build();
            baseUri = base.toString();
        }
        catch (URISyntaxException use) {
            throw new IllegalStateException("BaseUri could not be constructed", use);
        }
        return baseUri;
    }

    private static String getScheme(@NonNull Swagger swagger) {
        if (swagger == null) {
            throw new NullPointerException("swagger");
        }
        List schemes = swagger.getSchemes();
        if (schemes != null && !schemes.isEmpty()) {
            return ((Scheme)schemes.get(0)).toValue();
        }
        return "https";
    }

    private static String getHost(ContainerRequest containerRequest) {
        return BaseUriFactory.getForwardedHostFromRequestHeader(containerRequest).orElse(BaseUriFactory.getHostFromRequest(containerRequest));
    }

    private static Optional<String> getForwardedHostFromRequestHeader(ContainerRequest containerRequest) {
        return Optional.ofNullable(containerRequest.getRequestHeaders().getFirst((Object)"x-forwarded-host"));
    }

    private static String getHostFromRequest(ContainerRequest containerRequest) {
        URI baseUri = containerRequest.getBaseUri();
        String host = baseUri.getHost();
        int port = baseUri.getPort();
        if (port != -1) {
            host = host + ":" + port;
        }
        return host;
    }

    private BaseUriFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

