/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi;

import com.atlassian.oai.validator.model.ApiOperation;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.parser.SwaggerParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.dotwebstack.framework.ApplicationProperties;
import org.dotwebstack.framework.EnvironmentAwareResource;
import org.dotwebstack.framework.config.ConfigurationException;
import org.dotwebstack.framework.frontend.http.HttpConfiguration;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.SwaggerUtils;
import org.dotwebstack.framework.frontend.openapi.handlers.OptionsRequestHandler;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestHandlerFactory;
import org.dotwebstack.framework.informationproduct.InformationProduct;
import org.dotwebstack.framework.informationproduct.InformationProductResourceProvider;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.stereotype.Service;

@Service
class OpenApiRequestMapper
implements ResourceLoaderAware,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiRequestMapper.class);
    private final InformationProductResourceProvider informationProductResourceProvider;
    private final SwaggerParser openApiParser;
    private final RequestHandlerFactory requestHandlerFactory;
    private ApplicationProperties applicationProperties;
    private ResourceLoader resourceLoader;
    private Environment environment;
    private ValueFactory valueFactory = SimpleValueFactory.getInstance();

    @Autowired
    public OpenApiRequestMapper(@NonNull InformationProductResourceProvider informationProductLoader, @NonNull SwaggerParser openApiParser, @NonNull ApplicationProperties applicationProperties, @NonNull RequestHandlerFactory requestHandlerFactory) {
        if (informationProductLoader == null) {
            throw new NullPointerException("informationProductLoader");
        }
        if (openApiParser == null) {
            throw new NullPointerException("openApiParser");
        }
        if (applicationProperties == null) {
            throw new NullPointerException("applicationProperties");
        }
        if (requestHandlerFactory == null) {
            throw new NullPointerException("requestHandlerFactory");
        }
        this.informationProductResourceProvider = informationProductLoader;
        this.openApiParser = openApiParser;
        this.applicationProperties = applicationProperties;
        this.requestHandlerFactory = requestHandlerFactory;
    }

    public void setResourceLoader(@NonNull ResourceLoader resourceLoader) {
        if (resourceLoader == null) {
            throw new NullPointerException("resourceLoader");
        }
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(@NonNull Environment environment) {
        if (environment == null) {
            throw new NullPointerException("environment");
        }
        this.environment = environment;
    }

    void map(@NonNull HttpConfiguration httpConfiguration) throws IOException {
        org.springframework.core.io.Resource[] resources;
        if (httpConfiguration == null) {
            throw new NullPointerException("httpConfiguration");
        }
        try {
            resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources(this.applicationProperties.getResourcePath() + "/openapi/**.y*ml");
        }
        catch (FileNotFoundException exp) {
            LOG.warn("No Open API resources found in path:{}/openapi", (Object)this.applicationProperties.getResourcePath());
            return;
        }
        for (org.springframework.core.io.Resource resource : resources) {
            InputStream inputStream = new EnvironmentAwareResource(resource.getInputStream(), this.environment).getInputStream();
            String result = CharStreams.toString((Readable)new InputStreamReader(inputStream, Charsets.UTF_8));
            if (StringUtils.isBlank((CharSequence)result)) continue;
            Swagger swagger = this.openApiParser.parse(result);
            this.mapOpenApiDefinition(swagger, httpConfiguration);
        }
    }

    private void mapOpenApiDefinition(Swagger swagger, HttpConfiguration httpConfiguration) {
        String basePath = this.createBasePath(swagger);
        swagger.getPaths().forEach((path, pathItem) -> {
            List produces;
            ApiOperation apiOperation = SwaggerUtils.extractApiOperation(swagger, path, pathItem);
            if (apiOperation == null) {
                return;
            }
            Operation getOperation = apiOperation.getOperation();
            this.validateOperation(apiOperation, swagger);
            String absolutePath = basePath.concat((String)path);
            if (!getOperation.getVendorExtensions().containsKey(OpenApiSpecificationExtensions.INFORMATION_PRODUCT)) {
                LOG.warn("Path '{}' is not mapped to an information product.", (Object)absolutePath);
                return;
            }
            String okStatusCode = Integer.toString(Response.Status.OK.getStatusCode());
            if (getOperation.getResponses() == null || !getOperation.getResponses().containsKey(okStatusCode)) {
                throw new ConfigurationException(String.format("Resource '%s' does not specify a status %s response.", absolutePath, okStatusCode));
            }
            List list = produces = getOperation.getProduces() != null ? getOperation.getProduces() : swagger.getProduces();
            if (produces == null) {
                throw new ConfigurationException(String.format("Path '%s' should produce at least one media type.", absolutePath));
            }
            Response response = (Response)getOperation.getResponses().get(okStatusCode);
            IRI informationProductIdentifier = this.valueFactory.createIRI((String)getOperation.getVendorExtensions().get(OpenApiSpecificationExtensions.INFORMATION_PRODUCT));
            InformationProduct informationProduct = (InformationProduct)this.informationProductResourceProvider.get((org.eclipse.rdf4j.model.Resource)informationProductIdentifier);
            Resource.Builder resourceBuilder = Resource.builder().path(absolutePath);
            ResourceMethod.Builder methodBuilder = resourceBuilder.addMethod(apiOperation.getMethod().name()).handledBy((Inflector)this.requestHandlerFactory.newRequestHandler(apiOperation, informationProduct, response, swagger));
            produces.forEach(xva$0 -> methodBuilder.produces(new String[]{xva$0}));
            resourceBuilder.addMethod("OPTIONS").handledBy((Inflector)new OptionsRequestHandler((Path)pathItem));
            httpConfiguration.registerResources(new Resource[]{resourceBuilder.build()});
            LOG.debug("Mapped {} operation for request path {}", (Object)apiOperation.getMethod().name(), (Object)absolutePath);
        });
    }

    private void validateOperation(ApiOperation apiOperation, Swagger swagger) {
        apiOperation.getOperation().getParameters().stream().filter(parameterBody -> "body".equalsIgnoreCase(parameterBody.getIn())).forEach(parameterBody -> {
            ModelImpl parameterModel;
            if (parameterBody instanceof BodyParameter && !"object".equalsIgnoreCase((parameterModel = this.getBodyParameter(swagger, (BodyParameter)parameterBody)).getType())) {
                throw new ConfigurationException("No object property in body parameter.");
            }
        });
    }

    private ModelImpl getBodyParameter(@NonNull Swagger swagger, BodyParameter parameterBody) {
        if (swagger == null) {
            throw new NullPointerException("swagger");
        }
        ModelImpl parameterModel = null;
        if (parameterBody.getSchema() instanceof ModelImpl) {
            parameterModel = (ModelImpl)parameterBody.getSchema();
        }
        if (parameterBody.getSchema() instanceof RefModel) {
            RefModel refModel = (RefModel)parameterBody.getSchema();
            parameterModel = (ModelImpl)swagger.getDefinitions().get(refModel.getSimpleRef());
        }
        return parameterModel;
    }

    private String createBasePath(Swagger swagger) {
        String basePath = "/";
        if (swagger.getHost() == null) {
            throw new ConfigurationException(String.format("OpenAPI definition document '%s' must contain a 'host' attribute.", swagger.getInfo().getDescription()));
        }
        basePath = basePath.concat(swagger.getHost());
        if (swagger.getBasePath() != null) {
            basePath = basePath.concat(swagger.getBasePath());
        }
        return basePath;
    }
}

