/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi;

import com.atlassian.oai.validator.interaction.ApiOperationResolver;
import com.atlassian.oai.validator.interaction.RequestValidator;
import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.ApiOperationMatch;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.report.LevelResolver;
import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.schema.SchemaValidator;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import lombok.NonNull;

public final class SwaggerUtils {
    private SwaggerUtils() {
    }

    public static RequestValidator createValidator(@NonNull Swagger swagger) {
        if (swagger == null) {
            throw new NullPointerException("swagger");
        }
        LevelResolver levelResolver = LevelResolver.defaultResolver();
        MessageResolver messageResolver = new MessageResolver(levelResolver);
        SchemaValidator schemaValidator = new SchemaValidator(swagger, messageResolver);
        return new RequestValidator(schemaValidator, messageResolver, swagger);
    }

    public static ApiOperation extractApiOperation(@NonNull Swagger swagger, @NonNull String path, @NonNull Path apiPath) {
        ApiOperationMatch apiOperationMatch;
        if (swagger == null) {
            throw new NullPointerException("swagger");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (apiPath == null) {
            throw new NullPointerException("apiPath");
        }
        Request.Method realMethod = Request.Method.GET;
        if (apiPath.getGet() != null) {
            realMethod = Request.Method.GET;
        }
        if (apiPath.getPost() != null) {
            realMethod = Request.Method.POST;
        }
        return (apiOperationMatch = new ApiOperationResolver(swagger, null).findApiOperation(path, realMethod)).isPathFound() && apiOperationMatch.isOperationAllowed() ? apiOperationMatch.getApiOperation() : null;
    }
}

