/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.cors;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.parameters.Parameter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import lombok.NonNull;

public class CorsResponseFilter
implements ContainerResponseFilter {
    public void filter(@NonNull ContainerRequestContext requestContext, @NonNull ContainerResponseContext responseContext) throws IOException {
        if (requestContext == null) {
            throw new NullPointerException("requestContext");
        }
        if (responseContext == null) {
            throw new NullPointerException("responseContext");
        }
        if (!requestContext.getHeaders().containsKey((Object)"Origin")) {
            return;
        }
        if ("OPTIONS".equals(requestContext.getMethod())) {
            this.handlePreflightRequest(requestContext, responseContext);
        } else {
            this.handleActualRequest(requestContext, responseContext);
        }
    }

    private void handlePreflightRequest(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Sets.SetView diff;
        Path path = (Path)requestContext.getProperty("path");
        if (path == null) {
            return;
        }
        String actualRequestMethod = (String)requestContext.getHeaders().getFirst((Object)"Access-Control-Request-Method");
        if (actualRequestMethod == null) {
            return;
        }
        HashSet allowedMethods = Sets.newHashSet(path.getOperationMap().keySet());
        allowedMethods.add(HttpMethod.HEAD);
        allowedMethods.add(HttpMethod.OPTIONS);
        if (!allowedMethods.contains(HttpMethod.valueOf((String)actualRequestMethod))) {
            return;
        }
        String expectedHeadersStr = (String)requestContext.getHeaders().getFirst((Object)"Access-Control-Request-Headers");
        if (expectedHeadersStr == null) {
            expectedHeadersStr = "";
        }
        Object expectedHeaders = ImmutableSet.copyOf((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)expectedHeadersStr));
        expectedHeaders = expectedHeaders.stream().map(String::toLowerCase).collect(Collectors.toSet());
        List requestParameters = ((Operation)path.getOperationMap().get(HttpMethod.valueOf((String)actualRequestMethod))).getParameters();
        Set allowedHeaders = requestParameters.stream().filter(p -> "header".equals(p.getIn())).map(Parameter::getName).collect(Collectors.toSet());
        allowedHeaders = allowedHeaders.stream().map(String::toLowerCase).collect(Collectors.toSet());
        if (!expectedHeaders.isEmpty() && !(diff = Sets.difference((Set)expectedHeaders, allowedHeaders)).isEmpty()) {
            return;
        }
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", requestContext.getHeaders().getFirst((Object)"Origin"));
        responseContext.getHeaders().add((Object)"Access-Control-Max-Age", (Object)86400);
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)Joiner.on((String)", ").join((Iterable)allowedMethods));
        if (!allowedHeaders.isEmpty()) {
            responseContext.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)Joiner.on((String)", ").join(allowedHeaders));
        }
    }

    private void handleActualRequest(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Operation operation = (Operation)requestContext.getProperty("operation");
        if (operation == null) {
            return;
        }
        String statusCode = Integer.toString(responseContext.getStatus());
        if (!operation.getResponses().containsKey(statusCode)) {
            return;
        }
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", requestContext.getHeaders().getFirst((Object)"Origin"));
        Map responseHeaders = ((Response)operation.getResponses().get(statusCode)).getHeaders();
        if (responseHeaders != null && responseHeaders.size() > 0) {
            Set exposedHeaders = responseHeaders.keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
            responseContext.getHeaders().add((Object)"Access-Control-Expose-Headers", (Object)Joiner.on((String)", ").join(exposedHeaders));
        }
    }
}

