/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity;

import com.google.common.collect.ImmutableMap;
import io.swagger.models.Response;
import io.swagger.models.properties.Property;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.entity.AbstractEntity;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntity;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntityMapper;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntity;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntityMapper;
import org.dotwebstack.framework.informationproduct.InformationProduct;
import org.dotwebstack.framework.informationproduct.InformationProductUtils;
import org.dotwebstack.framework.param.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class EntityWriterInterceptor
implements WriterInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(EntityWriterInterceptor.class);
    private final TupleEntityMapper tupleEntityMapper;
    private final GraphEntityMapper graphEntityMapper;

    @Autowired
    public EntityWriterInterceptor(@NonNull GraphEntityMapper graphEntityMapper, @NonNull TupleEntityMapper tupleEntityMapper) {
        if (graphEntityMapper == null) {
            throw new NullPointerException("graphEntityMapper");
        }
        if (tupleEntityMapper == null) {
            throw new NullPointerException("tupleEntityMapper");
        }
        this.graphEntityMapper = graphEntityMapper;
        this.tupleEntityMapper = tupleEntityMapper;
    }

    public void aroundWriteTo(@NonNull WriterInterceptorContext context) throws IOException {
        Object mappedEntity;
        AbstractEntity entity;
        if (context == null) {
            throw new NullPointerException("context");
        }
        MediaType mediaType = context.getMediaType();
        if (context.getEntity() instanceof TupleEntity) {
            entity = (TupleEntity)context.getEntity();
            mappedEntity = this.tupleEntityMapper.map((TupleEntity)entity, mediaType);
            context.setEntity(mappedEntity);
        }
        if (context.getEntity() instanceof GraphEntity) {
            entity = (GraphEntity)context.getEntity();
            mappedEntity = this.graphEntityMapper.map((GraphEntity)entity, mediaType);
            context.setEntity(mappedEntity);
            Map<String, Object> headers = EntityWriterInterceptor.createResponseHeaders((GraphEntity)entity);
            headers.entrySet().forEach(e -> context.getHeaders().add(e.getKey(), e.getValue()));
        }
        context.proceed();
    }

    private static Map<String, Object> createResponseHeaders(GraphEntity entity) {
        Response response = entity.getResponse();
        Map headers = response.getHeaders();
        if (headers == null) {
            return ImmutableMap.of();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry header : headers.entrySet()) {
            Map vendorExtensions = ((Property)header.getValue()).getVendorExtensions();
            LOG.debug("Vendor extensions for header param '{}': {}", header.getKey(), (Object)vendorExtensions);
            Object parameterIdString = vendorExtensions.get(OpenApiSpecificationExtensions.PARAMETER);
            if (parameterIdString == null) continue;
            InformationProduct product = entity.getRequestContext().getInformationProduct();
            Parameter parameter = InformationProductUtils.getParameter((InformationProduct)product, (String)((String)parameterIdString));
            Object value = parameter.handle(entity.getRequestContext().getParameters());
            result.put((String)header.getKey(), value);
        }
        return result;
    }
}

