/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity;

import com.google.common.collect.ImmutableMap;
import io.swagger.models.Model;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.entity.AbstractEntity;
import org.dotwebstack.framework.frontend.openapi.entity.LdPathExecutor;
import org.dotwebstack.framework.frontend.openapi.entity.LdPathExecutorRuntimeException;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestContext;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;

public final class GraphEntity
extends AbstractEntity {
    private final ImmutableMap<String, String> ldPathNamespaces;
    private final Map<String, Model> swaggerDefinitions;
    private final Repository repository;
    private final Set<Resource> subjects;
    private final LdPathExecutor ldPathExecutor;

    private GraphEntity(@NonNull Response response, @NonNull ImmutableMap<String, String> ldPathNamespaces, @NonNull Map<String, Model> swaggerDefinitions, @NonNull Repository repository, @NonNull Set<Resource> subjects, @NonNull RequestContext requestContext) {
        super(response, requestContext);
        if (response == null) {
            throw new NullPointerException("response");
        }
        if (ldPathNamespaces == null) {
            throw new NullPointerException("ldPathNamespaces");
        }
        if (swaggerDefinitions == null) {
            throw new NullPointerException("swaggerDefinitions");
        }
        if (repository == null) {
            throw new NullPointerException("repository");
        }
        if (subjects == null) {
            throw new NullPointerException("subjects");
        }
        if (requestContext == null) {
            throw new NullPointerException("requestContext");
        }
        this.ldPathNamespaces = ldPathNamespaces;
        this.swaggerDefinitions = swaggerDefinitions;
        this.repository = repository;
        this.subjects = subjects;
        this.ldPathExecutor = new LdPathExecutor(this);
    }

    public static GraphEntity newGraphEntity(@NonNull Response response, @NonNull Repository repository, @NonNull Set<Resource> subjects, @NonNull Swagger definitions, @NonNull RequestContext requestContext) {
        if (response == null) {
            throw new NullPointerException("response");
        }
        if (repository == null) {
            throw new NullPointerException("repository");
        }
        if (subjects == null) {
            throw new NullPointerException("subjects");
        }
        if (definitions == null) {
            throw new NullPointerException("definitions");
        }
        if (requestContext == null) {
            throw new NullPointerException("requestContext");
        }
        return new GraphEntity(response, GraphEntity.extractLdpathNamespaces(definitions), GraphEntity.extractSwaggerDefinitions(definitions), repository, subjects, requestContext);
    }

    private static Map<String, Model> extractSwaggerDefinitions(Swagger swagger) {
        return swagger.getDefinitions() == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)swagger.getDefinitions());
    }

    private static ImmutableMap<String, String> extractLdpathNamespaces(Swagger swagger) {
        ImmutableMap vendorExtensions;
        Map extensions = swagger.getVendorExtensions();
        ImmutableMap immutableMap = vendorExtensions = extensions == null ? ImmutableMap.of() : ImmutableMap.copyOf((Map)extensions);
        if (vendorExtensions.containsKey((Object)OpenApiSpecificationExtensions.LDPATH_NAMESPACES)) {
            Object ldPathNamespaces = vendorExtensions.get((Object)OpenApiSpecificationExtensions.LDPATH_NAMESPACES);
            try {
                Map namespaces = (Map)ldPathNamespaces;
                return ImmutableMap.copyOf((Map)namespaces);
            }
            catch (ClassCastException cce) {
                String jsonExample = "{ \"rdfs\": \"http://www.w3.org/2000/01/rdf-schema#\", \"rdf\": \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"}";
                throw new LdPathExecutorRuntimeException(String.format("Vendor extension '%s' should contain a map of namespaces (eg. %s)", OpenApiSpecificationExtensions.LDPATH_NAMESPACES, jsonExample), cce);
            }
        }
        return ImmutableMap.of();
    }

    public ImmutableMap<String, String> getLdPathNamespaces() {
        return this.ldPathNamespaces;
    }

    public Map<String, Model> getSwaggerDefinitions() {
        return this.swaggerDefinitions;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Set<Resource> getSubjects() {
        return this.subjects;
    }

    public LdPathExecutor getLdPathExecutor() {
        return this.ldPathExecutor;
    }
}

