/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import lombok.NonNull;
import org.apache.marmotta.ldpath.LDPath;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.exception.LDPathParseException;
import org.apache.marmotta.ldpath.parser.Configuration;
import org.apache.marmotta.ldpath.parser.DefaultConfiguration;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntity;
import org.dotwebstack.framework.frontend.openapi.entity.LdPathExecutorRuntimeException;
import org.dotwebstack.framework.frontend.openapi.entity.backend.Rdf4jRepositoryBackend;
import org.dotwebstack.framework.frontend.openapi.ldpath.JoinFunction;
import org.dotwebstack.framework.frontend.openapi.ldpath.KeepAfterLastFunction;
import org.dotwebstack.framework.frontend.openapi.ldpath.SortByPropertyFunction;
import org.dotwebstack.framework.frontend.openapi.ldpath.TrimFunction;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.Repository;

public class LdPathExecutor {
    private static final Configuration<Value> LD_PATH_CONFIG = new DefaultConfiguration();
    private final LDPath<Value> ldpath;
    private final ImmutableMap<String, String> ldpathNamespaces;

    public LdPathExecutor(@NonNull GraphEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        this.ldpathNamespaces = entity.getLdPathNamespaces();
        this.ldpath = this.createLdpath(entity.getRepository());
    }

    private LDPath<Value> createLdpath(Repository repository) {
        Rdf4jRepositoryBackend repositoryBackend = new Rdf4jRepositoryBackend(repository);
        LDPath result = new LDPath((RDFBackend)repositoryBackend, LD_PATH_CONFIG);
        result.registerFunction(new SortByPropertyFunction(this.ldpathNamespaces));
        return result;
    }

    public Collection<Value> ldPathQuery(Value context, @NonNull String query) {
        if (query == null) {
            throw new NullPointerException("query");
        }
        if (context == null) {
            throw new LdPathExecutorRuntimeException(String.format("Unable to execute LDPath expression '%s' because no context has been supplied.", query));
        }
        try {
            return this.ldpath.pathQuery((Object)context, query, this.ldpathNamespaces);
        }
        catch (LDPathParseException ldppe) {
            throw new LdPathExecutorRuntimeException(String.format("Unable to parse LDPath expression '%s'", query), (Exception)((Object)ldppe));
        }
    }

    static {
        LD_PATH_CONFIG.addFunction("http://www.newmedialab.at/lmf/functions/1.0/keepAfterLast", new KeepAfterLastFunction());
        LD_PATH_CONFIG.addFunction("http://www.newmedialab.at/lmf/functions/1.0/trim", new TrimFunction());
        LD_PATH_CONFIG.addFunction("http://www.newmedialab.at/lmf/functions/1.0/join", new JoinFunction());
    }
}

