/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity;

import io.swagger.models.Response;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.entity.AbstractEntity;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestContext;
import org.eclipse.rdf4j.query.TupleQueryResult;

public final class TupleEntity
extends AbstractEntity {
    private final TupleQueryResult queryResult;

    TupleEntity(@NonNull Response response, @NonNull TupleQueryResult queryResult, @NonNull RequestContext requestContext) {
        super(response, requestContext);
        if (response == null) {
            throw new NullPointerException("response");
        }
        if (queryResult == null) {
            throw new NullPointerException("queryResult");
        }
        if (requestContext == null) {
            throw new NullPointerException("requestContext");
        }
        this.queryResult = queryResult;
    }

    public TupleQueryResult getResult() {
        return this.queryResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Response response;
        private RequestContext requestContext;
        private TupleQueryResult tupleQueryResult;

        public Builder withResult(@NonNull TupleQueryResult queryResult) {
            if (queryResult == null) {
                throw new NullPointerException("queryResult");
            }
            this.tupleQueryResult = queryResult;
            return this;
        }

        public Builder withResponse(@NonNull Response response) {
            if (response == null) {
                throw new NullPointerException("response");
            }
            this.response = response;
            return this;
        }

        public Builder withRequestContext(@NonNull RequestContext requestContext) {
            if (requestContext == null) {
                throw new NullPointerException("requestContext");
            }
            this.requestContext = requestContext;
            return this;
        }

        public TupleEntity build() {
            return new TupleEntity(this.response, this.tupleQueryResult, this.requestContext);
        }
    }
}

