/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.backend;

import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.entity.backend.AbstractRdf4jBackend;
import org.dotwebstack.framework.frontend.openapi.entity.backend.Rdf4jBackendRuntimeException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;

public class Rdf4jRepositoryBackend
extends AbstractRdf4jBackend {
    private final Repository repository;
    private final boolean includeInferred;
    private final Resource[] contexts;

    public Rdf4jRepositoryBackend(@NonNull Repository repository) {
        this(repository, true, new Resource[0]);
        if (repository == null) {
            throw new NullPointerException("repository");
        }
    }

    private Rdf4jRepositoryBackend(@NonNull Repository repository, boolean includeInferred, Resource ... contexts) {
        if (repository == null) {
            throw new NullPointerException("repository");
        }
        this.repository = repository;
        this.includeInferred = includeInferred;
        this.contexts = contexts;
    }

    @Override
    public Literal createLiteral(@NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content");
        }
        return this.createLiteralInternal(this.repository.getValueFactory(), content);
    }

    @Override
    public Literal createLiteral(@NonNull String content, Locale language, URI type) {
        if (content == null) {
            throw new NullPointerException("content");
        }
        return this.createLiteralInternal(this.repository.getValueFactory(), content, language, type);
    }

    @Override
    public IRI createURI(@NonNull String uri) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        return this.createUriInternal(this.repository.getValueFactory(), uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Value> listObjects(Value subject, Value property) {
        Collection<Value> collection;
        RepositoryConnection connection = this.repository.getConnection();
        try {
            connection.begin();
            collection = this.listObjectsInternal(connection, (Resource)subject, (IRI)property, this.includeInferred, this.contexts);
        }
        catch (Throwable throwable) {
            try {
                connection.commit();
                connection.close();
                throw throwable;
            }
            catch (RepositoryException exception) {
                throw new Rdf4jBackendRuntimeException("Error while querying RDF4J repository.", exception);
            }
            catch (ClassCastException exception) {
                throw new IllegalArgumentException(String.format("Subject needs to be a URI or blank node, property a URI node (types: [subject: %s, property: %s]).", this.debugType(subject), this.debugType(property)), exception);
            }
        }
        connection.commit();
        connection.close();
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Value> listSubjects(Value property, Value object) {
        Collection<Value> collection;
        RepositoryConnection connection = this.repository.getConnection();
        try {
            connection.begin();
            collection = this.listSubjectsInternal(connection, (IRI)property, object, this.includeInferred, this.contexts);
        }
        catch (Throwable throwable) {
            try {
                connection.commit();
                connection.close();
                throw throwable;
            }
            catch (RepositoryException ex) {
                throw new Rdf4jBackendRuntimeException("Error while querying RDF4J repository.", ex);
            }
            catch (ClassCastException ex) {
                String namelessNodeType = this.isBlank(property) ? "bNode" : "literal";
                throw new IllegalArgumentException(String.format("Property needs to be a URI node (property type: %s).", this.isURI(property) ? "URI" : namelessNodeType), ex);
            }
        }
        connection.commit();
        connection.close();
        return collection;
    }
}

