/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.backend;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Optional;
import javax.xml.datatype.XMLGregorianCalendar;
import lombok.NonNull;
import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rdf4jValueBackend
implements NodeBackend<Value> {
    private static final Logger LOG = LoggerFactory.getLogger(Rdf4jValueBackend.class);

    public boolean isLiteral(Value node) {
        return node instanceof Literal;
    }

    public boolean isURI(Value node) {
        return node instanceof IRI;
    }

    public boolean isBlank(Value node) {
        return node instanceof BNode;
    }

    public Locale getLiteralLanguage(@NonNull Value node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        try {
            Optional language = ((Literal)node).getLanguage();
            return language.map(Locale::new).orElse(null);
        }
        catch (ClassCastException ex) {
            throw this.getNodeCastException(node, ex);
        }
    }

    public URI getLiteralType(@NonNull Value node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        try {
            IRI dataTypeIri = ((Literal)node).getDatatype();
            if (dataTypeIri != null) {
                return this.getDataTypeUri(dataTypeIri);
            }
            return null;
        }
        catch (ClassCastException ex) {
            throw this.getNodeCastException(node, ex);
        }
    }

    private URI getDataTypeUri(IRI dataTypeIri) {
        try {
            return new URI(dataTypeIri.stringValue());
        }
        catch (URISyntaxException ex) {
            LOG.error("literal datatype was not a valid URI: {}", (Object)dataTypeIri, (Object)ex);
            return null;
        }
    }

    public String stringValue(@NonNull Value value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return value.stringValue();
    }

    public BigDecimal decimalValue(@NonNull Value node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        try {
            return ((Literal)node).decimalValue();
        }
        catch (ClassCastException ex) {
            throw this.getNodeCastException(node, ex);
        }
    }

    public BigInteger integerValue(@NonNull Value node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        try {
            return ((Literal)node).integerValue();
        }
        catch (ClassCastException ex) {
            throw this.getNodeCastException(node, ex);
        }
    }

    public Boolean booleanValue(@NonNull Value node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        try {
            return ((Literal)node).booleanValue();
        }
        catch (ClassCastException ex) {
            throw this.getNodeCastException(node, ex);
        }
    }

    public Date dateTimeValue(@NonNull Value node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        try {
            XMLGregorianCalendar cal = ((Literal)node).calendarValue();
            return cal.toGregorianCalendar().getTime();
        }
        catch (ClassCastException ex) {
            throw this.getNodeCastException(node, ex);
        }
    }

    public Date dateValue(@NonNull Value node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        try {
            XMLGregorianCalendar cal = ((Literal)node).calendarValue();
            return new GregorianCalendar(cal.getYear(), cal.getMonth(), cal.getDay()).getTime();
        }
        catch (ClassCastException ex) {
            throw this.getNodeCastException(node, ex);
        }
    }

    public Date timeValue(@NonNull Value node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        return this.dateTimeValue(node);
    }

    public Long longValue(@NonNull Value node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        try {
            return ((Literal)node).longValue();
        }
        catch (ClassCastException ex) {
            throw this.getNodeCastException(node, ex);
        }
    }

    public Double doubleValue(@NonNull Value node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        try {
            return ((Literal)node).doubleValue();
        }
        catch (ClassCastException ex) {
            throw this.getNodeCastException(node, ex);
        }
    }

    public Float floatValue(@NonNull Value node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        try {
            return Float.valueOf(((Literal)node).floatValue());
        }
        catch (ClassCastException ex) {
            throw this.getNodeCastException(node, ex);
        }
    }

    public Integer intValue(@NonNull Value node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        try {
            return ((Literal)node).intValue();
        }
        catch (ClassCastException ex) {
            throw this.getNodeCastException(node, ex);
        }
    }

    private IllegalArgumentException getNodeCastException(Value node, ClassCastException ex) {
        return new IllegalArgumentException(String.format("Value %s is not a literal but of type %s", node.stringValue(), this.debugType(node)), ex);
    }

    protected String debugType(Value value) {
        String namelessNodeType = this.isBlank(value) ? "bNode" : "literal (" + value.toString() + ")";
        String nodeType = this.isURI(value) ? "URI" : namelessNodeType;
        return value == null ? "null" : nodeType;
    }

    public Literal createLiteral(@NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content");
        }
        return SimpleValueFactory.getInstance().createLiteral(content);
    }

    public Literal createLiteral(@NonNull String content, Locale language, URI type) {
        if (content == null) {
            throw new NullPointerException("content");
        }
        LOG.debug("creating literal with content \"{}\", language {}, datatype {}", new Object[]{content, language, type});
        if (language == null && type == null) {
            return this.createLiteral(content);
        }
        if (type == null) {
            return SimpleValueFactory.getInstance().createLiteral(content, language.getLanguage());
        }
        return SimpleValueFactory.getInstance().createLiteral(content, this.createURI(type.toString()));
    }

    public IRI createURI(String uri) {
        return SimpleValueFactory.getInstance().createIRI(uri);
    }
}

