/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import com.atlassian.oai.validator.model.ApiOperation;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ObjectProperty;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperRuntimeException;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestContext;
import org.dotwebstack.framework.informationproduct.InformationProduct;
import org.dotwebstack.framework.param.term.IntegerTermParameter;
import org.dotwebstack.framework.vocabulary.ELMO;
import org.eclipse.rdf4j.model.IRI;

abstract class AbstractLinkSchemaMapper
implements SchemaMapper<ObjectProperty, Object> {
    AbstractLinkSchemaMapper() {
    }

    protected static URI buildUri(@NonNull RequestContext requestContext, Map<String, String> extraParams) {
        if (requestContext == null) {
            throw new NullPointerException("requestContext");
        }
        ApiOperation apiOperation = requestContext.getApiOperation();
        String path = apiOperation.getRequestPath().normalised();
        List operationParams = apiOperation.getOperation().getParameters();
        Map<String, String> requestParams = requestContext.getParameters();
        UriBuilder builder = UriBuilder.fromPath((String)requestContext.getBaseUri()).path(path);
        operationParams.stream().filter(AbstractLinkSchemaMapper::isQueryParameter).map(AbstractLinkSchemaMapper::castToQueryParameter).filter(p -> requestParams.get(p.getName()) != null).filter(p -> p.getDefault() == null || !((String)requestParams.get(p.getName())).equals(p.getDefault().toString())).forEach(p -> builder.queryParam(p.getName(), new Object[]{requestParams.get(p.getName())}));
        if (extraParams != null) {
            extraParams.forEach((x$0, xva$1) -> builder.replaceQueryParam(x$0, new Object[]{xva$1}));
        }
        return builder.buildFromMap(requestContext.getParameters());
    }

    protected static IntegerTermParameter getPageTermParameter(@NonNull RequestContext requestContext) {
        if (requestContext == null) {
            throw new NullPointerException("requestContext");
        }
        return AbstractLinkSchemaMapper.getTermParameter(requestContext.getInformationProduct(), ELMO.PAGE_PARAMETER);
    }

    protected static IntegerTermParameter getPageSizeTermParameter(@NonNull RequestContext requestContext) {
        if (requestContext == null) {
            throw new NullPointerException("requestContext");
        }
        return AbstractLinkSchemaMapper.getTermParameter(requestContext.getInformationProduct(), ELMO.PAGE_SIZE_PARAMETER);
    }

    private static IntegerTermParameter getTermParameter(InformationProduct informationProduct, IRI termParameter) {
        return informationProduct.getParameters().stream().filter(p -> p.getIdentifier().equals(termParameter)).map(p -> (IntegerTermParameter)p).findFirst().orElseThrow(() -> new SchemaMapperRuntimeException(String.format("Information product requires a <%s> parameter.", termParameter)));
    }

    protected static QueryParameter getPageQueryParameter(@NonNull RequestContext requestContext) {
        if (requestContext == null) {
            throw new NullPointerException("requestContext");
        }
        return AbstractLinkSchemaMapper.getQueryParameter(requestContext, ELMO.PAGE_PARAMETER);
    }

    private static QueryParameter getQueryParameter(RequestContext requestContext, IRI termParameter) {
        List operationParams = requestContext.getApiOperation().getOperation().getParameters();
        return operationParams.stream().filter(AbstractLinkSchemaMapper::isQueryParameter).map(AbstractLinkSchemaMapper::castToQueryParameter).filter(p -> AbstractLinkSchemaMapper.mapsToTermParameter(p, termParameter)).findFirst().orElseThrow(() -> new SchemaMapperRuntimeException(String.format("API operation requires a <%s> query parameter.", termParameter)));
    }

    private static boolean isQueryParameter(Parameter parameter) {
        return parameter.getIn().equalsIgnoreCase("query");
    }

    private static QueryParameter castToQueryParameter(Parameter parameter) {
        return (QueryParameter)parameter;
    }

    private static boolean mapsToTermParameter(QueryParameter parameter, IRI termParameter) {
        if (parameter.getVendorExtensions() == null) {
            return false;
        }
        return termParameter.stringValue().equals(parameter.getVendorExtensions().get(OpenApiSpecificationExtensions.PARAMETER));
    }
}

