/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import com.google.common.base.Joiner;
import io.swagger.models.properties.Property;
import java.util.Collection;
import java.util.Set;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperRuntimeException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;

public abstract class AbstractSchemaMapper<S extends Property, T>
implements SchemaMapper<S, T> {
    protected static Value getSingleStatement(@NonNull Collection<Value> queryResult, @NonNull String ldPathQuery) {
        if (queryResult == null) {
            throw new NullPointerException("queryResult");
        }
        if (ldPathQuery == null) {
            throw new NullPointerException("ldPathQuery");
        }
        if (queryResult.isEmpty()) {
            throw new SchemaMapperRuntimeException(String.format("No results for LDPath query '%s' for required property.", ldPathQuery));
        }
        if (queryResult.size() > 1) {
            throw new SchemaMapperRuntimeException(String.format("LDPath query '%s' yielded multiple results (%s) for a property, which requires a single result.", ldPathQuery, queryResult.size()));
        }
        return queryResult.iterator().next();
    }

    protected abstract Set<IRI> getSupportedDataTypes();

    protected String dataTypesAsString() {
        return Joiner.on((String)", ").join(this.getSupportedDataTypes());
    }

    private boolean isDataTypeSupported(Literal value) {
        if (value == null) {
            return false;
        }
        IRI literalDataType = value.getDatatype();
        for (IRI dt : this.getSupportedDataTypes()) {
            if (!literalDataType.equals((Object)dt)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasVendorExtensionWithValue(@NonNull Property property, @NonNull String extension, Object value) {
        if (property == null) {
            throw new NullPointerException("property");
        }
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return AbstractSchemaMapper.hasVendorExtension(property, extension) && property.getVendorExtensions().get(extension).equals(value);
    }

    protected static boolean hasVendorExtension(@NonNull Property property, @NonNull String extension) {
        if (property == null) {
            throw new NullPointerException("property");
        }
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return property.getVendorExtensions().containsKey(extension);
    }

    protected boolean isSupportedLiteral(Object value) {
        return value instanceof Literal && this.isDataTypeSupported((Literal)value);
    }
}

