/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import io.swagger.models.properties.Property;
import java.util.Set;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntity;
import org.dotwebstack.framework.frontend.openapi.entity.schema.AbstractSchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperRuntimeException;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

abstract class AbstractSubjectSchemaMapper<S extends Property, T>
extends AbstractSchemaMapper<S, T> {
    AbstractSubjectSchemaMapper() {
    }

    protected static boolean hasSubjectVendorExtension(@NonNull Property schema) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        return AbstractSubjectSchemaMapper.hasVendorExtension(schema, OpenApiSpecificationExtensions.SUBJECT) && (Boolean)schema.getVendorExtensions().get(OpenApiSpecificationExtensions.SUBJECT) != false;
    }

    protected static Value getSubject(@NonNull Property schema, @NonNull GraphEntity graphEntity) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (graphEntity == null) {
            throw new NullPointerException("graphEntity");
        }
        Set<Resource> subjects = graphEntity.getSubjects();
        if (subjects.isEmpty()) {
            if (schema.getRequired()) {
                throw new SchemaMapperRuntimeException("Expected a single subject, but subject query yielded no results.");
            }
            return null;
        }
        if (subjects.size() > 1) {
            throw new SchemaMapperRuntimeException("Expected a single subject, but subject query yielded multiple results.");
        }
        return (Value)subjects.iterator().next();
    }
}

