/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import com.google.common.collect.ImmutableSet;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.Property;
import java.util.Collection;
import java.util.Set;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntity;
import org.dotwebstack.framework.frontend.openapi.entity.LdPathExecutor;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntity;
import org.dotwebstack.framework.frontend.openapi.entity.schema.AbstractSchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperAdapter;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperRuntimeException;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperUtils;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ValueContext;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.springframework.stereotype.Service;

@Service
class DoubleSchemaMapper
extends AbstractSchemaMapper<DoubleProperty, Double> {
    private static final Set<IRI> SUPPORTED_TYPES = ImmutableSet.of((Object)XMLSchema.DOUBLE, (Object)XMLSchema.DOUBLE);

    DoubleSchemaMapper() {
    }

    @Override
    public Double mapTupleValue(@NonNull DoubleProperty schema, @NonNull TupleEntity entity, @NonNull ValueContext valueContext) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        return SchemaMapperUtils.castLiteralValue(valueContext.getValue()).doubleValue();
    }

    @Override
    public Double mapGraphValue(@NonNull DoubleProperty schema, @NonNull GraphEntity entity, @NonNull ValueContext valueContext, @NonNull SchemaMapperAdapter schemaMapperAdapter) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        if (schemaMapperAdapter == null) {
            throw new NullPointerException("schemaMapperAdapter");
        }
        String ldPathQuery = (String)schema.getVendorExtensions().get(OpenApiSpecificationExtensions.LDPATH);
        if (ldPathQuery == null && this.isSupportedLiteral(valueContext.getValue())) {
            return ((Literal)valueContext.getValue()).doubleValue();
        }
        if (ldPathQuery == null) {
            throw new SchemaMapperRuntimeException(String.format("Property '%s' must have a '%s' attribute.", schema.getName(), OpenApiSpecificationExtensions.LDPATH));
        }
        LdPathExecutor ldPathExecutor = entity.getLdPathExecutor();
        Collection<Value> queryResult = ldPathExecutor.ldPathQuery(valueContext.getValue(), ldPathQuery);
        if (!schema.getRequired() && queryResult.isEmpty()) {
            return null;
        }
        Value doubleValue = DoubleSchemaMapper.getSingleStatement(queryResult, ldPathQuery);
        if (!this.isSupportedLiteral(doubleValue)) {
            throw new SchemaMapperRuntimeException(String.format("LDPath query '%s' yielded a value which is not a literal of supported type: <%s>.", ldPathQuery, this.dataTypesAsString()));
        }
        return ((Literal)doubleValue).doubleValue();
    }

    @Override
    public boolean supports(@NonNull Property schema) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        return schema instanceof DoubleProperty;
    }

    @Override
    protected Set<IRI> getSupportedDataTypes() {
        return SUPPORTED_TYPES;
    }
}

