/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import java.math.BigInteger;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntity;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntity;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperAdapter;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperUtils;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ValueContext;
import org.springframework.stereotype.Service;

@Service
public class LongSchemaMapper
implements SchemaMapper<LongProperty, BigInteger> {
    @Override
    public BigInteger mapTupleValue(@NonNull LongProperty schema, @NonNull TupleEntity entity, @NonNull ValueContext valueContext) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        return SchemaMapperUtils.castLiteralValue(valueContext.getValue()).integerValue();
    }

    @Override
    public BigInteger mapGraphValue(@NonNull LongProperty schema, @NonNull GraphEntity entity, @NotNull ValueContext valueContext, @NonNull SchemaMapperAdapter schemaMapperAdapter) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (schemaMapperAdapter == null) {
            throw new NullPointerException("schemaMapperAdapter");
        }
        return SchemaMapperUtils.castLiteralValue(valueContext.getValue()).integerValue();
    }

    @Override
    public boolean supports(@NonNull Property schema) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        return schema instanceof LongProperty;
    }
}

