/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import com.google.common.collect.ImmutableMap;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import java.util.Map;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntity;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntity;
import org.dotwebstack.framework.frontend.openapi.entity.schema.AbstractLinkSchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperAdapter;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperUtils;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ValueContext;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestContext;
import org.springframework.stereotype.Service;

@Service
public class NextLinkSchemaMapper
extends AbstractLinkSchemaMapper {
    @Override
    public Object mapTupleValue(@NonNull ObjectProperty schema, @NonNull TupleEntity entity, @NonNull ValueContext valueContext) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object mapGraphValue(@NonNull ObjectProperty schema, @NonNull GraphEntity entity, @NonNull ValueContext valueContext, @NonNull SchemaMapperAdapter schemaMapperAdapter) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        if (schemaMapperAdapter == null) {
            throw new NullPointerException("schemaMapperAdapter");
        }
        RequestContext requestContext = entity.getRequestContext();
        int pageSize = (Integer)NextLinkSchemaMapper.getPageSizeTermParameter(requestContext).handle(requestContext.getParameters());
        if (entity.getSubjects().size() < pageSize) {
            return null;
        }
        int page = (Integer)NextLinkSchemaMapper.getPageTermParameter(requestContext).handle(requestContext.getParameters());
        ImmutableMap extraParams = ImmutableMap.of((Object)NextLinkSchemaMapper.getPageQueryParameter(requestContext).getName(), (Object)Integer.toString(page + 1));
        return SchemaMapperUtils.createLink(NextLinkSchemaMapper.buildUri(requestContext, (Map<String, String>)extraParams));
    }

    @Override
    public boolean supports(Property schema) {
        return schema instanceof ObjectProperty && "next-link".equals(schema.getVendorExtensions().get(OpenApiSpecificationExtensions.TYPE));
    }
}

