/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntity;
import org.dotwebstack.framework.frontend.openapi.entity.LdPathExecutor;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntity;
import org.dotwebstack.framework.frontend.openapi.entity.schema.AbstractSubjectSchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperAdapter;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperRuntimeException;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ValueContext;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.springframework.stereotype.Service;

@Service
public class ObjectSchemaMapper
extends AbstractSubjectSchemaMapper<ObjectProperty, Object> {
    @Override
    public Object mapTupleValue(@NonNull ObjectProperty schema, @NonNull TupleEntity entity, @NonNull ValueContext valueContext) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object mapGraphValue(@NonNull ObjectProperty schema, @NonNull GraphEntity entity, @NonNull ValueContext valueContext, @NonNull SchemaMapperAdapter schemaMapperAdapter) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        if (schemaMapperAdapter == null) {
            throw new NullPointerException("schemaMapperAdapter");
        }
        ValueContext newValueContext = ObjectSchemaMapper.populateValueContextWithVendorExtensions((Property)schema, valueContext);
        return this.handleProperty(schema, entity, newValueContext, schemaMapperAdapter);
    }

    private static ValueContext populateValueContextWithVendorExtensions(@NonNull Property schema, @NonNull ValueContext valueContext) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        ValueContext.ValueContextBuilder builder = valueContext.toBuilder();
        if (ObjectSchemaMapper.hasVendorExtension(schema, OpenApiSpecificationExtensions.EXCLUDE_PROPERTIES_WHEN_EMPTY_OR_NULL)) {
            builder.isExcludedWhenEmptyOrNull(ObjectSchemaMapper.hasVendorExtensionExcludePropertiesWhenEmptyOrNull(schema));
        }
        return builder.build();
    }

    private static boolean hasVendorExtensionExcludePropertiesWhenEmptyOrNull(Property propValue) {
        return ObjectSchemaMapper.hasVendorExtensionWithValue(propValue, OpenApiSpecificationExtensions.EXCLUDE_PROPERTIES_WHEN_EMPTY_OR_NULL, true);
    }

    private Object handleProperty(ObjectProperty property, GraphEntity graphEntity, ValueContext valueContext, SchemaMapperAdapter schemaMapperAdapter) {
        ValueContext.ValueContextBuilder builder = valueContext.toBuilder();
        if (ObjectSchemaMapper.hasSubjectVendorExtension((Property)property)) {
            Value value = ObjectSchemaMapper.getSubject((Property)property, graphEntity);
            if (value == null) {
                return null;
            }
            builder.value(value);
        }
        ValueContext newValueContext = builder.build();
        if (ObjectSchemaMapper.hasVendorExtension((Property)property, OpenApiSpecificationExtensions.LDPATH)) {
            String ldPath = property.getVendorExtensions().get(OpenApiSpecificationExtensions.LDPATH).toString();
            return this.handleLdPathVendorExtension(property, graphEntity, newValueContext, ldPath, schemaMapperAdapter);
        }
        return this.handleProperties(property, graphEntity, newValueContext, schemaMapperAdapter);
    }

    private Map<String, Object> handleLdPathVendorExtension(ObjectProperty property, GraphEntity graphEntity, ValueContext valueContext, String ldPathQuery, SchemaMapperAdapter schemaMapperAdapter) {
        LdPathExecutor ldPathExecutor = graphEntity.getLdPathExecutor();
        Collection<Value> queryResult = ldPathExecutor.ldPathQuery(valueContext.getValue(), ldPathQuery);
        if (queryResult.isEmpty()) {
            if (!property.getRequired()) {
                return null;
            }
            throw new SchemaMapperRuntimeException(String.format("LDPath expression for a required object property ('%s') yielded no result.", ldPathQuery));
        }
        if (queryResult.size() > 1) {
            throw new SchemaMapperRuntimeException(String.format("LDPath expression for object property ('%s') yielded multiple elements.", ldPathQuery));
        }
        ValueContext newValueContext = valueContext.toBuilder().value(queryResult.iterator().next()).build();
        return this.handleProperties(property, graphEntity, newValueContext, schemaMapperAdapter);
    }

    private Map<String, Object> handleProperties(ObjectProperty property, GraphEntity entityBuilderContext, ValueContext valueContext, SchemaMapperAdapter schemaMapperAdapter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        property.getProperties().forEach((propKey, propValue) -> {
            Object propertyResult = schemaMapperAdapter.mapGraphValue(propValue, entityBuilderContext, valueContext, schemaMapperAdapter);
            if (!ObjectSchemaMapper.isExcludedWhenEmptyOrNull(valueContext, propValue, propertyResult)) {
                builder.put(propKey, (Object)Optional.fromNullable((Object)propertyResult));
            }
        });
        return builder.build();
    }

    private static boolean isExcludedWhenEmptyOrNull(@NonNull ValueContext context, @NonNull Property property, Object value) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (property == null) {
            throw new NullPointerException("property");
        }
        return context.isExcludedWhenEmptyOrNull() && (value == null || property instanceof ArrayProperty && ((Collection)value).isEmpty());
    }

    @Override
    public boolean supports(@NonNull Property schema) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        return schema instanceof ObjectProperty && !schema.getVendorExtensions().containsKey(OpenApiSpecificationExtensions.TYPE);
    }

    @Override
    protected Set<IRI> getSupportedDataTypes() {
        return ImmutableSet.of();
    }
}

