/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntity;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntity;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperAdapter;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperRuntimeException;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ValueContext;
import org.springframework.stereotype.Service;

@Service
public class RefSchemaMapper
implements SchemaMapper<RefProperty, Object> {
    @Override
    public Object mapTupleValue(RefProperty schema, @NonNull TupleEntity entity, ValueContext valueContext) {
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        throw new UnsupportedOperationException("Tuple query not supported.");
    }

    @Override
    public Object mapGraphValue(@NonNull RefProperty schema, @NonNull GraphEntity entity, @NonNull ValueContext valueContext, @NonNull SchemaMapperAdapter schemaMapperAdapter) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        if (schemaMapperAdapter == null) {
            throw new NullPointerException("schemaMapperAdapter");
        }
        Model refModel = entity.getSwaggerDefinitions().get(schema.getSimpleRef());
        if (refModel == null) {
            throw new SchemaMapperRuntimeException(String.format("Unable to resolve reference to swagger model: '%s'.", schema.getSimpleRef()));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        refModel.getProperties().forEach((propKey, propValue) -> builder.put(propKey, (Object)Optional.fromNullable((Object)schemaMapperAdapter.mapGraphValue(propValue, entity, valueContext, schemaMapperAdapter))));
        return builder.build();
    }

    @Override
    public boolean supports(@NonNull Property property) {
        if (property == null) {
            throw new NullPointerException("property");
        }
        return RefProperty.class.isInstance(property);
    }
}

