/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import com.google.common.collect.ImmutableSet;
import io.swagger.models.properties.Property;
import java.util.Set;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntity;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntity;
import org.dotwebstack.framework.frontend.openapi.entity.schema.AbstractSubjectSchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ResponseProperty;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperAdapter;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ValueContext;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.springframework.stereotype.Service;

@Service
public class ResponseSchemaMapper
extends AbstractSubjectSchemaMapper<ResponseProperty, Object> {
    @Override
    public Object mapTupleValue(@NonNull ResponseProperty schema, @NonNull TupleEntity entity, @NonNull ValueContext valueContext) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object mapGraphValue(@NonNull ResponseProperty schema, @NonNull GraphEntity entity, @NonNull ValueContext valueContext, @NonNull SchemaMapperAdapter schemaMapperAdapter) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        if (schemaMapperAdapter == null) {
            throw new NullPointerException("schemaMapperAdapter");
        }
        ValueContext.ValueContextBuilder builder = valueContext.toBuilder();
        if (ResponseSchemaMapper.hasSubjectVendorExtension(schema)) {
            Value value = ResponseSchemaMapper.getSubject(schema, entity);
            if (value == null) {
                return null;
            }
            builder.value(value);
        }
        return schemaMapperAdapter.mapGraphValue(schema.getSchema(), entity, builder.build(), schemaMapperAdapter);
    }

    @Override
    public boolean supports(Property schema) {
        return schema instanceof ResponseProperty;
    }

    @Override
    protected Set<IRI> getSupportedDataTypes() {
        return ImmutableSet.of();
    }
}

