/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.entity.schema;

import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntity;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntity;
import org.dotwebstack.framework.frontend.openapi.entity.schema.AbstractLinkSchemaMapper;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperAdapter;
import org.dotwebstack.framework.frontend.openapi.entity.schema.SchemaMapperUtils;
import org.dotwebstack.framework.frontend.openapi.entity.schema.ValueContext;
import org.springframework.stereotype.Service;

@Service
public class SelfLinkSchemaMapper
extends AbstractLinkSchemaMapper {
    @Override
    public Object mapTupleValue(@NonNull ObjectProperty schema, @NonNull TupleEntity entity, @NonNull ValueContext valueContext) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        return SchemaMapperUtils.createLink(SelfLinkSchemaMapper.buildUri(entity.getRequestContext(), null));
    }

    @Override
    public Object mapGraphValue(@NonNull ObjectProperty schema, @NonNull GraphEntity entity, @NonNull ValueContext valueContext, @NonNull SchemaMapperAdapter schemaMapperAdapter) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        if (valueContext == null) {
            throw new NullPointerException("valueContext");
        }
        if (schemaMapperAdapter == null) {
            throw new NullPointerException("schemaMapperAdapter");
        }
        return SchemaMapperUtils.createLink(SelfLinkSchemaMapper.buildUri(entity.getRequestContext(), null));
    }

    @Override
    public boolean supports(Property schema) {
        return schema instanceof ObjectProperty && "self-link".equals(schema.getVendorExtensions().get(OpenApiSpecificationExtensions.TYPE));
    }
}

