/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.handlers;

import com.atlassian.oai.validator.interaction.RequestValidator;
import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.report.ValidationReport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.swagger.models.Swagger;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestParameterExtractor;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestParameters;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApiRequestValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ApiRequestValidator.class);
    private static final List<String> FILTERED_HEADERS = ImmutableList.of((Object)"accept", (Object)"content-type");
    private final RequestValidator requestValidator;
    private final RequestParameterExtractor requestParameterExtractor;

    ApiRequestValidator(@NonNull RequestValidator requestValidator, @NonNull RequestParameterExtractor requestParameterExtractor) {
        if (requestValidator == null) {
            throw new NullPointerException("requestValidator");
        }
        if (requestParameterExtractor == null) {
            throw new NullPointerException("requestParameterExtractor");
        }
        this.requestValidator = requestValidator;
        this.requestParameterExtractor = requestParameterExtractor;
    }

    RequestParameters validate(@NonNull ApiOperation apiOperation, @NonNull Swagger swagger, @NonNull ContainerRequestContext requestContext) {
        if (apiOperation == null) {
            throw new NullPointerException("apiOperation");
        }
        if (swagger == null) {
            throw new NullPointerException("swagger");
        }
        if (requestContext == null) {
            throw new NullPointerException("requestContext");
        }
        String strMethod = requestContext.getMethod();
        Request.Method method = Request.Method.valueOf((String)strMethod.toUpperCase());
        SimpleRequest.Builder builder = new SimpleRequest.Builder(method, requestContext.getUriInfo().getPath());
        requestContext.getHeaders().entrySet().stream().filter(entry -> !FILTERED_HEADERS.contains(((String)entry.getKey()).toLowerCase())).forEach(entry -> builder.withHeader((String)entry.getKey(), (List)entry.getValue()));
        requestContext.getUriInfo().getPathParameters().forEach((arg_0, arg_1) -> ((SimpleRequest.Builder)builder).withQueryParam(arg_0, arg_1));
        requestContext.getUriInfo().getQueryParameters().forEach((arg_0, arg_1) -> ((SimpleRequest.Builder)builder).withQueryParam(arg_0, arg_1));
        RequestParameters requestParameters = this.requestParameterExtractor.extract(apiOperation, swagger, requestContext);
        String body = requestParameters.getRawBody();
        builder.withBody(body);
        ValidationReport report = this.requestValidator.validateRequest((Request)builder.build(), apiOperation);
        if (report.hasErrors()) {
            LOG.error("Request parameter validation failed, with following errors: {}", (Object)report.getMessages());
            throw this.createException(report);
        }
        return requestParameters;
    }

    private RequestValidationException createException(ValidationReport report) {
        ImmutableList.Builder invalidParamsBuilder = new ImmutableList.Builder();
        report.getMessages().forEach(message -> {
            ImmutableMap.Builder paramBuilder = new ImmutableMap.Builder();
            paramBuilder.put((Object)"name", (Object)message.getKey());
            paramBuilder.put((Object)"reason", (Object)message.getMessage());
            invalidParamsBuilder.add((Object)paramBuilder.build());
        });
        ImmutableMap details = ImmutableMap.of((Object)"invalid-params", (Object)invalidParamsBuilder.build());
        return new RequestValidationException("Request parameters didn't validate.", Response.Status.BAD_REQUEST, (Map<String, Object>)details);
    }
}

