/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.handlers;

import com.google.common.collect.Sets;
import io.swagger.models.HttpMethod;
import io.swagger.models.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.glassfish.jersey.process.Inflector;

public class OptionsRequestHandler
implements Inflector<ContainerRequestContext, Response> {
    private final Path path;

    public OptionsRequestHandler(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path = path;
    }

    public Response apply(@NonNull ContainerRequestContext containerRequestContext) {
        if (containerRequestContext == null) {
            throw new NullPointerException("containerRequestContext");
        }
        containerRequestContext.setProperty("path", (Object)this.path);
        HashSet allowedMethods = Sets.newHashSet(this.path.getOperationMap().keySet());
        allowedMethods.add(HttpMethod.HEAD);
        allowedMethods.add(HttpMethod.OPTIONS);
        Set allowHeader = allowedMethods.stream().map(Object::toString).collect(Collectors.toSet());
        return Response.ok().allow(allowHeader).build();
    }
}

