/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.handlers;

import com.atlassian.oai.validator.model.ApiOperation;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Map;
import lombok.NonNull;
import org.dotwebstack.framework.informationproduct.InformationProduct;

public final class RequestContext {
    private final ApiOperation apiOperation;
    private final InformationProduct informationProduct;
    private final Map<String, String> parameters;
    private final String baseUri;

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void addParameter(@NonNull String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.parameters.put(key, value);
    }

    public ApiOperation getApiOperation() {
        return this.apiOperation;
    }

    public InformationProduct getInformationProduct() {
        return this.informationProduct;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    @ConstructorProperties(value={"apiOperation", "informationProduct", "parameters", "baseUri"})
    public RequestContext(ApiOperation apiOperation, InformationProduct informationProduct, Map<String, String> parameters, String baseUri) {
        this.apiOperation = apiOperation;
        this.informationProduct = informationProduct;
        this.parameters = parameters;
        this.baseUri = baseUri;
    }
}

