/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.handlers;

import com.atlassian.oai.validator.model.ApiOperation;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.dotwebstack.framework.backend.ResultType;
import org.dotwebstack.framework.config.ConfigurationException;
import org.dotwebstack.framework.frontend.openapi.BaseUriFactory;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.Rdf4jUtils;
import org.dotwebstack.framework.frontend.openapi.entity.Entity;
import org.dotwebstack.framework.frontend.openapi.entity.GraphEntity;
import org.dotwebstack.framework.frontend.openapi.entity.TupleEntity;
import org.dotwebstack.framework.frontend.openapi.handlers.ApiRequestValidator;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestContext;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestHandlerRuntimeException;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestParameterMapper;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestParameters;
import org.dotwebstack.framework.informationproduct.InformationProduct;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ContainerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestHandler
implements Inflector<ContainerRequestContext, javax.ws.rs.core.Response> {
    private static final Logger LOG = LoggerFactory.getLogger(RequestHandler.class);
    private final ApiOperation apiOperation;
    private final InformationProduct informationProduct;
    private final Response response;
    private final RequestParameterMapper requestParameterMapper;
    private final Swagger swagger;
    private final ApiRequestValidator apiRequestValidator;

    RequestHandler(@NonNull ApiOperation apiOperation, @NonNull InformationProduct informationProduct, @NonNull Response response, @NonNull RequestParameterMapper requestParameterMapper, @NonNull ApiRequestValidator apiRequestValidator, @NonNull Swagger swagger) {
        if (apiOperation == null) {
            throw new NullPointerException("apiOperation");
        }
        if (informationProduct == null) {
            throw new NullPointerException("informationProduct");
        }
        if (response == null) {
            throw new NullPointerException("response");
        }
        if (requestParameterMapper == null) {
            throw new NullPointerException("requestParameterMapper");
        }
        if (apiRequestValidator == null) {
            throw new NullPointerException("apiRequestValidator");
        }
        if (swagger == null) {
            throw new NullPointerException("swagger");
        }
        this.apiRequestValidator = apiRequestValidator;
        this.apiOperation = apiOperation;
        this.informationProduct = informationProduct;
        this.response = response;
        this.requestParameterMapper = requestParameterMapper;
        this.swagger = swagger;
    }

    public javax.ws.rs.core.Response apply(@NonNull ContainerRequestContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        UriInfo uriInfo = context.getUriInfo();
        String path = uriInfo.getPath();
        LOG.debug("Handling {} request for path {}", (Object)context.getMethod(), (Object)path);
        Operation operation = this.apiOperation.getOperation();
        context.setProperty("operation", (Object)operation);
        RequestParameters requestParameters = this.apiRequestValidator.validate(this.apiOperation, this.swagger, context);
        Map<String, String> parameterValues = this.requestParameterMapper.map(operation, this.informationProduct, requestParameters);
        String baseUri = BaseUriFactory.newBaseUri((ContainerRequest)context, this.swagger);
        RequestContext requestContext = new RequestContext(this.apiOperation, this.informationProduct, parameterValues, baseUri);
        if (ResultType.TUPLE.equals((Object)this.informationProduct.getResultType())) {
            TupleQueryResult result = (TupleQueryResult)this.informationProduct.getResult(parameterValues);
            TupleEntity entity = TupleEntity.builder().withResult(result).withResponse(this.response).withRequestContext(requestContext).build();
            return this.responseOk(entity);
        }
        if (ResultType.GRAPH.equals((Object)this.informationProduct.getResultType())) {
            GraphQueryResult result = (GraphQueryResult)this.informationProduct.getResult(parameterValues);
            Repository resultRepository = Rdf4jUtils.asRepository(QueryResults.asModel((CloseableIteration)result));
            Set<Resource> subjects = this.getSubjects(resultRepository);
            if (subjects.isEmpty() && this.is404ResponseDefined()) {
                throw new NotFoundException();
            }
            GraphEntity entity = GraphEntity.newGraphEntity(this.response, resultRepository, subjects, this.swagger, requestContext);
            return this.responseOk(entity);
        }
        LOG.error("Result type {} not supported for information product {}", (Object)this.informationProduct.getResultType(), (Object)this.informationProduct.getIdentifier());
        return javax.ws.rs.core.Response.serverError().build();
    }

    private Set<Resource> getSubjects(Repository repository) {
        String subjectQuery = (String)this.apiOperation.getOperation().getVendorExtensions().get(OpenApiSpecificationExtensions.SUBJECT_QUERY);
        if (subjectQuery == null) {
            throw new ConfigurationException(String.format("Vendor extension '%s' is required for information products with graph result type", OpenApiSpecificationExtensions.SUBJECT_QUERY));
        }
        try {
            return Rdf4jUtils.evaluateSingleBindingSelectQuery(repository, subjectQuery);
        }
        catch (QueryEvaluationException e) {
            throw new RequestHandlerRuntimeException((Exception)((Object)e));
        }
    }

    private boolean is404ResponseDefined() {
        String statusCode = String.valueOf(Response.Status.NOT_FOUND.getStatusCode());
        return this.apiOperation.getOperation().getResponses().containsKey(statusCode);
    }

    private javax.ws.rs.core.Response responseOk(Entity entity) {
        if (entity != null) {
            return javax.ws.rs.core.Response.ok((Object)entity).build();
        }
        return null;
    }

    InformationProduct getInformationProduct() {
        return this.informationProduct;
    }

    Response getResponse() {
        return this.response;
    }
}

