/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.handlers;

import com.atlassian.oai.validator.model.ApiOperation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.SwaggerUtils;
import org.dotwebstack.framework.frontend.openapi.handlers.ApiRequestValidator;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestHandler;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestParameterExtractor;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestParameterMapper;
import org.dotwebstack.framework.informationproduct.InformationProduct;
import org.springframework.stereotype.Service;

@Service
public class RequestHandlerFactory {
    private final RequestParameterMapper requestParameterMapper;
    private final RequestParameterExtractor requestParameterExtractor;

    public RequestHandlerFactory(@NonNull RequestParameterMapper requestParameterMapper, @NonNull RequestParameterExtractor requestParameterExtractor) {
        if (requestParameterMapper == null) {
            throw new NullPointerException("requestParameterMapper");
        }
        if (requestParameterExtractor == null) {
            throw new NullPointerException("requestParameterExtractor");
        }
        this.requestParameterMapper = requestParameterMapper;
        this.requestParameterExtractor = requestParameterExtractor;
    }

    public RequestHandler newRequestHandler(@NonNull ApiOperation apiOperation, @NonNull InformationProduct informationProduct, @NonNull Response response, @NonNull Swagger swagger) {
        if (apiOperation == null) {
            throw new NullPointerException("apiOperation");
        }
        if (informationProduct == null) {
            throw new NullPointerException("informationProduct");
        }
        if (response == null) {
            throw new NullPointerException("response");
        }
        if (swagger == null) {
            throw new NullPointerException("swagger");
        }
        return new RequestHandler(apiOperation, informationProduct, response, this.requestParameterMapper, new ApiRequestValidator(SwaggerUtils.createValidator(swagger), this.requestParameterExtractor), swagger);
    }
}

