/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.handlers;

import com.atlassian.oai.validator.model.ApiOperation;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.ContentType;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
class RequestParameterExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestParameterExtractor.class);
    static final String PARAM_GEOMETRY_QUERYTYPE = "geometry_querytype";
    static final String PARAM_GEOMETRY = "geometry";
    static final String PARAM_PAGE_NUM = "page";
    static final String PARAM_PAGE_SIZE = "size";
    private final ObjectMapper objectMapper;

    RequestParameterExtractor(@NonNull ObjectMapper objectMapper) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper");
        }
        this.objectMapper = objectMapper;
    }

    RequestParameters extract(@NonNull ApiOperation apiOperation, @NonNull Swagger swagger, @NonNull ContainerRequestContext containerRequestContext) {
        if (apiOperation == null) {
            throw new NullPointerException("apiOperation");
        }
        if (swagger == null) {
            throw new NullPointerException("swagger");
        }
        if (containerRequestContext == null) {
            throw new NullPointerException("containerRequestContext");
        }
        UriInfo uriInfo = containerRequestContext.getUriInfo();
        RequestParameters parameters = new RequestParameters();
        parameters.putAll((MultivaluedMap<String, String>)uriInfo.getPathParameters());
        parameters.putAll((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        parameters.putAll((MultivaluedMap<String, String>)containerRequestContext.getHeaders());
        try {
            Optional<Parameter> parameter = apiOperation.getOperation().getParameters().stream().filter(parameterBody -> {
                if (parameterBody instanceof BodyParameter) {
                    ModelImpl parameterModel = RequestParameterExtractor.getBodyParameter(swagger, (BodyParameter)parameterBody);
                    return "object".equalsIgnoreCase(parameterModel.getType()) && "body".equalsIgnoreCase(parameterBody.getIn());
                }
                return false;
            }).findFirst();
            this.extractBodyParameter(parameters, containerRequestContext, parameter);
        }
        catch (IOException ioe) {
            throw new InternalServerErrorException("Error processing request body.", (Throwable)ioe);
        }
        LOG.info("Extracted parameters: {}", (Object)parameters);
        return parameters;
    }

    private static ModelImpl getBodyParameter(@NonNull Swagger swagger, BodyParameter parameterBody) {
        if (swagger == null) {
            throw new NullPointerException("swagger");
        }
        ModelImpl parameterModel = null;
        if (parameterBody.getSchema() instanceof ModelImpl) {
            parameterModel = (ModelImpl)parameterBody.getSchema();
        }
        if (parameterBody.getSchema() instanceof RefModel) {
            RefModel refModel = (RefModel)parameterBody.getSchema();
            parameterModel = (ModelImpl)swagger.getDefinitions().get(refModel.getSimpleRef());
        }
        return parameterModel;
    }

    private void extractBodyParameter(RequestParameters requestParameters, ContainerRequestContext ctx, Optional<Parameter> parameter) throws IOException {
        String body = RequestParameterExtractor.extractBody(ctx);
        if (body == null) {
            return;
        }
        requestParameters.setRawBody(body);
        if (!parameter.isPresent()) {
            return;
        }
        if (((List)ctx.getHeaders().get((Object)"Content-Type")).stream().filter(header -> ContentType.APPLICATION_JSON.toString().startsWith((String)header)).findAny().orElse(null) == null) {
            return;
        }
        Map json = (Map)this.objectMapper.readValue(body, Map.class);
        for (Map.Entry entry : json.entrySet()) {
            requestParameters.put((String)entry.getKey(), this.objectMapper.writeValueAsString(entry.getValue()));
        }
    }

    @Nullable
    private static String extractBody(ContainerRequestContext ctx) throws IOException {
        IsEmptyCheckInputStream inputStream = new IsEmptyCheckInputStream(ctx.getEntityStream());
        if (inputStream.isEmpty()) {
            return null;
        }
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)inputStream, (Writer)writer);
        return writer.toString();
    }

    private static final class IsEmptyCheckInputStream
    extends PushbackInputStream {
        private IsEmptyCheckInputStream(InputStream input) {
            super(input);
        }

        private boolean isEmpty() throws IOException {
            byte[] buf = new byte[1];
            int result = this.read(buf, 0, 1);
            if (result > 0) {
                this.unread(buf[0]);
                return false;
            }
            return true;
        }
    }
}

