/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.handlers;

import io.swagger.models.Operation;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.dotwebstack.framework.frontend.openapi.OpenApiSpecificationExtensions;
import org.dotwebstack.framework.frontend.openapi.handlers.RequestParameters;
import org.dotwebstack.framework.informationproduct.InformationProduct;
import org.dotwebstack.framework.informationproduct.InformationProductUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
class RequestParameterMapper {
    private static final Logger LOG = LoggerFactory.getLogger(RequestParameterMapper.class);

    RequestParameterMapper() {
    }

    Map<String, String> map(@NonNull Operation operation, @NonNull InformationProduct product, @NonNull RequestParameters requestParameters) {
        if (operation == null) {
            throw new NullPointerException("operation");
        }
        if (product == null) {
            throw new NullPointerException("product");
        }
        if (requestParameters == null) {
            throw new NullPointerException("requestParameters");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Parameter openApiParameter : operation.getParameters()) {
            if (openApiParameter instanceof BodyParameter) {
                Collection properties = ((BodyParameter)openApiParameter).getSchema().getProperties().values();
                for (Property property : properties) {
                    Map vendorExtensions = property.getVendorExtensions();
                    LOG.debug("Vendor extensions for property '{}' in parameter '{}': {}", new Object[]{property.getName(), openApiParameter.getName(), vendorExtensions});
                    Object parameterIdString = vendorExtensions.get(OpenApiSpecificationExtensions.PARAMETER);
                    if (parameterIdString == null) continue;
                    org.dotwebstack.framework.param.Parameter parameter = InformationProductUtils.getParameter((InformationProduct)product, (String)((String)parameterIdString));
                    String value = requestParameters.get(parameter.getName());
                    result.put(parameter.getName(), value);
                }
                continue;
            }
            Map vendorExtensions = openApiParameter.getVendorExtensions();
            LOG.debug("Vendor extensions for parameter '{}': {}", (Object)openApiParameter.getName(), (Object)vendorExtensions);
            Object parameterIdString = vendorExtensions.get(OpenApiSpecificationExtensions.PARAMETER);
            if (parameterIdString == null) continue;
            org.dotwebstack.framework.param.Parameter parameter = InformationProductUtils.getParameter((InformationProduct)product, (String)((String)parameterIdString));
            String value = requestParameters.get(parameter.getName());
            result.put(parameter.getName(), value);
        }
        return result;
    }
}

