/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.ldpath;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.model.transformers.StringTransformer;
import org.apache.marmotta.ldpath.util.Collections;

public final class JoinFunction<N>
extends SelectorFunction<N> {
    private static final int MIN_NO_ARGS = 1;
    private final StringTransformer<N> transformer = new StringTransformer();

    @SafeVarargs
    public final Collection<N> apply(@NonNull RDFBackend<N> backend, N context, Collection<N> ... args) {
        if (backend == null) {
            throw new NullPointerException("backend");
        }
        if (args.length < 1) {
            throw new IllegalArgumentException(String.format("LdPath function '%s' requires at least %d argument.", this.getLocalName(), 1));
        }
        Iterator iterator = Collections.iterator((int)1, (Collection[])args);
        ImmutableList.Builder builder = ImmutableList.builder();
        while (iterator.hasNext()) {
            String result = this.transformer.transform(backend, iterator.next(), null);
            if (StringUtils.isBlank((CharSequence)result)) continue;
            builder.add((Object)result);
        }
        String delimiter = backend.stringValue(args[0].iterator().next());
        String joined = String.join((CharSequence)delimiter, (Iterable<? extends CharSequence>)builder.build());
        if (StringUtils.isBlank((CharSequence)joined)) {
            return java.util.Collections.emptyList();
        }
        return java.util.Collections.singleton(backend.createLiteral(joined));
    }

    public String getLocalName() {
        return "join";
    }

    public String getSignature() {
        return "fn:join(separator : String, nodes : NodeList) : String";
    }

    public String getDescription() {
        return "A node function joins a list of nodes interpreted as strings while separating them with the supplied separator";
    }
}

