/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.frontend.openapi.ldpath;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import lombok.NonNull;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;

public final class TrimFunction<N>
extends SelectorFunction<N> {
    private static final int NO_ARGS = 1;

    @SafeVarargs
    public final Collection<N> apply(@NonNull RDFBackend<N> backend, N context, Collection<N> ... args) {
        if (backend == null) {
            throw new NullPointerException("backend");
        }
        if (args.length != 1) {
            throw new IllegalArgumentException(String.format("LdPath function '%s' requires %d arguments.", this.getLocalName(), 1));
        }
        N node = args[0].iterator().next();
        String stringValue = backend.stringValue(node);
        String trimmedStringValue = stringValue.trim();
        Object literal = backend.createLiteral(trimmedStringValue);
        return ImmutableList.of((Object)literal);
    }

    public String getSignature() {
        return "fn:trim(node::Node) :: StringLiteral";
    }

    public String getDescription() {
        return "Trims the string representation of a node";
    }

    protected String getLocalName() {
        return "trim";
    }
}

