/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.cpp.generator;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.che.api.core.ConflictException;
import org.eclipse.che.api.core.ForbiddenException;
import org.eclipse.che.api.core.NotFoundException;
import org.eclipse.che.api.core.ServerException;
import org.eclipse.che.api.fs.server.FsManager;
import org.eclipse.che.api.fs.server.WsPathUtils;
import org.eclipse.che.api.project.server.handlers.CreateProjectHandler;
import org.eclipse.che.api.project.server.type.AttributeValue;
import org.eclipse.che.plugin.cpp.shared.Constants;

public class CppProjectGenerator
implements CreateProjectHandler {
    private static final String RESOURCE_NAME = "files/default_cpp_content";
    private static final String FILE_NAME = "hello.cpp";
    private final FsManager fsManager;

    @Inject
    public CppProjectGenerator(FsManager fsManager) {
        this.fsManager = fsManager;
    }

    public void onCreateProject(String projectWsPath, Map<String, AttributeValue> attributes, Map<String, String> options) throws ForbiddenException, ConflictException, ServerException, NotFoundException {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RESOURCE_NAME);){
            this.fsManager.createDir(projectWsPath);
            String wsPath = WsPathUtils.resolve((String)projectWsPath, (String)FILE_NAME);
            this.fsManager.createFile(wsPath, inputStream);
        }
        catch (IOException e) {
            throw new ServerException((Throwable)e);
        }
    }

    public String getProjectType() {
        return Constants.CPP_PROJECT_TYPE_ID;
    }
}

