/*******************************************************************************
 * Copyright (c) 2012-2016 Red Hat, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Red Hat, Inc. - initial API and implementation
 *******************************************************************************/


// GENERATED SOURCE. DO NOT EDIT.
package org.eclipse.che.plugin.github.ide.dto;

import org.eclipse.che.ide.dto.ClientDtoFactoryVisitor;
import org.eclipse.che.ide.dto.DtoFactoryVisitor;
import org.eclipse.che.ide.dto.JsonSerializable;
import com.google.gwt.json.client.*;
import com.google.inject.Singleton;


@SuppressWarnings({"unchecked", "cast", "MissingOverride"})
@Singleton
@ClientDtoFactoryVisitor
public class DtoClientImpls implements DtoFactoryVisitor {

  @Override
  public void accept(org.eclipse.che.ide.dto.DtoFactory dtoFactory) {
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.Collaborators.class, new org.eclipse.che.ide.dto.DtoProvider<org.eclipse.che.plugin.github.shared.Collaborators>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.Collaborators> getImplClass() {
            return CollaboratorsImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.Collaborators newInstance() {
            return CollaboratorsImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.Collaborators fromJson(String json) {
            return CollaboratorsImpl.fromJsonString(json);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubIssueComment.class, new org.eclipse.che.ide.dto.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubIssueComment>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubIssueComment> getImplClass() {
            return GitHubIssueCommentImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubIssueComment newInstance() {
            return GitHubIssueCommentImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubIssueComment fromJson(String json) {
            return GitHubIssueCommentImpl.fromJsonString(json);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput.class, new org.eclipse.che.ide.dto.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput> getImplClass() {
            return GitHubIssueCommentInputImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput newInstance() {
            return GitHubIssueCommentInputImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput fromJson(String json) {
            return GitHubIssueCommentInputImpl.fromJsonString(json);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubKey.class, new org.eclipse.che.ide.dto.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubKey>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubKey> getImplClass() {
            return GitHubKeyImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubKey newInstance() {
            return GitHubKeyImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubKey fromJson(String json) {
            return GitHubKeyImpl.fromJsonString(json);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubPullRequest.class, new org.eclipse.che.ide.dto.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubPullRequest>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubPullRequest> getImplClass() {
            return GitHubPullRequestImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequest newInstance() {
            return GitHubPullRequestImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequest fromJson(String json) {
            return GitHubPullRequestImpl.fromJsonString(json);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput.class, new org.eclipse.che.ide.dto.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput> getImplClass() {
            return GitHubPullRequestCreationInputImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput newInstance() {
            return GitHubPullRequestCreationInputImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput fromJson(String json) {
            return GitHubPullRequestCreationInputImpl.fromJsonString(json);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubPullRequestHead.class, new org.eclipse.che.ide.dto.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubPullRequestHead>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubPullRequestHead> getImplClass() {
            return GitHubPullRequestHeadImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead newInstance() {
            return GitHubPullRequestHeadImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead fromJson(String json) {
            return GitHubPullRequestHeadImpl.fromJsonString(json);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubPullRequestList.class, new org.eclipse.che.ide.dto.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubPullRequestList>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubPullRequestList> getImplClass() {
            return GitHubPullRequestListImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestList newInstance() {
            return GitHubPullRequestListImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestList fromJson(String json) {
            return GitHubPullRequestListImpl.fromJsonString(json);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubRepository.class, new org.eclipse.che.ide.dto.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubRepository>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubRepository> getImplClass() {
            return GitHubRepositoryImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubRepository newInstance() {
            return GitHubRepositoryImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubRepository fromJson(String json) {
            return GitHubRepositoryImpl.fromJsonString(json);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubRepositoryList.class, new org.eclipse.che.ide.dto.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubRepositoryList>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubRepositoryList> getImplClass() {
            return GitHubRepositoryListImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubRepositoryList newInstance() {
            return GitHubRepositoryListImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubRepositoryList fromJson(String json) {
            return GitHubRepositoryListImpl.fromJsonString(json);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubUser.class, new org.eclipse.che.ide.dto.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubUser>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubUser> getImplClass() {
            return GitHubUserImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubUser newInstance() {
            return GitHubUserImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubUser fromJson(String json) {
            return GitHubUserImpl.fromJsonString(json);
        }
    });
  }

  @org.eclipse.che.dto.shared.DTOImpl("client")
  public static class CollaboratorsImpl implements org.eclipse.che.plugin.github.shared.Collaborators, JsonSerializable  {

    public static CollaboratorsImpl make() {
        return new CollaboratorsImpl();
    }

    protected CollaboratorsImpl() {
    }

    protected java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser> collaborators;

    @Override
    public java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser> getCollaborators() {
      ensureCollaborators();
      return collaborators;
    }

    public void setCollaborators(java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser> v) {
      this.collaborators = v;
    }

    public void addCollaborators(org.eclipse.che.plugin.github.shared.GitHubUser v) {
      ensureCollaborators();
      collaborators.add(v);
    }

    public void clearCollaborators() {
      ensureCollaborators();
      collaborators.clear();
    }

    protected void ensureCollaborators() {
      if (collaborators == null) {
        collaborators = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubUser>();
      }
    }
    @Override
    public boolean equals(Object o) {
      if (!(o instanceof CollaboratorsImpl)) {
        return false;
      }
      CollaboratorsImpl other = (CollaboratorsImpl) o;
      if (this.collaborators != null) {
        if (!this.collaborators.equals(other.collaborators)) {
          return false;
        }
      } else {
        if (other.collaborators != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (collaborators != null ? collaborators.hashCode() : 0);
      return hash;
    }

    public JSONObject toJsonObject() {
      return toJsonObjectInt(true);
    }
    public JSONObject toJsonObjectInt(boolean copyJsons) {
      JSONObject result = new JSONObject();

      JSONArray collaboratorsOut = new JSONArray();
      this.ensureCollaborators();
      for (org.eclipse.che.plugin.github.shared.GitHubUser collaborators_ : this.collaborators) {
        JSONValue collaboratorsOut_ = collaborators_ == null ? JSONNull.getInstance() : ((GitHubUserImpl)collaborators_).toJsonObject();
        collaboratorsOut.set(collaboratorsOut.size(), collaboratorsOut_);
      }
      result.put("collaborators", collaboratorsOut);
      return result;
    }

    @Override
    public String toJson() {
      return toJsonObjectInt(false).toString();
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static CollaboratorsImpl fromJsonObject(JSONValue jsonValue) {
      return fromJsonObjectInt(jsonValue, true);
    }
    public static CollaboratorsImpl fromJsonObjectInt(JSONValue jsonValue, boolean copyJsons) {
      if (jsonValue == null || jsonValue.isNull() != null) {
        return null;
      }

      CollaboratorsImpl dto = new CollaboratorsImpl();
      JSONObject json = jsonValue.isObject();

      if (json.containsKey("collaborators")) {
        JSONValue collaboratorsIn = json.get("collaborators");
        java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser> collaboratorsOut = null;
        if (collaboratorsIn != null && collaboratorsIn.isNull() == null) {
          collaboratorsOut = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubUser>();
          for (int collaboratorsIn__iterator = 0; collaboratorsIn__iterator < collaboratorsIn.isArray().size(); collaboratorsIn__iterator++) {
            JSONValue collaboratorsIn_ = collaboratorsIn.isArray().get(collaboratorsIn__iterator);
            org.eclipse.che.plugin.github.shared.GitHubUser collaboratorsOut_ = GitHubUserImpl.fromJsonObject(collaboratorsIn_);
            collaboratorsOut.add(collaboratorsOut_);
          }
        }
        dto.setCollaborators(collaboratorsOut);
      }

      return dto;
    }

    public static CollaboratorsImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonObjectInt(JSONParser.parseStrict(jsonString), false);
    }

    public CollaboratorsImpl(org.eclipse.che.plugin.github.shared.Collaborators origin) {
      java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser> collaboratorsIn = origin.getCollaborators();
      if (collaboratorsIn != null) {
        java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser> collaboratorsOut = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubUser>();
        for (org.eclipse.che.plugin.github.shared.GitHubUser collaboratorsIn_ : collaboratorsIn) {
            collaboratorsOut.add(collaboratorsIn_ == null ? null : new GitHubUserImpl(collaboratorsIn_));
        }
        this.collaborators = collaboratorsOut;
      }
    }

    public org.eclipse.che.plugin.github.shared.Collaborators withCollaborators(java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser> v) {
      this.collaborators = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("client")
  public static class GitHubIssueCommentImpl implements org.eclipse.che.plugin.github.shared.GitHubIssueComment, JsonSerializable  {

    public static GitHubIssueCommentImpl make() {
        return new GitHubIssueCommentImpl();
    }

    protected GitHubIssueCommentImpl() {
    }

    protected java.lang.String url;
    protected java.lang.String body;
    protected java.lang.String id;

    @Override
    public java.lang.String getUrl() {
      return url;
    }

    public void setUrl(java.lang.String v) {
      this.url = v;
    }

    @Override
    public java.lang.String getBody() {
      return body;
    }

    public void setBody(java.lang.String v) {
      this.body = v;
    }

    @Override
    public java.lang.String getId() {
      return id;
    }

    public void setId(java.lang.String v) {
      this.id = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubIssueCommentImpl)) {
        return false;
      }
      GitHubIssueCommentImpl other = (GitHubIssueCommentImpl) o;
      if (this.url != null) {
        if (!this.url.equals(other.url)) {
          return false;
        }
      } else {
        if (other.url != null) {
          return false;
        }
      }
      if (this.body != null) {
        if (!this.body.equals(other.body)) {
          return false;
        }
      } else {
        if (other.body != null) {
          return false;
        }
      }
      if (this.id != null) {
        if (!this.id.equals(other.id)) {
          return false;
        }
      } else {
        if (other.id != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (url != null ? url.hashCode() : 0);
      hash = hash * 31 + (body != null ? body.hashCode() : 0);
      hash = hash * 31 + (id != null ? id.hashCode() : 0);
      return hash;
    }

    public JSONObject toJsonObject() {
      return toJsonObjectInt(true);
    }
    public JSONObject toJsonObjectInt(boolean copyJsons) {
      JSONObject result = new JSONObject();

      JSONValue urlOut = (this.url == null) ? JSONNull.getInstance() : new JSONString(this.url);
      result.put("url", urlOut);

      JSONValue bodyOut = (this.body == null) ? JSONNull.getInstance() : new JSONString(this.body);
      result.put("body", bodyOut);

      JSONValue idOut = (this.id == null) ? JSONNull.getInstance() : new JSONString(this.id);
      result.put("id", idOut);
      return result;
    }

    @Override
    public String toJson() {
      return toJsonObjectInt(false).toString();
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubIssueCommentImpl fromJsonObject(JSONValue jsonValue) {
      return fromJsonObjectInt(jsonValue, true);
    }
    public static GitHubIssueCommentImpl fromJsonObjectInt(JSONValue jsonValue, boolean copyJsons) {
      if (jsonValue == null || jsonValue.isNull() != null) {
        return null;
      }

      GitHubIssueCommentImpl dto = new GitHubIssueCommentImpl();
      JSONObject json = jsonValue.isObject();

      if (json.containsKey("url")) {
        JSONValue urlIn = json.get("url");
        String urlOut = urlIn.isString() != null ? urlIn.isString().stringValue() : null;
        dto.setUrl(urlOut);
      }

      if (json.containsKey("body")) {
        JSONValue bodyIn = json.get("body");
        String bodyOut = bodyIn.isString() != null ? bodyIn.isString().stringValue() : null;
        dto.setBody(bodyOut);
      }

      if (json.containsKey("id")) {
        JSONValue idIn = json.get("id");
        String idOut = idIn.isString() != null ? idIn.isString().stringValue() : null;
        dto.setId(idOut);
      }

      return dto;
    }

    public static GitHubIssueCommentImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonObjectInt(JSONParser.parseStrict(jsonString), false);
    }

    public GitHubIssueCommentImpl(org.eclipse.che.plugin.github.shared.GitHubIssueComment origin) {
      this.url = origin.getUrl();
      this.body = origin.getBody();
      this.id = origin.getId();
    }

    public org.eclipse.che.plugin.github.shared.GitHubIssueComment withUrl(java.lang.String v) {
      this.url = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubIssueComment withBody(java.lang.String v) {
      this.body = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubIssueComment withId(java.lang.String v) {
      this.id = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("client")
  public static class GitHubIssueCommentInputImpl implements org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput, JsonSerializable  {

    public static GitHubIssueCommentInputImpl make() {
        return new GitHubIssueCommentInputImpl();
    }

    protected GitHubIssueCommentInputImpl() {
    }

    protected java.lang.String body;

    @Override
    public java.lang.String getBody() {
      return body;
    }

    public void setBody(java.lang.String v) {
      this.body = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubIssueCommentInputImpl)) {
        return false;
      }
      GitHubIssueCommentInputImpl other = (GitHubIssueCommentInputImpl) o;
      if (this.body != null) {
        if (!this.body.equals(other.body)) {
          return false;
        }
      } else {
        if (other.body != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (body != null ? body.hashCode() : 0);
      return hash;
    }

    public JSONObject toJsonObject() {
      return toJsonObjectInt(true);
    }
    public JSONObject toJsonObjectInt(boolean copyJsons) {
      JSONObject result = new JSONObject();

      JSONValue bodyOut = (this.body == null) ? JSONNull.getInstance() : new JSONString(this.body);
      result.put("body", bodyOut);
      return result;
    }

    @Override
    public String toJson() {
      return toJsonObjectInt(false).toString();
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubIssueCommentInputImpl fromJsonObject(JSONValue jsonValue) {
      return fromJsonObjectInt(jsonValue, true);
    }
    public static GitHubIssueCommentInputImpl fromJsonObjectInt(JSONValue jsonValue, boolean copyJsons) {
      if (jsonValue == null || jsonValue.isNull() != null) {
        return null;
      }

      GitHubIssueCommentInputImpl dto = new GitHubIssueCommentInputImpl();
      JSONObject json = jsonValue.isObject();

      if (json.containsKey("body")) {
        JSONValue bodyIn = json.get("body");
        String bodyOut = bodyIn.isString() != null ? bodyIn.isString().stringValue() : null;
        dto.setBody(bodyOut);
      }

      return dto;
    }

    public static GitHubIssueCommentInputImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonObjectInt(JSONParser.parseStrict(jsonString), false);
    }

    public GitHubIssueCommentInputImpl(org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput origin) {
      this.body = origin.getBody();
    }

    public org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput withBody(java.lang.String v) {
      this.body = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("client")
  public static class GitHubKeyImpl implements org.eclipse.che.plugin.github.shared.GitHubKey, JsonSerializable  {

    public static GitHubKeyImpl make() {
        return new GitHubKeyImpl();
    }

    protected GitHubKeyImpl() {
    }

    protected java.lang.String url;
    protected java.lang.String key;
    protected java.lang.String title;
    protected int id;

    @Override
    public java.lang.String getUrl() {
      return url;
    }

    public void setUrl(java.lang.String v) {
      this.url = v;
    }

    @Override
    public java.lang.String getKey() {
      return key;
    }

    public void setKey(java.lang.String v) {
      this.key = v;
    }

    @Override
    public java.lang.String getTitle() {
      return title;
    }

    public void setTitle(java.lang.String v) {
      this.title = v;
    }

    @Override
    public int getId() {
      return id;
    }

    public void setId(int v) {
      this.id = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubKeyImpl)) {
        return false;
      }
      GitHubKeyImpl other = (GitHubKeyImpl) o;
      if (this.url != null) {
        if (!this.url.equals(other.url)) {
          return false;
        }
      } else {
        if (other.url != null) {
          return false;
        }
      }
      if (this.key != null) {
        if (!this.key.equals(other.key)) {
          return false;
        }
      } else {
        if (other.key != null) {
          return false;
        }
      }
      if (this.title != null) {
        if (!this.title.equals(other.title)) {
          return false;
        }
      } else {
        if (other.title != null) {
          return false;
        }
      }
      if (this.id != other.id) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (url != null ? url.hashCode() : 0);
      hash = hash * 31 + (key != null ? key.hashCode() : 0);
      hash = hash * 31 + (title != null ? title.hashCode() : 0);
      hash = hash * 31 + java.lang.Integer.valueOf(id).hashCode();
      return hash;
    }

    public JSONObject toJsonObject() {
      return toJsonObjectInt(true);
    }
    public JSONObject toJsonObjectInt(boolean copyJsons) {
      JSONObject result = new JSONObject();

      JSONValue urlOut = (this.url == null) ? JSONNull.getInstance() : new JSONString(this.url);
      result.put("url", urlOut);

      JSONValue keyOut = (this.key == null) ? JSONNull.getInstance() : new JSONString(this.key);
      result.put("key", keyOut);

      JSONValue titleOut = (this.title == null) ? JSONNull.getInstance() : new JSONString(this.title);
      result.put("title", titleOut);

      JSONValue idOut = new JSONNumber(this.id);
      result.put("id", idOut);
      return result;
    }

    @Override
    public String toJson() {
      return toJsonObjectInt(false).toString();
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubKeyImpl fromJsonObject(JSONValue jsonValue) {
      return fromJsonObjectInt(jsonValue, true);
    }
    public static GitHubKeyImpl fromJsonObjectInt(JSONValue jsonValue, boolean copyJsons) {
      if (jsonValue == null || jsonValue.isNull() != null) {
        return null;
      }

      GitHubKeyImpl dto = new GitHubKeyImpl();
      JSONObject json = jsonValue.isObject();

      if (json.containsKey("url")) {
        JSONValue urlIn = json.get("url");
        String urlOut = urlIn.isString() != null ? urlIn.isString().stringValue() : null;
        dto.setUrl(urlOut);
      }

      if (json.containsKey("key")) {
        JSONValue keyIn = json.get("key");
        String keyOut = keyIn.isString() != null ? keyIn.isString().stringValue() : null;
        dto.setKey(keyOut);
      }

      if (json.containsKey("title")) {
        JSONValue titleIn = json.get("title");
        String titleOut = titleIn.isString() != null ? titleIn.isString().stringValue() : null;
        dto.setTitle(titleOut);
      }

      if (json.containsKey("id")) {
        JSONValue idIn = json.get("id");
        int idOut = (int)idIn.isNumber().doubleValue();
        dto.setId(idOut);
      }

      return dto;
    }

    public static GitHubKeyImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonObjectInt(JSONParser.parseStrict(jsonString), false);
    }

    public GitHubKeyImpl(org.eclipse.che.plugin.github.shared.GitHubKey origin) {
      this.url = origin.getUrl();
      this.key = origin.getKey();
      this.title = origin.getTitle();
      this.id = origin.getId();
    }

    public org.eclipse.che.plugin.github.shared.GitHubKey withUrl(java.lang.String v) {
      this.url = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubKey withKey(java.lang.String v) {
      this.key = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubKey withTitle(java.lang.String v) {
      this.title = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubKey withId(int v) {
      this.id = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("client")
  public static class GitHubPullRequestImpl implements org.eclipse.che.plugin.github.shared.GitHubPullRequest, JsonSerializable  {

    public static GitHubPullRequestImpl make() {
        return new GitHubPullRequestImpl();
    }

    protected GitHubPullRequestImpl() {
    }

    protected java.lang.String number;
    protected boolean mergeable;
    protected java.lang.String url;
    protected java.lang.String title;
    protected java.lang.String state;
    protected java.lang.String body;
    protected org.eclipse.che.plugin.github.shared.GitHubPullRequestHead head;
    protected java.lang.String htmlUrl;
    protected org.eclipse.che.plugin.github.shared.GitHubUser mergedBy;
    protected java.lang.String id;
    protected boolean merged;

    @Override
    public java.lang.String getNumber() {
      return number;
    }

    public void setNumber(java.lang.String v) {
      this.number = v;
    }

    @Override
    public boolean getMergeable() {
      return mergeable;
    }

    public void setMergeable(boolean v) {
      this.mergeable = v;
    }

    @Override
    public java.lang.String getUrl() {
      return url;
    }

    public void setUrl(java.lang.String v) {
      this.url = v;
    }

    @Override
    public java.lang.String getTitle() {
      return title;
    }

    public void setTitle(java.lang.String v) {
      this.title = v;
    }

    @Override
    public java.lang.String getState() {
      return state;
    }

    public void setState(java.lang.String v) {
      this.state = v;
    }

    @Override
    public java.lang.String getBody() {
      return body;
    }

    public void setBody(java.lang.String v) {
      this.body = v;
    }

    @Override
    public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead getHead() {
      return head;
    }

    public void setHead(org.eclipse.che.plugin.github.shared.GitHubPullRequestHead v) {
      this.head = v;
    }

    @Override
    public java.lang.String getHtmlUrl() {
      return htmlUrl;
    }

    public void setHtmlUrl(java.lang.String v) {
      this.htmlUrl = v;
    }

    @Override
    public org.eclipse.che.plugin.github.shared.GitHubUser getMergedBy() {
      return mergedBy;
    }

    public void setMergedBy(org.eclipse.che.plugin.github.shared.GitHubUser v) {
      this.mergedBy = v;
    }

    @Override
    public java.lang.String getId() {
      return id;
    }

    public void setId(java.lang.String v) {
      this.id = v;
    }

    @Override
    public boolean getMerged() {
      return merged;
    }

    public void setMerged(boolean v) {
      this.merged = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubPullRequestImpl)) {
        return false;
      }
      GitHubPullRequestImpl other = (GitHubPullRequestImpl) o;
      if (this.number != null) {
        if (!this.number.equals(other.number)) {
          return false;
        }
      } else {
        if (other.number != null) {
          return false;
        }
      }
      if (this.mergeable != other.mergeable) {
        return false;
      }
      if (this.url != null) {
        if (!this.url.equals(other.url)) {
          return false;
        }
      } else {
        if (other.url != null) {
          return false;
        }
      }
      if (this.title != null) {
        if (!this.title.equals(other.title)) {
          return false;
        }
      } else {
        if (other.title != null) {
          return false;
        }
      }
      if (this.state != null) {
        if (!this.state.equals(other.state)) {
          return false;
        }
      } else {
        if (other.state != null) {
          return false;
        }
      }
      if (this.body != null) {
        if (!this.body.equals(other.body)) {
          return false;
        }
      } else {
        if (other.body != null) {
          return false;
        }
      }
      if (this.head != null) {
        if (!this.head.equals(other.head)) {
          return false;
        }
      } else {
        if (other.head != null) {
          return false;
        }
      }
      if (this.htmlUrl != null) {
        if (!this.htmlUrl.equals(other.htmlUrl)) {
          return false;
        }
      } else {
        if (other.htmlUrl != null) {
          return false;
        }
      }
      if (this.mergedBy != null) {
        if (!this.mergedBy.equals(other.mergedBy)) {
          return false;
        }
      } else {
        if (other.mergedBy != null) {
          return false;
        }
      }
      if (this.id != null) {
        if (!this.id.equals(other.id)) {
          return false;
        }
      } else {
        if (other.id != null) {
          return false;
        }
      }
      if (this.merged != other.merged) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (number != null ? number.hashCode() : 0);
      hash = hash * 31 + java.lang.Boolean.valueOf(mergeable).hashCode();
      hash = hash * 31 + (url != null ? url.hashCode() : 0);
      hash = hash * 31 + (title != null ? title.hashCode() : 0);
      hash = hash * 31 + (state != null ? state.hashCode() : 0);
      hash = hash * 31 + (body != null ? body.hashCode() : 0);
      hash = hash * 31 + (head != null ? head.hashCode() : 0);
      hash = hash * 31 + (htmlUrl != null ? htmlUrl.hashCode() : 0);
      hash = hash * 31 + (mergedBy != null ? mergedBy.hashCode() : 0);
      hash = hash * 31 + (id != null ? id.hashCode() : 0);
      hash = hash * 31 + java.lang.Boolean.valueOf(merged).hashCode();
      return hash;
    }

    public JSONObject toJsonObject() {
      return toJsonObjectInt(true);
    }
    public JSONObject toJsonObjectInt(boolean copyJsons) {
      JSONObject result = new JSONObject();

      JSONValue numberOut = (this.number == null) ? JSONNull.getInstance() : new JSONString(this.number);
      result.put("number", numberOut);

      JSONValue mergeableOut = JSONBoolean.getInstance(this.mergeable);
      result.put("mergeable", mergeableOut);

      JSONValue urlOut = (this.url == null) ? JSONNull.getInstance() : new JSONString(this.url);
      result.put("url", urlOut);

      JSONValue titleOut = (this.title == null) ? JSONNull.getInstance() : new JSONString(this.title);
      result.put("title", titleOut);

      JSONValue stateOut = (this.state == null) ? JSONNull.getInstance() : new JSONString(this.state);
      result.put("state", stateOut);

      JSONValue bodyOut = (this.body == null) ? JSONNull.getInstance() : new JSONString(this.body);
      result.put("body", bodyOut);

      JSONValue headOut = this.head == null ? JSONNull.getInstance() : ((GitHubPullRequestHeadImpl)head).toJsonObject();
      result.put("head", headOut);

      JSONValue htmlUrlOut = (this.htmlUrl == null) ? JSONNull.getInstance() : new JSONString(this.htmlUrl);
      result.put("htmlUrl", htmlUrlOut);

      JSONValue mergedByOut = this.mergedBy == null ? JSONNull.getInstance() : ((GitHubUserImpl)mergedBy).toJsonObject();
      result.put("mergedBy", mergedByOut);

      JSONValue idOut = (this.id == null) ? JSONNull.getInstance() : new JSONString(this.id);
      result.put("id", idOut);

      JSONValue mergedOut = JSONBoolean.getInstance(this.merged);
      result.put("merged", mergedOut);
      return result;
    }

    @Override
    public String toJson() {
      return toJsonObjectInt(false).toString();
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubPullRequestImpl fromJsonObject(JSONValue jsonValue) {
      return fromJsonObjectInt(jsonValue, true);
    }
    public static GitHubPullRequestImpl fromJsonObjectInt(JSONValue jsonValue, boolean copyJsons) {
      if (jsonValue == null || jsonValue.isNull() != null) {
        return null;
      }

      GitHubPullRequestImpl dto = new GitHubPullRequestImpl();
      JSONObject json = jsonValue.isObject();

      if (json.containsKey("number")) {
        JSONValue numberIn = json.get("number");
        String numberOut = numberIn.isString() != null ? numberIn.isString().stringValue() : null;
        dto.setNumber(numberOut);
      }

      if (json.containsKey("mergeable")) {
        JSONValue mergeableIn = json.get("mergeable");
        boolean mergeableOut = mergeableIn.isBoolean().booleanValue();
        dto.setMergeable(mergeableOut);
      }

      if (json.containsKey("url")) {
        JSONValue urlIn = json.get("url");
        String urlOut = urlIn.isString() != null ? urlIn.isString().stringValue() : null;
        dto.setUrl(urlOut);
      }

      if (json.containsKey("title")) {
        JSONValue titleIn = json.get("title");
        String titleOut = titleIn.isString() != null ? titleIn.isString().stringValue() : null;
        dto.setTitle(titleOut);
      }

      if (json.containsKey("state")) {
        JSONValue stateIn = json.get("state");
        String stateOut = stateIn.isString() != null ? stateIn.isString().stringValue() : null;
        dto.setState(stateOut);
      }

      if (json.containsKey("body")) {
        JSONValue bodyIn = json.get("body");
        String bodyOut = bodyIn.isString() != null ? bodyIn.isString().stringValue() : null;
        dto.setBody(bodyOut);
      }

      if (json.containsKey("head")) {
        JSONValue headIn = json.get("head");
        org.eclipse.che.plugin.github.shared.GitHubPullRequestHead headOut = GitHubPullRequestHeadImpl.fromJsonObject(headIn);
        dto.setHead(headOut);
      }

      if (json.containsKey("htmlUrl")) {
        JSONValue htmlUrlIn = json.get("htmlUrl");
        String htmlUrlOut = htmlUrlIn.isString() != null ? htmlUrlIn.isString().stringValue() : null;
        dto.setHtmlUrl(htmlUrlOut);
      }

      if (json.containsKey("mergedBy")) {
        JSONValue mergedByIn = json.get("mergedBy");
        org.eclipse.che.plugin.github.shared.GitHubUser mergedByOut = GitHubUserImpl.fromJsonObject(mergedByIn);
        dto.setMergedBy(mergedByOut);
      }

      if (json.containsKey("id")) {
        JSONValue idIn = json.get("id");
        String idOut = idIn.isString() != null ? idIn.isString().stringValue() : null;
        dto.setId(idOut);
      }

      if (json.containsKey("merged")) {
        JSONValue mergedIn = json.get("merged");
        boolean mergedOut = mergedIn.isBoolean().booleanValue();
        dto.setMerged(mergedOut);
      }

      return dto;
    }

    public static GitHubPullRequestImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonObjectInt(JSONParser.parseStrict(jsonString), false);
    }

    public GitHubPullRequestImpl(org.eclipse.che.plugin.github.shared.GitHubPullRequest origin) {
      this.number = origin.getNumber();
      this.mergeable = origin.getMergeable();
      this.url = origin.getUrl();
      this.title = origin.getTitle();
      this.state = origin.getState();
      this.body = origin.getBody();
      org.eclipse.che.plugin.github.shared.GitHubPullRequestHead headIn = origin.getHead();
      this.head = headIn == null ? null : new GitHubPullRequestHeadImpl(headIn);
      this.htmlUrl = origin.getHtmlUrl();
      org.eclipse.che.plugin.github.shared.GitHubUser mergedByIn = origin.getMergedBy();
      this.mergedBy = mergedByIn == null ? null : new GitHubUserImpl(mergedByIn);
      this.id = origin.getId();
      this.merged = origin.getMerged();
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withNumber(java.lang.String v) {
      this.number = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withMergeable(boolean v) {
      this.mergeable = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withUrl(java.lang.String v) {
      this.url = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withTitle(java.lang.String v) {
      this.title = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withState(java.lang.String v) {
      this.state = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withBody(java.lang.String v) {
      this.body = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withHead(org.eclipse.che.plugin.github.shared.GitHubPullRequestHead v) {
      this.head = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withHtmlUrl(java.lang.String v) {
      this.htmlUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withMergedBy(org.eclipse.che.plugin.github.shared.GitHubUser v) {
      this.mergedBy = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withId(java.lang.String v) {
      this.id = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withMerged(boolean v) {
      this.merged = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("client")
  public static class GitHubPullRequestCreationInputImpl implements org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput, JsonSerializable  {

    public static GitHubPullRequestCreationInputImpl make() {
        return new GitHubPullRequestCreationInputImpl();
    }

    protected GitHubPullRequestCreationInputImpl() {
    }

    protected java.lang.String title;
    protected java.lang.String body;
    protected java.lang.String head;
    protected java.lang.String base;

    @Override
    public java.lang.String getTitle() {
      return title;
    }

    public void setTitle(java.lang.String v) {
      this.title = v;
    }

    @Override
    public java.lang.String getBody() {
      return body;
    }

    public void setBody(java.lang.String v) {
      this.body = v;
    }

    @Override
    public java.lang.String getHead() {
      return head;
    }

    public void setHead(java.lang.String v) {
      this.head = v;
    }

    @Override
    public java.lang.String getBase() {
      return base;
    }

    public void setBase(java.lang.String v) {
      this.base = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubPullRequestCreationInputImpl)) {
        return false;
      }
      GitHubPullRequestCreationInputImpl other = (GitHubPullRequestCreationInputImpl) o;
      if (this.title != null) {
        if (!this.title.equals(other.title)) {
          return false;
        }
      } else {
        if (other.title != null) {
          return false;
        }
      }
      if (this.body != null) {
        if (!this.body.equals(other.body)) {
          return false;
        }
      } else {
        if (other.body != null) {
          return false;
        }
      }
      if (this.head != null) {
        if (!this.head.equals(other.head)) {
          return false;
        }
      } else {
        if (other.head != null) {
          return false;
        }
      }
      if (this.base != null) {
        if (!this.base.equals(other.base)) {
          return false;
        }
      } else {
        if (other.base != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (title != null ? title.hashCode() : 0);
      hash = hash * 31 + (body != null ? body.hashCode() : 0);
      hash = hash * 31 + (head != null ? head.hashCode() : 0);
      hash = hash * 31 + (base != null ? base.hashCode() : 0);
      return hash;
    }

    public JSONObject toJsonObject() {
      return toJsonObjectInt(true);
    }
    public JSONObject toJsonObjectInt(boolean copyJsons) {
      JSONObject result = new JSONObject();

      JSONValue titleOut = (this.title == null) ? JSONNull.getInstance() : new JSONString(this.title);
      result.put("title", titleOut);

      JSONValue bodyOut = (this.body == null) ? JSONNull.getInstance() : new JSONString(this.body);
      result.put("body", bodyOut);

      JSONValue headOut = (this.head == null) ? JSONNull.getInstance() : new JSONString(this.head);
      result.put("head", headOut);

      JSONValue baseOut = (this.base == null) ? JSONNull.getInstance() : new JSONString(this.base);
      result.put("base", baseOut);
      return result;
    }

    @Override
    public String toJson() {
      return toJsonObjectInt(false).toString();
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubPullRequestCreationInputImpl fromJsonObject(JSONValue jsonValue) {
      return fromJsonObjectInt(jsonValue, true);
    }
    public static GitHubPullRequestCreationInputImpl fromJsonObjectInt(JSONValue jsonValue, boolean copyJsons) {
      if (jsonValue == null || jsonValue.isNull() != null) {
        return null;
      }

      GitHubPullRequestCreationInputImpl dto = new GitHubPullRequestCreationInputImpl();
      JSONObject json = jsonValue.isObject();

      if (json.containsKey("title")) {
        JSONValue titleIn = json.get("title");
        String titleOut = titleIn.isString() != null ? titleIn.isString().stringValue() : null;
        dto.setTitle(titleOut);
      }

      if (json.containsKey("body")) {
        JSONValue bodyIn = json.get("body");
        String bodyOut = bodyIn.isString() != null ? bodyIn.isString().stringValue() : null;
        dto.setBody(bodyOut);
      }

      if (json.containsKey("head")) {
        JSONValue headIn = json.get("head");
        String headOut = headIn.isString() != null ? headIn.isString().stringValue() : null;
        dto.setHead(headOut);
      }

      if (json.containsKey("base")) {
        JSONValue baseIn = json.get("base");
        String baseOut = baseIn.isString() != null ? baseIn.isString().stringValue() : null;
        dto.setBase(baseOut);
      }

      return dto;
    }

    public static GitHubPullRequestCreationInputImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonObjectInt(JSONParser.parseStrict(jsonString), false);
    }

    public GitHubPullRequestCreationInputImpl(org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput origin) {
      this.title = origin.getTitle();
      this.body = origin.getBody();
      this.head = origin.getHead();
      this.base = origin.getBase();
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput withTitle(java.lang.String v) {
      this.title = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput withBody(java.lang.String v) {
      this.body = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput withHead(java.lang.String v) {
      this.head = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput withBase(java.lang.String v) {
      this.base = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("client")
  public static class GitHubPullRequestHeadImpl implements org.eclipse.che.plugin.github.shared.GitHubPullRequestHead, JsonSerializable  {

    public static GitHubPullRequestHeadImpl make() {
        return new GitHubPullRequestHeadImpl();
    }

    protected GitHubPullRequestHeadImpl() {
    }

    protected java.lang.String label;
    protected java.lang.String ref;
    protected java.lang.String sha;

    @Override
    public java.lang.String getLabel() {
      return label;
    }

    public void setLabel(java.lang.String v) {
      this.label = v;
    }

    @Override
    public java.lang.String getRef() {
      return ref;
    }

    public void setRef(java.lang.String v) {
      this.ref = v;
    }

    @Override
    public java.lang.String getSha() {
      return sha;
    }

    public void setSha(java.lang.String v) {
      this.sha = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubPullRequestHeadImpl)) {
        return false;
      }
      GitHubPullRequestHeadImpl other = (GitHubPullRequestHeadImpl) o;
      if (this.label != null) {
        if (!this.label.equals(other.label)) {
          return false;
        }
      } else {
        if (other.label != null) {
          return false;
        }
      }
      if (this.ref != null) {
        if (!this.ref.equals(other.ref)) {
          return false;
        }
      } else {
        if (other.ref != null) {
          return false;
        }
      }
      if (this.sha != null) {
        if (!this.sha.equals(other.sha)) {
          return false;
        }
      } else {
        if (other.sha != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (label != null ? label.hashCode() : 0);
      hash = hash * 31 + (ref != null ? ref.hashCode() : 0);
      hash = hash * 31 + (sha != null ? sha.hashCode() : 0);
      return hash;
    }

    public JSONObject toJsonObject() {
      return toJsonObjectInt(true);
    }
    public JSONObject toJsonObjectInt(boolean copyJsons) {
      JSONObject result = new JSONObject();

      JSONValue labelOut = (this.label == null) ? JSONNull.getInstance() : new JSONString(this.label);
      result.put("label", labelOut);

      JSONValue refOut = (this.ref == null) ? JSONNull.getInstance() : new JSONString(this.ref);
      result.put("ref", refOut);

      JSONValue shaOut = (this.sha == null) ? JSONNull.getInstance() : new JSONString(this.sha);
      result.put("sha", shaOut);
      return result;
    }

    @Override
    public String toJson() {
      return toJsonObjectInt(false).toString();
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubPullRequestHeadImpl fromJsonObject(JSONValue jsonValue) {
      return fromJsonObjectInt(jsonValue, true);
    }
    public static GitHubPullRequestHeadImpl fromJsonObjectInt(JSONValue jsonValue, boolean copyJsons) {
      if (jsonValue == null || jsonValue.isNull() != null) {
        return null;
      }

      GitHubPullRequestHeadImpl dto = new GitHubPullRequestHeadImpl();
      JSONObject json = jsonValue.isObject();

      if (json.containsKey("label")) {
        JSONValue labelIn = json.get("label");
        String labelOut = labelIn.isString() != null ? labelIn.isString().stringValue() : null;
        dto.setLabel(labelOut);
      }

      if (json.containsKey("ref")) {
        JSONValue refIn = json.get("ref");
        String refOut = refIn.isString() != null ? refIn.isString().stringValue() : null;
        dto.setRef(refOut);
      }

      if (json.containsKey("sha")) {
        JSONValue shaIn = json.get("sha");
        String shaOut = shaIn.isString() != null ? shaIn.isString().stringValue() : null;
        dto.setSha(shaOut);
      }

      return dto;
    }

    public static GitHubPullRequestHeadImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonObjectInt(JSONParser.parseStrict(jsonString), false);
    }

    public GitHubPullRequestHeadImpl(org.eclipse.che.plugin.github.shared.GitHubPullRequestHead origin) {
      this.label = origin.getLabel();
      this.ref = origin.getRef();
      this.sha = origin.getSha();
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead withLabel(java.lang.String v) {
      this.label = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead withRef(java.lang.String v) {
      this.ref = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead withSha(java.lang.String v) {
      this.sha = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("client")
  public static class GitHubPullRequestListImpl implements org.eclipse.che.plugin.github.shared.GitHubPullRequestList, JsonSerializable  {

    public static GitHubPullRequestListImpl make() {
        return new GitHubPullRequestListImpl();
    }

    protected GitHubPullRequestListImpl() {
    }

    protected java.lang.String firstPage;
    protected java.lang.String lastPage;
    protected java.lang.String nextPage;
    protected java.lang.String prevPage;
    protected java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest> pullRequests;

    @Override
    public java.lang.String getFirstPage() {
      return firstPage;
    }

    public void setFirstPage(java.lang.String v) {
      this.firstPage = v;
    }

    @Override
    public java.lang.String getLastPage() {
      return lastPage;
    }

    public void setLastPage(java.lang.String v) {
      this.lastPage = v;
    }

    @Override
    public java.lang.String getNextPage() {
      return nextPage;
    }

    public void setNextPage(java.lang.String v) {
      this.nextPage = v;
    }

    @Override
    public java.lang.String getPrevPage() {
      return prevPage;
    }

    public void setPrevPage(java.lang.String v) {
      this.prevPage = v;
    }

    @Override
    public java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest> getPullRequests() {
      ensurePullRequests();
      return pullRequests;
    }

    public void setPullRequests(java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest> v) {
      this.pullRequests = v;
    }

    public void addPullRequests(org.eclipse.che.plugin.github.shared.GitHubPullRequest v) {
      ensurePullRequests();
      pullRequests.add(v);
    }

    public void clearPullRequests() {
      ensurePullRequests();
      pullRequests.clear();
    }

    protected void ensurePullRequests() {
      if (pullRequests == null) {
        pullRequests = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubPullRequest>();
      }
    }
    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubPullRequestListImpl)) {
        return false;
      }
      GitHubPullRequestListImpl other = (GitHubPullRequestListImpl) o;
      if (this.firstPage != null) {
        if (!this.firstPage.equals(other.firstPage)) {
          return false;
        }
      } else {
        if (other.firstPage != null) {
          return false;
        }
      }
      if (this.lastPage != null) {
        if (!this.lastPage.equals(other.lastPage)) {
          return false;
        }
      } else {
        if (other.lastPage != null) {
          return false;
        }
      }
      if (this.nextPage != null) {
        if (!this.nextPage.equals(other.nextPage)) {
          return false;
        }
      } else {
        if (other.nextPage != null) {
          return false;
        }
      }
      if (this.prevPage != null) {
        if (!this.prevPage.equals(other.prevPage)) {
          return false;
        }
      } else {
        if (other.prevPage != null) {
          return false;
        }
      }
      if (this.pullRequests != null) {
        if (!this.pullRequests.equals(other.pullRequests)) {
          return false;
        }
      } else {
        if (other.pullRequests != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (firstPage != null ? firstPage.hashCode() : 0);
      hash = hash * 31 + (lastPage != null ? lastPage.hashCode() : 0);
      hash = hash * 31 + (nextPage != null ? nextPage.hashCode() : 0);
      hash = hash * 31 + (prevPage != null ? prevPage.hashCode() : 0);
      hash = hash * 31 + (pullRequests != null ? pullRequests.hashCode() : 0);
      return hash;
    }

    public JSONObject toJsonObject() {
      return toJsonObjectInt(true);
    }
    public JSONObject toJsonObjectInt(boolean copyJsons) {
      JSONObject result = new JSONObject();

      JSONValue firstPageOut = (this.firstPage == null) ? JSONNull.getInstance() : new JSONString(this.firstPage);
      result.put("firstPage", firstPageOut);

      JSONValue lastPageOut = (this.lastPage == null) ? JSONNull.getInstance() : new JSONString(this.lastPage);
      result.put("lastPage", lastPageOut);

      JSONValue nextPageOut = (this.nextPage == null) ? JSONNull.getInstance() : new JSONString(this.nextPage);
      result.put("nextPage", nextPageOut);

      JSONValue prevPageOut = (this.prevPage == null) ? JSONNull.getInstance() : new JSONString(this.prevPage);
      result.put("prevPage", prevPageOut);

      JSONArray pullRequestsOut = new JSONArray();
      this.ensurePullRequests();
      for (org.eclipse.che.plugin.github.shared.GitHubPullRequest pullRequests_ : this.pullRequests) {
        JSONValue pullRequestsOut_ = pullRequests_ == null ? JSONNull.getInstance() : ((GitHubPullRequestImpl)pullRequests_).toJsonObject();
        pullRequestsOut.set(pullRequestsOut.size(), pullRequestsOut_);
      }
      result.put("pullRequests", pullRequestsOut);
      return result;
    }

    @Override
    public String toJson() {
      return toJsonObjectInt(false).toString();
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubPullRequestListImpl fromJsonObject(JSONValue jsonValue) {
      return fromJsonObjectInt(jsonValue, true);
    }
    public static GitHubPullRequestListImpl fromJsonObjectInt(JSONValue jsonValue, boolean copyJsons) {
      if (jsonValue == null || jsonValue.isNull() != null) {
        return null;
      }

      GitHubPullRequestListImpl dto = new GitHubPullRequestListImpl();
      JSONObject json = jsonValue.isObject();

      if (json.containsKey("firstPage")) {
        JSONValue firstPageIn = json.get("firstPage");
        String firstPageOut = firstPageIn.isString() != null ? firstPageIn.isString().stringValue() : null;
        dto.setFirstPage(firstPageOut);
      }

      if (json.containsKey("lastPage")) {
        JSONValue lastPageIn = json.get("lastPage");
        String lastPageOut = lastPageIn.isString() != null ? lastPageIn.isString().stringValue() : null;
        dto.setLastPage(lastPageOut);
      }

      if (json.containsKey("nextPage")) {
        JSONValue nextPageIn = json.get("nextPage");
        String nextPageOut = nextPageIn.isString() != null ? nextPageIn.isString().stringValue() : null;
        dto.setNextPage(nextPageOut);
      }

      if (json.containsKey("prevPage")) {
        JSONValue prevPageIn = json.get("prevPage");
        String prevPageOut = prevPageIn.isString() != null ? prevPageIn.isString().stringValue() : null;
        dto.setPrevPage(prevPageOut);
      }

      if (json.containsKey("pullRequests")) {
        JSONValue pullRequestsIn = json.get("pullRequests");
        java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest> pullRequestsOut = null;
        if (pullRequestsIn != null && pullRequestsIn.isNull() == null) {
          pullRequestsOut = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubPullRequest>();
          for (int pullRequestsIn__iterator = 0; pullRequestsIn__iterator < pullRequestsIn.isArray().size(); pullRequestsIn__iterator++) {
            JSONValue pullRequestsIn_ = pullRequestsIn.isArray().get(pullRequestsIn__iterator);
            org.eclipse.che.plugin.github.shared.GitHubPullRequest pullRequestsOut_ = GitHubPullRequestImpl.fromJsonObject(pullRequestsIn_);
            pullRequestsOut.add(pullRequestsOut_);
          }
        }
        dto.setPullRequests(pullRequestsOut);
      }

      return dto;
    }

    public static GitHubPullRequestListImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonObjectInt(JSONParser.parseStrict(jsonString), false);
    }

    public GitHubPullRequestListImpl(org.eclipse.che.plugin.github.shared.GitHubPullRequestList origin) {
      this.firstPage = origin.getFirstPage();
      this.lastPage = origin.getLastPage();
      this.nextPage = origin.getNextPage();
      this.prevPage = origin.getPrevPage();
      java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest> pullRequestsIn = origin.getPullRequests();
      if (pullRequestsIn != null) {
        java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest> pullRequestsOut = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubPullRequest>();
        for (org.eclipse.che.plugin.github.shared.GitHubPullRequest pullRequestsIn_ : pullRequestsIn) {
            pullRequestsOut.add(pullRequestsIn_ == null ? null : new GitHubPullRequestImpl(pullRequestsIn_));
        }
        this.pullRequests = pullRequestsOut;
      }
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestList withFirstPage(java.lang.String v) {
      this.firstPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestList withLastPage(java.lang.String v) {
      this.lastPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestList withNextPage(java.lang.String v) {
      this.nextPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestList withPrevPage(java.lang.String v) {
      this.prevPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestList withPullRequests(java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest> v) {
      this.pullRequests = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("client")
  public static class GitHubRepositoryImpl implements org.eclipse.che.plugin.github.shared.GitHubRepository, JsonSerializable  {

    public static GitHubRepositoryImpl make() {
        return new GitHubRepositoryImpl();
    }

    protected GitHubRepositoryImpl() {
    }

    protected java.lang.String language;
    protected org.eclipse.che.plugin.github.shared.GitHubRepository parent;
    protected java.lang.String name;
    protected java.lang.String sshUrl;
    protected java.lang.String gitUrl;
    protected java.lang.String ownerLogin;
    protected java.lang.String updatedAt;
    protected java.lang.String homepage;
    protected java.lang.String description;
    protected boolean fork;
    protected boolean hasIssues;
    protected java.lang.String url;
    protected java.lang.String createdAt;
    protected int openedIssues;
    protected int size;
    protected boolean privateRepo;
    protected int forks;
    protected int watchers;
    protected java.lang.String htmlUrl;
    protected boolean hasDownloads;
    protected boolean hasWiki;
    protected java.lang.String cloneUrl;
    protected java.lang.String pushedAt;

    @Override
    public java.lang.String getLanguage() {
      return language;
    }

    public void setLanguage(java.lang.String v) {
      this.language = v;
    }

    @Override
    public org.eclipse.che.plugin.github.shared.GitHubRepository getParent() {
      return parent;
    }

    public void setParent(org.eclipse.che.plugin.github.shared.GitHubRepository v) {
      this.parent = v;
    }

    @Override
    public java.lang.String getName() {
      return name;
    }

    public void setName(java.lang.String v) {
      this.name = v;
    }

    @Override
    public java.lang.String getSshUrl() {
      return sshUrl;
    }

    public void setSshUrl(java.lang.String v) {
      this.sshUrl = v;
    }

    @Override
    public java.lang.String getGitUrl() {
      return gitUrl;
    }

    public void setGitUrl(java.lang.String v) {
      this.gitUrl = v;
    }

    @Override
    public java.lang.String getOwnerLogin() {
      return ownerLogin;
    }

    public void setOwnerLogin(java.lang.String v) {
      this.ownerLogin = v;
    }

    @Override
    public java.lang.String getUpdatedAt() {
      return updatedAt;
    }

    public void setUpdatedAt(java.lang.String v) {
      this.updatedAt = v;
    }

    @Override
    public java.lang.String getHomepage() {
      return homepage;
    }

    public void setHomepage(java.lang.String v) {
      this.homepage = v;
    }

    @Override
    public java.lang.String getDescription() {
      return description;
    }

    public void setDescription(java.lang.String v) {
      this.description = v;
    }

    @Override
    public boolean isFork() {
      return fork;
    }

    public void setFork(boolean v) {
      this.fork = v;
    }

    @Override
    public boolean isHasIssues() {
      return hasIssues;
    }

    public void setHasIssues(boolean v) {
      this.hasIssues = v;
    }

    @Override
    public java.lang.String getUrl() {
      return url;
    }

    public void setUrl(java.lang.String v) {
      this.url = v;
    }

    @Override
    public java.lang.String getCreatedAt() {
      return createdAt;
    }

    public void setCreatedAt(java.lang.String v) {
      this.createdAt = v;
    }

    @Override
    public int getOpenedIssues() {
      return openedIssues;
    }

    public void setOpenedIssues(int v) {
      this.openedIssues = v;
    }

    @Override
    public int getSize() {
      return size;
    }

    public void setSize(int v) {
      this.size = v;
    }

    @Override
    public boolean isPrivateRepo() {
      return privateRepo;
    }

    public void setPrivateRepo(boolean v) {
      this.privateRepo = v;
    }

    @Override
    public int getForks() {
      return forks;
    }

    public void setForks(int v) {
      this.forks = v;
    }

    @Override
    public int getWatchers() {
      return watchers;
    }

    public void setWatchers(int v) {
      this.watchers = v;
    }

    @Override
    public java.lang.String getHtmlUrl() {
      return htmlUrl;
    }

    public void setHtmlUrl(java.lang.String v) {
      this.htmlUrl = v;
    }

    @Override
    public boolean isHasDownloads() {
      return hasDownloads;
    }

    public void setHasDownloads(boolean v) {
      this.hasDownloads = v;
    }

    @Override
    public boolean isHasWiki() {
      return hasWiki;
    }

    public void setHasWiki(boolean v) {
      this.hasWiki = v;
    }

    @Override
    public java.lang.String getCloneUrl() {
      return cloneUrl;
    }

    public void setCloneUrl(java.lang.String v) {
      this.cloneUrl = v;
    }

    @Override
    public java.lang.String getPushedAt() {
      return pushedAt;
    }

    public void setPushedAt(java.lang.String v) {
      this.pushedAt = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubRepositoryImpl)) {
        return false;
      }
      GitHubRepositoryImpl other = (GitHubRepositoryImpl) o;
      if (this.language != null) {
        if (!this.language.equals(other.language)) {
          return false;
        }
      } else {
        if (other.language != null) {
          return false;
        }
      }
      if (this.parent != null) {
        if (!this.parent.equals(other.parent)) {
          return false;
        }
      } else {
        if (other.parent != null) {
          return false;
        }
      }
      if (this.name != null) {
        if (!this.name.equals(other.name)) {
          return false;
        }
      } else {
        if (other.name != null) {
          return false;
        }
      }
      if (this.sshUrl != null) {
        if (!this.sshUrl.equals(other.sshUrl)) {
          return false;
        }
      } else {
        if (other.sshUrl != null) {
          return false;
        }
      }
      if (this.gitUrl != null) {
        if (!this.gitUrl.equals(other.gitUrl)) {
          return false;
        }
      } else {
        if (other.gitUrl != null) {
          return false;
        }
      }
      if (this.ownerLogin != null) {
        if (!this.ownerLogin.equals(other.ownerLogin)) {
          return false;
        }
      } else {
        if (other.ownerLogin != null) {
          return false;
        }
      }
      if (this.updatedAt != null) {
        if (!this.updatedAt.equals(other.updatedAt)) {
          return false;
        }
      } else {
        if (other.updatedAt != null) {
          return false;
        }
      }
      if (this.homepage != null) {
        if (!this.homepage.equals(other.homepage)) {
          return false;
        }
      } else {
        if (other.homepage != null) {
          return false;
        }
      }
      if (this.description != null) {
        if (!this.description.equals(other.description)) {
          return false;
        }
      } else {
        if (other.description != null) {
          return false;
        }
      }
      if (this.fork != other.fork) {
        return false;
      }
      if (this.hasIssues != other.hasIssues) {
        return false;
      }
      if (this.url != null) {
        if (!this.url.equals(other.url)) {
          return false;
        }
      } else {
        if (other.url != null) {
          return false;
        }
      }
      if (this.createdAt != null) {
        if (!this.createdAt.equals(other.createdAt)) {
          return false;
        }
      } else {
        if (other.createdAt != null) {
          return false;
        }
      }
      if (this.openedIssues != other.openedIssues) {
        return false;
      }
      if (this.size != other.size) {
        return false;
      }
      if (this.privateRepo != other.privateRepo) {
        return false;
      }
      if (this.forks != other.forks) {
        return false;
      }
      if (this.watchers != other.watchers) {
        return false;
      }
      if (this.htmlUrl != null) {
        if (!this.htmlUrl.equals(other.htmlUrl)) {
          return false;
        }
      } else {
        if (other.htmlUrl != null) {
          return false;
        }
      }
      if (this.hasDownloads != other.hasDownloads) {
        return false;
      }
      if (this.hasWiki != other.hasWiki) {
        return false;
      }
      if (this.cloneUrl != null) {
        if (!this.cloneUrl.equals(other.cloneUrl)) {
          return false;
        }
      } else {
        if (other.cloneUrl != null) {
          return false;
        }
      }
      if (this.pushedAt != null) {
        if (!this.pushedAt.equals(other.pushedAt)) {
          return false;
        }
      } else {
        if (other.pushedAt != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (language != null ? language.hashCode() : 0);
      hash = hash * 31 + (parent != null ? parent.hashCode() : 0);
      hash = hash * 31 + (name != null ? name.hashCode() : 0);
      hash = hash * 31 + (sshUrl != null ? sshUrl.hashCode() : 0);
      hash = hash * 31 + (gitUrl != null ? gitUrl.hashCode() : 0);
      hash = hash * 31 + (ownerLogin != null ? ownerLogin.hashCode() : 0);
      hash = hash * 31 + (updatedAt != null ? updatedAt.hashCode() : 0);
      hash = hash * 31 + (homepage != null ? homepage.hashCode() : 0);
      hash = hash * 31 + (description != null ? description.hashCode() : 0);
      hash = hash * 31 + java.lang.Boolean.valueOf(fork).hashCode();
      hash = hash * 31 + java.lang.Boolean.valueOf(hasIssues).hashCode();
      hash = hash * 31 + (url != null ? url.hashCode() : 0);
      hash = hash * 31 + (createdAt != null ? createdAt.hashCode() : 0);
      hash = hash * 31 + java.lang.Integer.valueOf(openedIssues).hashCode();
      hash = hash * 31 + java.lang.Integer.valueOf(size).hashCode();
      hash = hash * 31 + java.lang.Boolean.valueOf(privateRepo).hashCode();
      hash = hash * 31 + java.lang.Integer.valueOf(forks).hashCode();
      hash = hash * 31 + java.lang.Integer.valueOf(watchers).hashCode();
      hash = hash * 31 + (htmlUrl != null ? htmlUrl.hashCode() : 0);
      hash = hash * 31 + java.lang.Boolean.valueOf(hasDownloads).hashCode();
      hash = hash * 31 + java.lang.Boolean.valueOf(hasWiki).hashCode();
      hash = hash * 31 + (cloneUrl != null ? cloneUrl.hashCode() : 0);
      hash = hash * 31 + (pushedAt != null ? pushedAt.hashCode() : 0);
      return hash;
    }

    public JSONObject toJsonObject() {
      return toJsonObjectInt(true);
    }
    public JSONObject toJsonObjectInt(boolean copyJsons) {
      JSONObject result = new JSONObject();

      JSONValue languageOut = (this.language == null) ? JSONNull.getInstance() : new JSONString(this.language);
      result.put("language", languageOut);

      JSONValue parentOut = this.parent == null ? JSONNull.getInstance() : ((GitHubRepositoryImpl)parent).toJsonObject();
      result.put("parent", parentOut);

      JSONValue nameOut = (this.name == null) ? JSONNull.getInstance() : new JSONString(this.name);
      result.put("name", nameOut);

      JSONValue sshUrlOut = (this.sshUrl == null) ? JSONNull.getInstance() : new JSONString(this.sshUrl);
      result.put("sshUrl", sshUrlOut);

      JSONValue gitUrlOut = (this.gitUrl == null) ? JSONNull.getInstance() : new JSONString(this.gitUrl);
      result.put("gitUrl", gitUrlOut);

      JSONValue ownerLoginOut = (this.ownerLogin == null) ? JSONNull.getInstance() : new JSONString(this.ownerLogin);
      result.put("ownerLogin", ownerLoginOut);

      JSONValue updatedAtOut = (this.updatedAt == null) ? JSONNull.getInstance() : new JSONString(this.updatedAt);
      result.put("updatedAt", updatedAtOut);

      JSONValue homepageOut = (this.homepage == null) ? JSONNull.getInstance() : new JSONString(this.homepage);
      result.put("homepage", homepageOut);

      JSONValue descriptionOut = (this.description == null) ? JSONNull.getInstance() : new JSONString(this.description);
      result.put("description", descriptionOut);

      JSONValue forkOut = JSONBoolean.getInstance(this.fork);
      result.put("fork", forkOut);

      JSONValue hasIssuesOut = JSONBoolean.getInstance(this.hasIssues);
      result.put("hasIssues", hasIssuesOut);

      JSONValue urlOut = (this.url == null) ? JSONNull.getInstance() : new JSONString(this.url);
      result.put("url", urlOut);

      JSONValue createdAtOut = (this.createdAt == null) ? JSONNull.getInstance() : new JSONString(this.createdAt);
      result.put("createdAt", createdAtOut);

      JSONValue openedIssuesOut = new JSONNumber(this.openedIssues);
      result.put("openedIssues", openedIssuesOut);

      JSONValue sizeOut = new JSONNumber(this.size);
      result.put("size", sizeOut);

      JSONValue privateRepoOut = JSONBoolean.getInstance(this.privateRepo);
      result.put("privateRepo", privateRepoOut);

      JSONValue forksOut = new JSONNumber(this.forks);
      result.put("forks", forksOut);

      JSONValue watchersOut = new JSONNumber(this.watchers);
      result.put("watchers", watchersOut);

      JSONValue htmlUrlOut = (this.htmlUrl == null) ? JSONNull.getInstance() : new JSONString(this.htmlUrl);
      result.put("htmlUrl", htmlUrlOut);

      JSONValue hasDownloadsOut = JSONBoolean.getInstance(this.hasDownloads);
      result.put("hasDownloads", hasDownloadsOut);

      JSONValue hasWikiOut = JSONBoolean.getInstance(this.hasWiki);
      result.put("hasWiki", hasWikiOut);

      JSONValue cloneUrlOut = (this.cloneUrl == null) ? JSONNull.getInstance() : new JSONString(this.cloneUrl);
      result.put("cloneUrl", cloneUrlOut);

      JSONValue pushedAtOut = (this.pushedAt == null) ? JSONNull.getInstance() : new JSONString(this.pushedAt);
      result.put("pushedAt", pushedAtOut);
      return result;
    }

    @Override
    public String toJson() {
      return toJsonObjectInt(false).toString();
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubRepositoryImpl fromJsonObject(JSONValue jsonValue) {
      return fromJsonObjectInt(jsonValue, true);
    }
    public static GitHubRepositoryImpl fromJsonObjectInt(JSONValue jsonValue, boolean copyJsons) {
      if (jsonValue == null || jsonValue.isNull() != null) {
        return null;
      }

      GitHubRepositoryImpl dto = new GitHubRepositoryImpl();
      JSONObject json = jsonValue.isObject();

      if (json.containsKey("language")) {
        JSONValue languageIn = json.get("language");
        String languageOut = languageIn.isString() != null ? languageIn.isString().stringValue() : null;
        dto.setLanguage(languageOut);
      }

      if (json.containsKey("parent")) {
        JSONValue parentIn = json.get("parent");
        org.eclipse.che.plugin.github.shared.GitHubRepository parentOut = GitHubRepositoryImpl.fromJsonObject(parentIn);
        dto.setParent(parentOut);
      }

      if (json.containsKey("name")) {
        JSONValue nameIn = json.get("name");
        String nameOut = nameIn.isString() != null ? nameIn.isString().stringValue() : null;
        dto.setName(nameOut);
      }

      if (json.containsKey("sshUrl")) {
        JSONValue sshUrlIn = json.get("sshUrl");
        String sshUrlOut = sshUrlIn.isString() != null ? sshUrlIn.isString().stringValue() : null;
        dto.setSshUrl(sshUrlOut);
      }

      if (json.containsKey("gitUrl")) {
        JSONValue gitUrlIn = json.get("gitUrl");
        String gitUrlOut = gitUrlIn.isString() != null ? gitUrlIn.isString().stringValue() : null;
        dto.setGitUrl(gitUrlOut);
      }

      if (json.containsKey("ownerLogin")) {
        JSONValue ownerLoginIn = json.get("ownerLogin");
        String ownerLoginOut = ownerLoginIn.isString() != null ? ownerLoginIn.isString().stringValue() : null;
        dto.setOwnerLogin(ownerLoginOut);
      }

      if (json.containsKey("updatedAt")) {
        JSONValue updatedAtIn = json.get("updatedAt");
        String updatedAtOut = updatedAtIn.isString() != null ? updatedAtIn.isString().stringValue() : null;
        dto.setUpdatedAt(updatedAtOut);
      }

      if (json.containsKey("homepage")) {
        JSONValue homepageIn = json.get("homepage");
        String homepageOut = homepageIn.isString() != null ? homepageIn.isString().stringValue() : null;
        dto.setHomepage(homepageOut);
      }

      if (json.containsKey("description")) {
        JSONValue descriptionIn = json.get("description");
        String descriptionOut = descriptionIn.isString() != null ? descriptionIn.isString().stringValue() : null;
        dto.setDescription(descriptionOut);
      }

      if (json.containsKey("fork")) {
        JSONValue forkIn = json.get("fork");
        boolean forkOut = forkIn.isBoolean().booleanValue();
        dto.setFork(forkOut);
      }

      if (json.containsKey("hasIssues")) {
        JSONValue hasIssuesIn = json.get("hasIssues");
        boolean hasIssuesOut = hasIssuesIn.isBoolean().booleanValue();
        dto.setHasIssues(hasIssuesOut);
      }

      if (json.containsKey("url")) {
        JSONValue urlIn = json.get("url");
        String urlOut = urlIn.isString() != null ? urlIn.isString().stringValue() : null;
        dto.setUrl(urlOut);
      }

      if (json.containsKey("createdAt")) {
        JSONValue createdAtIn = json.get("createdAt");
        String createdAtOut = createdAtIn.isString() != null ? createdAtIn.isString().stringValue() : null;
        dto.setCreatedAt(createdAtOut);
      }

      if (json.containsKey("openedIssues")) {
        JSONValue openedIssuesIn = json.get("openedIssues");
        int openedIssuesOut = (int)openedIssuesIn.isNumber().doubleValue();
        dto.setOpenedIssues(openedIssuesOut);
      }

      if (json.containsKey("size")) {
        JSONValue sizeIn = json.get("size");
        int sizeOut = (int)sizeIn.isNumber().doubleValue();
        dto.setSize(sizeOut);
      }

      if (json.containsKey("privateRepo")) {
        JSONValue privateRepoIn = json.get("privateRepo");
        boolean privateRepoOut = privateRepoIn.isBoolean().booleanValue();
        dto.setPrivateRepo(privateRepoOut);
      }

      if (json.containsKey("forks")) {
        JSONValue forksIn = json.get("forks");
        int forksOut = (int)forksIn.isNumber().doubleValue();
        dto.setForks(forksOut);
      }

      if (json.containsKey("watchers")) {
        JSONValue watchersIn = json.get("watchers");
        int watchersOut = (int)watchersIn.isNumber().doubleValue();
        dto.setWatchers(watchersOut);
      }

      if (json.containsKey("htmlUrl")) {
        JSONValue htmlUrlIn = json.get("htmlUrl");
        String htmlUrlOut = htmlUrlIn.isString() != null ? htmlUrlIn.isString().stringValue() : null;
        dto.setHtmlUrl(htmlUrlOut);
      }

      if (json.containsKey("hasDownloads")) {
        JSONValue hasDownloadsIn = json.get("hasDownloads");
        boolean hasDownloadsOut = hasDownloadsIn.isBoolean().booleanValue();
        dto.setHasDownloads(hasDownloadsOut);
      }

      if (json.containsKey("hasWiki")) {
        JSONValue hasWikiIn = json.get("hasWiki");
        boolean hasWikiOut = hasWikiIn.isBoolean().booleanValue();
        dto.setHasWiki(hasWikiOut);
      }

      if (json.containsKey("cloneUrl")) {
        JSONValue cloneUrlIn = json.get("cloneUrl");
        String cloneUrlOut = cloneUrlIn.isString() != null ? cloneUrlIn.isString().stringValue() : null;
        dto.setCloneUrl(cloneUrlOut);
      }

      if (json.containsKey("pushedAt")) {
        JSONValue pushedAtIn = json.get("pushedAt");
        String pushedAtOut = pushedAtIn.isString() != null ? pushedAtIn.isString().stringValue() : null;
        dto.setPushedAt(pushedAtOut);
      }

      return dto;
    }

    public static GitHubRepositoryImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonObjectInt(JSONParser.parseStrict(jsonString), false);
    }

    public GitHubRepositoryImpl(org.eclipse.che.plugin.github.shared.GitHubRepository origin) {
      this.language = origin.getLanguage();
      org.eclipse.che.plugin.github.shared.GitHubRepository parentIn = origin.getParent();
      this.parent = parentIn == null ? null : new GitHubRepositoryImpl(parentIn);
      this.name = origin.getName();
      this.sshUrl = origin.getSshUrl();
      this.gitUrl = origin.getGitUrl();
      this.ownerLogin = origin.getOwnerLogin();
      this.updatedAt = origin.getUpdatedAt();
      this.homepage = origin.getHomepage();
      this.description = origin.getDescription();
      this.fork = origin.isFork();
      this.hasIssues = origin.isHasIssues();
      this.url = origin.getUrl();
      this.createdAt = origin.getCreatedAt();
      this.openedIssues = origin.getOpenedIssues();
      this.size = origin.getSize();
      this.privateRepo = origin.isPrivateRepo();
      this.forks = origin.getForks();
      this.watchers = origin.getWatchers();
      this.htmlUrl = origin.getHtmlUrl();
      this.hasDownloads = origin.isHasDownloads();
      this.hasWiki = origin.isHasWiki();
      this.cloneUrl = origin.getCloneUrl();
      this.pushedAt = origin.getPushedAt();
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withLanguage(java.lang.String v) {
      this.language = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withParent(org.eclipse.che.plugin.github.shared.GitHubRepository v) {
      this.parent = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withName(java.lang.String v) {
      this.name = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withSshUrl(java.lang.String v) {
      this.sshUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withGitUrl(java.lang.String v) {
      this.gitUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withOwnerLogin(java.lang.String v) {
      this.ownerLogin = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withUpdatedAt(java.lang.String v) {
      this.updatedAt = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withHomepage(java.lang.String v) {
      this.homepage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withDescription(java.lang.String v) {
      this.description = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withFork(boolean v) {
      this.fork = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withHasIssues(boolean v) {
      this.hasIssues = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withUrl(java.lang.String v) {
      this.url = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withCreatedAt(java.lang.String v) {
      this.createdAt = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withOpenedIssues(int v) {
      this.openedIssues = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withSize(int v) {
      this.size = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withPrivateRepo(boolean v) {
      this.privateRepo = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withForks(int v) {
      this.forks = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withWatchers(int v) {
      this.watchers = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withHtmlUrl(java.lang.String v) {
      this.htmlUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withHasDownloads(boolean v) {
      this.hasDownloads = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withHasWiki(boolean v) {
      this.hasWiki = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withCloneUrl(java.lang.String v) {
      this.cloneUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withPushedAt(java.lang.String v) {
      this.pushedAt = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("client")
  public static class GitHubRepositoryListImpl implements org.eclipse.che.plugin.github.shared.GitHubRepositoryList, JsonSerializable  {

    public static GitHubRepositoryListImpl make() {
        return new GitHubRepositoryListImpl();
    }

    protected GitHubRepositoryListImpl() {
    }

    protected java.lang.String firstPage;
    protected java.lang.String lastPage;
    protected java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository> repositories;
    protected java.lang.String nextPage;
    protected java.lang.String prevPage;

    @Override
    public java.lang.String getFirstPage() {
      return firstPage;
    }

    public void setFirstPage(java.lang.String v) {
      this.firstPage = v;
    }

    @Override
    public java.lang.String getLastPage() {
      return lastPage;
    }

    public void setLastPage(java.lang.String v) {
      this.lastPage = v;
    }

    @Override
    public java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository> getRepositories() {
      ensureRepositories();
      return repositories;
    }

    public void setRepositories(java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository> v) {
      this.repositories = v;
    }

    public void addRepositories(org.eclipse.che.plugin.github.shared.GitHubRepository v) {
      ensureRepositories();
      repositories.add(v);
    }

    public void clearRepositories() {
      ensureRepositories();
      repositories.clear();
    }

    protected void ensureRepositories() {
      if (repositories == null) {
        repositories = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubRepository>();
      }
    }
    @Override
    public java.lang.String getNextPage() {
      return nextPage;
    }

    public void setNextPage(java.lang.String v) {
      this.nextPage = v;
    }

    @Override
    public java.lang.String getPrevPage() {
      return prevPage;
    }

    public void setPrevPage(java.lang.String v) {
      this.prevPage = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubRepositoryListImpl)) {
        return false;
      }
      GitHubRepositoryListImpl other = (GitHubRepositoryListImpl) o;
      if (this.firstPage != null) {
        if (!this.firstPage.equals(other.firstPage)) {
          return false;
        }
      } else {
        if (other.firstPage != null) {
          return false;
        }
      }
      if (this.lastPage != null) {
        if (!this.lastPage.equals(other.lastPage)) {
          return false;
        }
      } else {
        if (other.lastPage != null) {
          return false;
        }
      }
      if (this.repositories != null) {
        if (!this.repositories.equals(other.repositories)) {
          return false;
        }
      } else {
        if (other.repositories != null) {
          return false;
        }
      }
      if (this.nextPage != null) {
        if (!this.nextPage.equals(other.nextPage)) {
          return false;
        }
      } else {
        if (other.nextPage != null) {
          return false;
        }
      }
      if (this.prevPage != null) {
        if (!this.prevPage.equals(other.prevPage)) {
          return false;
        }
      } else {
        if (other.prevPage != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (firstPage != null ? firstPage.hashCode() : 0);
      hash = hash * 31 + (lastPage != null ? lastPage.hashCode() : 0);
      hash = hash * 31 + (repositories != null ? repositories.hashCode() : 0);
      hash = hash * 31 + (nextPage != null ? nextPage.hashCode() : 0);
      hash = hash * 31 + (prevPage != null ? prevPage.hashCode() : 0);
      return hash;
    }

    public JSONObject toJsonObject() {
      return toJsonObjectInt(true);
    }
    public JSONObject toJsonObjectInt(boolean copyJsons) {
      JSONObject result = new JSONObject();

      JSONValue firstPageOut = (this.firstPage == null) ? JSONNull.getInstance() : new JSONString(this.firstPage);
      result.put("firstPage", firstPageOut);

      JSONValue lastPageOut = (this.lastPage == null) ? JSONNull.getInstance() : new JSONString(this.lastPage);
      result.put("lastPage", lastPageOut);

      JSONArray repositoriesOut = new JSONArray();
      this.ensureRepositories();
      for (org.eclipse.che.plugin.github.shared.GitHubRepository repositories_ : this.repositories) {
        JSONValue repositoriesOut_ = repositories_ == null ? JSONNull.getInstance() : ((GitHubRepositoryImpl)repositories_).toJsonObject();
        repositoriesOut.set(repositoriesOut.size(), repositoriesOut_);
      }
      result.put("repositories", repositoriesOut);

      JSONValue nextPageOut = (this.nextPage == null) ? JSONNull.getInstance() : new JSONString(this.nextPage);
      result.put("nextPage", nextPageOut);

      JSONValue prevPageOut = (this.prevPage == null) ? JSONNull.getInstance() : new JSONString(this.prevPage);
      result.put("prevPage", prevPageOut);
      return result;
    }

    @Override
    public String toJson() {
      return toJsonObjectInt(false).toString();
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubRepositoryListImpl fromJsonObject(JSONValue jsonValue) {
      return fromJsonObjectInt(jsonValue, true);
    }
    public static GitHubRepositoryListImpl fromJsonObjectInt(JSONValue jsonValue, boolean copyJsons) {
      if (jsonValue == null || jsonValue.isNull() != null) {
        return null;
      }

      GitHubRepositoryListImpl dto = new GitHubRepositoryListImpl();
      JSONObject json = jsonValue.isObject();

      if (json.containsKey("firstPage")) {
        JSONValue firstPageIn = json.get("firstPage");
        String firstPageOut = firstPageIn.isString() != null ? firstPageIn.isString().stringValue() : null;
        dto.setFirstPage(firstPageOut);
      }

      if (json.containsKey("lastPage")) {
        JSONValue lastPageIn = json.get("lastPage");
        String lastPageOut = lastPageIn.isString() != null ? lastPageIn.isString().stringValue() : null;
        dto.setLastPage(lastPageOut);
      }

      if (json.containsKey("repositories")) {
        JSONValue repositoriesIn = json.get("repositories");
        java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository> repositoriesOut = null;
        if (repositoriesIn != null && repositoriesIn.isNull() == null) {
          repositoriesOut = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubRepository>();
          for (int repositoriesIn__iterator = 0; repositoriesIn__iterator < repositoriesIn.isArray().size(); repositoriesIn__iterator++) {
            JSONValue repositoriesIn_ = repositoriesIn.isArray().get(repositoriesIn__iterator);
            org.eclipse.che.plugin.github.shared.GitHubRepository repositoriesOut_ = GitHubRepositoryImpl.fromJsonObject(repositoriesIn_);
            repositoriesOut.add(repositoriesOut_);
          }
        }
        dto.setRepositories(repositoriesOut);
      }

      if (json.containsKey("nextPage")) {
        JSONValue nextPageIn = json.get("nextPage");
        String nextPageOut = nextPageIn.isString() != null ? nextPageIn.isString().stringValue() : null;
        dto.setNextPage(nextPageOut);
      }

      if (json.containsKey("prevPage")) {
        JSONValue prevPageIn = json.get("prevPage");
        String prevPageOut = prevPageIn.isString() != null ? prevPageIn.isString().stringValue() : null;
        dto.setPrevPage(prevPageOut);
      }

      return dto;
    }

    public static GitHubRepositoryListImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonObjectInt(JSONParser.parseStrict(jsonString), false);
    }

    public GitHubRepositoryListImpl(org.eclipse.che.plugin.github.shared.GitHubRepositoryList origin) {
      this.firstPage = origin.getFirstPage();
      this.lastPage = origin.getLastPage();
      java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository> repositoriesIn = origin.getRepositories();
      if (repositoriesIn != null) {
        java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository> repositoriesOut = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubRepository>();
        for (org.eclipse.che.plugin.github.shared.GitHubRepository repositoriesIn_ : repositoriesIn) {
            repositoriesOut.add(repositoriesIn_ == null ? null : new GitHubRepositoryImpl(repositoriesIn_));
        }
        this.repositories = repositoriesOut;
      }
      this.nextPage = origin.getNextPage();
      this.prevPage = origin.getPrevPage();
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepositoryList withFirstPage(java.lang.String v) {
      this.firstPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepositoryList withLastPage(java.lang.String v) {
      this.lastPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepositoryList withRepositories(java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository> v) {
      this.repositories = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepositoryList withNextPage(java.lang.String v) {
      this.nextPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepositoryList withPrevPage(java.lang.String v) {
      this.prevPage = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("client")
  public static class GitHubUserImpl implements org.eclipse.che.plugin.github.shared.GitHubUser, JsonSerializable  {

    public static GitHubUserImpl make() {
        return new GitHubUserImpl();
    }

    protected GitHubUserImpl() {
    }

    protected java.lang.String avatarUrl;
    protected java.lang.String location;
    protected java.lang.String name;
    protected java.lang.String id;
    protected int followers;
    protected int publicGists;
    protected int following;
    protected java.lang.String login;
    protected java.lang.String url;
    protected java.lang.String company;
    protected int publicRepos;
    protected java.lang.String type;
    protected java.lang.String htmlUrl;
    protected java.lang.String email;
    protected java.lang.String bio;
    protected java.lang.String gravatarId;

    @Override
    public java.lang.String getAvatarUrl() {
      return avatarUrl;
    }

    public void setAvatarUrl(java.lang.String v) {
      this.avatarUrl = v;
    }

    @Override
    public java.lang.String getLocation() {
      return location;
    }

    public void setLocation(java.lang.String v) {
      this.location = v;
    }

    @Override
    public java.lang.String getName() {
      return name;
    }

    public void setName(java.lang.String v) {
      this.name = v;
    }

    @Override
    public java.lang.String getId() {
      return id;
    }

    public void setId(java.lang.String v) {
      this.id = v;
    }

    @Override
    public int getFollowers() {
      return followers;
    }

    public void setFollowers(int v) {
      this.followers = v;
    }

    @Override
    public int getPublicGists() {
      return publicGists;
    }

    public void setPublicGists(int v) {
      this.publicGists = v;
    }

    @Override
    public int getFollowing() {
      return following;
    }

    public void setFollowing(int v) {
      this.following = v;
    }

    @Override
    public java.lang.String getLogin() {
      return login;
    }

    public void setLogin(java.lang.String v) {
      this.login = v;
    }

    @Override
    public java.lang.String getUrl() {
      return url;
    }

    public void setUrl(java.lang.String v) {
      this.url = v;
    }

    @Override
    public java.lang.String getCompany() {
      return company;
    }

    public void setCompany(java.lang.String v) {
      this.company = v;
    }

    @Override
    public int getPublicRepos() {
      return publicRepos;
    }

    public void setPublicRepos(int v) {
      this.publicRepos = v;
    }

    @Override
    public java.lang.String getType() {
      return type;
    }

    public void setType(java.lang.String v) {
      this.type = v;
    }

    @Override
    public java.lang.String getHtmlUrl() {
      return htmlUrl;
    }

    public void setHtmlUrl(java.lang.String v) {
      this.htmlUrl = v;
    }

    @Override
    public java.lang.String getEmail() {
      return email;
    }

    public void setEmail(java.lang.String v) {
      this.email = v;
    }

    @Override
    public java.lang.String getBio() {
      return bio;
    }

    public void setBio(java.lang.String v) {
      this.bio = v;
    }

    @Override
    public java.lang.String getGravatarId() {
      return gravatarId;
    }

    public void setGravatarId(java.lang.String v) {
      this.gravatarId = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubUserImpl)) {
        return false;
      }
      GitHubUserImpl other = (GitHubUserImpl) o;
      if (this.avatarUrl != null) {
        if (!this.avatarUrl.equals(other.avatarUrl)) {
          return false;
        }
      } else {
        if (other.avatarUrl != null) {
          return false;
        }
      }
      if (this.location != null) {
        if (!this.location.equals(other.location)) {
          return false;
        }
      } else {
        if (other.location != null) {
          return false;
        }
      }
      if (this.name != null) {
        if (!this.name.equals(other.name)) {
          return false;
        }
      } else {
        if (other.name != null) {
          return false;
        }
      }
      if (this.id != null) {
        if (!this.id.equals(other.id)) {
          return false;
        }
      } else {
        if (other.id != null) {
          return false;
        }
      }
      if (this.followers != other.followers) {
        return false;
      }
      if (this.publicGists != other.publicGists) {
        return false;
      }
      if (this.following != other.following) {
        return false;
      }
      if (this.login != null) {
        if (!this.login.equals(other.login)) {
          return false;
        }
      } else {
        if (other.login != null) {
          return false;
        }
      }
      if (this.url != null) {
        if (!this.url.equals(other.url)) {
          return false;
        }
      } else {
        if (other.url != null) {
          return false;
        }
      }
      if (this.company != null) {
        if (!this.company.equals(other.company)) {
          return false;
        }
      } else {
        if (other.company != null) {
          return false;
        }
      }
      if (this.publicRepos != other.publicRepos) {
        return false;
      }
      if (this.type != null) {
        if (!this.type.equals(other.type)) {
          return false;
        }
      } else {
        if (other.type != null) {
          return false;
        }
      }
      if (this.htmlUrl != null) {
        if (!this.htmlUrl.equals(other.htmlUrl)) {
          return false;
        }
      } else {
        if (other.htmlUrl != null) {
          return false;
        }
      }
      if (this.email != null) {
        if (!this.email.equals(other.email)) {
          return false;
        }
      } else {
        if (other.email != null) {
          return false;
        }
      }
      if (this.bio != null) {
        if (!this.bio.equals(other.bio)) {
          return false;
        }
      } else {
        if (other.bio != null) {
          return false;
        }
      }
      if (this.gravatarId != null) {
        if (!this.gravatarId.equals(other.gravatarId)) {
          return false;
        }
      } else {
        if (other.gravatarId != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (avatarUrl != null ? avatarUrl.hashCode() : 0);
      hash = hash * 31 + (location != null ? location.hashCode() : 0);
      hash = hash * 31 + (name != null ? name.hashCode() : 0);
      hash = hash * 31 + (id != null ? id.hashCode() : 0);
      hash = hash * 31 + java.lang.Integer.valueOf(followers).hashCode();
      hash = hash * 31 + java.lang.Integer.valueOf(publicGists).hashCode();
      hash = hash * 31 + java.lang.Integer.valueOf(following).hashCode();
      hash = hash * 31 + (login != null ? login.hashCode() : 0);
      hash = hash * 31 + (url != null ? url.hashCode() : 0);
      hash = hash * 31 + (company != null ? company.hashCode() : 0);
      hash = hash * 31 + java.lang.Integer.valueOf(publicRepos).hashCode();
      hash = hash * 31 + (type != null ? type.hashCode() : 0);
      hash = hash * 31 + (htmlUrl != null ? htmlUrl.hashCode() : 0);
      hash = hash * 31 + (email != null ? email.hashCode() : 0);
      hash = hash * 31 + (bio != null ? bio.hashCode() : 0);
      hash = hash * 31 + (gravatarId != null ? gravatarId.hashCode() : 0);
      return hash;
    }

    public JSONObject toJsonObject() {
      return toJsonObjectInt(true);
    }
    public JSONObject toJsonObjectInt(boolean copyJsons) {
      JSONObject result = new JSONObject();

      JSONValue avatarUrlOut = (this.avatarUrl == null) ? JSONNull.getInstance() : new JSONString(this.avatarUrl);
      result.put("avatarUrl", avatarUrlOut);

      JSONValue locationOut = (this.location == null) ? JSONNull.getInstance() : new JSONString(this.location);
      result.put("location", locationOut);

      JSONValue nameOut = (this.name == null) ? JSONNull.getInstance() : new JSONString(this.name);
      result.put("name", nameOut);

      JSONValue idOut = (this.id == null) ? JSONNull.getInstance() : new JSONString(this.id);
      result.put("id", idOut);

      JSONValue followersOut = new JSONNumber(this.followers);
      result.put("followers", followersOut);

      JSONValue publicGistsOut = new JSONNumber(this.publicGists);
      result.put("publicGists", publicGistsOut);

      JSONValue followingOut = new JSONNumber(this.following);
      result.put("following", followingOut);

      JSONValue loginOut = (this.login == null) ? JSONNull.getInstance() : new JSONString(this.login);
      result.put("login", loginOut);

      JSONValue urlOut = (this.url == null) ? JSONNull.getInstance() : new JSONString(this.url);
      result.put("url", urlOut);

      JSONValue companyOut = (this.company == null) ? JSONNull.getInstance() : new JSONString(this.company);
      result.put("company", companyOut);

      JSONValue publicReposOut = new JSONNumber(this.publicRepos);
      result.put("publicRepos", publicReposOut);

      JSONValue typeOut = (this.type == null) ? JSONNull.getInstance() : new JSONString(this.type);
      result.put("type", typeOut);

      JSONValue htmlUrlOut = (this.htmlUrl == null) ? JSONNull.getInstance() : new JSONString(this.htmlUrl);
      result.put("htmlUrl", htmlUrlOut);

      JSONValue emailOut = (this.email == null) ? JSONNull.getInstance() : new JSONString(this.email);
      result.put("email", emailOut);

      JSONValue bioOut = (this.bio == null) ? JSONNull.getInstance() : new JSONString(this.bio);
      result.put("bio", bioOut);

      JSONValue gravatarIdOut = (this.gravatarId == null) ? JSONNull.getInstance() : new JSONString(this.gravatarId);
      result.put("gravatarId", gravatarIdOut);
      return result;
    }

    @Override
    public String toJson() {
      return toJsonObjectInt(false).toString();
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubUserImpl fromJsonObject(JSONValue jsonValue) {
      return fromJsonObjectInt(jsonValue, true);
    }
    public static GitHubUserImpl fromJsonObjectInt(JSONValue jsonValue, boolean copyJsons) {
      if (jsonValue == null || jsonValue.isNull() != null) {
        return null;
      }

      GitHubUserImpl dto = new GitHubUserImpl();
      JSONObject json = jsonValue.isObject();

      if (json.containsKey("avatarUrl")) {
        JSONValue avatarUrlIn = json.get("avatarUrl");
        String avatarUrlOut = avatarUrlIn.isString() != null ? avatarUrlIn.isString().stringValue() : null;
        dto.setAvatarUrl(avatarUrlOut);
      }

      if (json.containsKey("location")) {
        JSONValue locationIn = json.get("location");
        String locationOut = locationIn.isString() != null ? locationIn.isString().stringValue() : null;
        dto.setLocation(locationOut);
      }

      if (json.containsKey("name")) {
        JSONValue nameIn = json.get("name");
        String nameOut = nameIn.isString() != null ? nameIn.isString().stringValue() : null;
        dto.setName(nameOut);
      }

      if (json.containsKey("id")) {
        JSONValue idIn = json.get("id");
        String idOut = idIn.isString() != null ? idIn.isString().stringValue() : null;
        dto.setId(idOut);
      }

      if (json.containsKey("followers")) {
        JSONValue followersIn = json.get("followers");
        int followersOut = (int)followersIn.isNumber().doubleValue();
        dto.setFollowers(followersOut);
      }

      if (json.containsKey("publicGists")) {
        JSONValue publicGistsIn = json.get("publicGists");
        int publicGistsOut = (int)publicGistsIn.isNumber().doubleValue();
        dto.setPublicGists(publicGistsOut);
      }

      if (json.containsKey("following")) {
        JSONValue followingIn = json.get("following");
        int followingOut = (int)followingIn.isNumber().doubleValue();
        dto.setFollowing(followingOut);
      }

      if (json.containsKey("login")) {
        JSONValue loginIn = json.get("login");
        String loginOut = loginIn.isString() != null ? loginIn.isString().stringValue() : null;
        dto.setLogin(loginOut);
      }

      if (json.containsKey("url")) {
        JSONValue urlIn = json.get("url");
        String urlOut = urlIn.isString() != null ? urlIn.isString().stringValue() : null;
        dto.setUrl(urlOut);
      }

      if (json.containsKey("company")) {
        JSONValue companyIn = json.get("company");
        String companyOut = companyIn.isString() != null ? companyIn.isString().stringValue() : null;
        dto.setCompany(companyOut);
      }

      if (json.containsKey("publicRepos")) {
        JSONValue publicReposIn = json.get("publicRepos");
        int publicReposOut = (int)publicReposIn.isNumber().doubleValue();
        dto.setPublicRepos(publicReposOut);
      }

      if (json.containsKey("type")) {
        JSONValue typeIn = json.get("type");
        String typeOut = typeIn.isString() != null ? typeIn.isString().stringValue() : null;
        dto.setType(typeOut);
      }

      if (json.containsKey("htmlUrl")) {
        JSONValue htmlUrlIn = json.get("htmlUrl");
        String htmlUrlOut = htmlUrlIn.isString() != null ? htmlUrlIn.isString().stringValue() : null;
        dto.setHtmlUrl(htmlUrlOut);
      }

      if (json.containsKey("email")) {
        JSONValue emailIn = json.get("email");
        String emailOut = emailIn.isString() != null ? emailIn.isString().stringValue() : null;
        dto.setEmail(emailOut);
      }

      if (json.containsKey("bio")) {
        JSONValue bioIn = json.get("bio");
        String bioOut = bioIn.isString() != null ? bioIn.isString().stringValue() : null;
        dto.setBio(bioOut);
      }

      if (json.containsKey("gravatarId")) {
        JSONValue gravatarIdIn = json.get("gravatarId");
        String gravatarIdOut = gravatarIdIn.isString() != null ? gravatarIdIn.isString().stringValue() : null;
        dto.setGravatarId(gravatarIdOut);
      }

      return dto;
    }

    public static GitHubUserImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonObjectInt(JSONParser.parseStrict(jsonString), false);
    }

    public GitHubUserImpl(org.eclipse.che.plugin.github.shared.GitHubUser origin) {
      this.avatarUrl = origin.getAvatarUrl();
      this.location = origin.getLocation();
      this.name = origin.getName();
      this.id = origin.getId();
      this.followers = origin.getFollowers();
      this.publicGists = origin.getPublicGists();
      this.following = origin.getFollowing();
      this.login = origin.getLogin();
      this.url = origin.getUrl();
      this.company = origin.getCompany();
      this.publicRepos = origin.getPublicRepos();
      this.type = origin.getType();
      this.htmlUrl = origin.getHtmlUrl();
      this.email = origin.getEmail();
      this.bio = origin.getBio();
      this.gravatarId = origin.getGravatarId();
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withAvatarUrl(java.lang.String v) {
      this.avatarUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withLocation(java.lang.String v) {
      this.location = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withName(java.lang.String v) {
      this.name = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withId(java.lang.String v) {
      this.id = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withFollowers(int v) {
      this.followers = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withPublicGists(int v) {
      this.publicGists = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withFollowing(int v) {
      this.following = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withLogin(java.lang.String v) {
      this.login = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withUrl(java.lang.String v) {
      this.url = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withCompany(java.lang.String v) {
      this.company = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withPublicRepos(int v) {
      this.publicRepos = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withType(java.lang.String v) {
      this.type = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withHtmlUrl(java.lang.String v) {
      this.htmlUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withEmail(java.lang.String v) {
      this.email = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withBio(java.lang.String v) {
      this.bio = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withGravatarId(java.lang.String v) {
      this.gravatarId = v;
      return this;
    }

  }


}