/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.ide.ext.git.server.github;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.che.api.git.GitBasicAuthenticationCredentialsProvider;
import org.eclipse.che.api.git.shared.ProviderInfo;
import org.eclipse.che.commons.env.EnvironmentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GitHubOAuthCredentialProvider
extends GitBasicAuthenticationCredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubOAuthCredentialProvider.class);
    private static String OAUTH_PROVIDER_NAME = "github";
    private final String authorizationServicePath;

    @Inject
    public GitHubOAuthCredentialProvider() {
        this.authorizationServicePath = "/oauth/authenticate";
    }

    public String getId() {
        return OAUTH_PROVIDER_NAME;
    }

    public boolean canProvideCredentials(String url) {
        return url.contains("github.com");
    }

    public ProviderInfo getProviderInfo() {
        return new ProviderInfo(OAUTH_PROVIDER_NAME, UriBuilder.fromPath((String)this.authorizationServicePath).queryParam("oauth_provider", new Object[]{OAUTH_PROVIDER_NAME}).queryParam("userId", new Object[]{EnvironmentContext.getCurrent().getSubject().getUserId()}).queryParam("scope", new Object[]{"repo,write:public_key"}).build(new Object[0]).toString());
    }
}

