/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.github.server.rest;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.che.api.core.ApiException;
import org.eclipse.che.api.core.NotFoundException;
import org.eclipse.che.api.core.ServerException;
import org.eclipse.che.api.core.UnauthorizedException;
import org.eclipse.che.api.git.exception.GitException;
import org.eclipse.che.api.ssh.shared.dto.GenerateSshPairRequest;
import org.eclipse.che.api.ssh.shared.dto.SshPairDto;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.plugin.github.server.GitHubDTOFactory;
import org.eclipse.che.plugin.github.server.GitHubFactory;
import org.eclipse.che.plugin.github.server.GitHubKeyUploader;
import org.eclipse.che.plugin.github.shared.Collaborators;
import org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput;
import org.eclipse.che.plugin.github.shared.GitHubPullRequest;
import org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput;
import org.eclipse.che.plugin.github.shared.GitHubPullRequestList;
import org.eclipse.che.plugin.github.shared.GitHubRepository;
import org.eclipse.che.plugin.github.shared.GitHubRepositoryList;
import org.eclipse.che.plugin.github.shared.GitHubUser;
import org.eclipse.che.plugin.ssh.key.SshServiceClient;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/github")
public class GitHubService {
    private final GitHubDTOFactory gitHubDTOFactory;
    private final GitHubKeyUploader githubKeyUploader;
    private final SshServiceClient sshServiceClient;
    private final GitHubFactory gitHubFactory;
    private static final String AUTH_HEADER_NAME = "X-Oauth-Token";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubService.class);

    @Inject
    public GitHubService(GitHubDTOFactory gitHubDTOFactory, GitHubKeyUploader githubKeyUploader, SshServiceClient sshServiceClient, GitHubFactory gitHubFactory) {
        this.gitHubDTOFactory = gitHubDTOFactory;
        this.githubKeyUploader = githubKeyUploader;
        this.sshServiceClient = sshServiceClient;
        this.gitHubFactory = gitHubFactory;
    }

    @GET
    @Path(value="repositories/{user}/{repository}")
    @Produces(value={"application/json"})
    public GitHubRepository getUserRepository(@PathParam(value="user") String user, @PathParam(value="repository") String repository, @HeaderParam(value="X-Oauth-Token") String oauthToken) throws ApiException {
        try {
            return this.gitHubDTOFactory.createRepository(this.gitHubFactory.oauthConnect(oauthToken).getUser(user).getRepository(repository));
        }
        catch (IOException e) {
            LOG.error("Get user info error", (Throwable)e);
            throw new ServerException(e.getMessage());
        }
    }

    @GET
    @Path(value="list/user")
    @Produces(value={"application/json"})
    public GitHubRepositoryList listRepositoriesByUser(@QueryParam(value="username") String userName, @HeaderParam(value="X-Oauth-Token") String oauthToken) throws ApiException {
        try {
            return this.gitHubDTOFactory.createRepositoriesList((PagedIterable<GHRepository>)this.gitHubFactory.oauthConnect(oauthToken).getUser(userName).listRepositories());
        }
        catch (IOException e) {
            LOG.error("Get list repositories by user fail", (Throwable)e);
            throw new ServerException(e.getMessage());
        }
    }

    @GET
    @Path(value="list/org")
    @Produces(value={"application/json"})
    public GitHubRepositoryList listRepositoriesByOrganization(@QueryParam(value="organization") String organization, @HeaderParam(value="X-Oauth-Token") String oauthToken) throws ApiException {
        try {
            return this.gitHubDTOFactory.createRepositoriesList((PagedIterable<GHRepository>)this.gitHubFactory.oauthConnect(oauthToken).getOrganization(organization).listRepositories());
        }
        catch (IOException e) {
            LOG.error("Get list repositories by organization fail", (Throwable)e);
            throw new ServerException(e.getMessage());
        }
    }

    @GET
    @Path(value="list/account")
    @Produces(value={"application/json"})
    public GitHubRepositoryList listRepositoriesByAccount(@QueryParam(value="account") String account, @HeaderParam(value="X-Oauth-Token") String oauthToken) throws ApiException {
        GitHub gitHub = this.gitHubFactory.oauthConnect(oauthToken);
        try {
            return this.gitHubDTOFactory.createRepositoriesList((PagedIterable<GHRepository>)gitHub.getOrganization(account).listRepositories());
        }
        catch (IOException ioException) {
            LOG.error("Get list repositories by account fail", (Throwable)ioException);
            try {
                return this.gitHubDTOFactory.createRepositoriesList((PagedIterable<GHRepository>)gitHub.getUser(account).listRepositories());
            }
            catch (IOException exception) {
                LOG.error("Get list repositories by account fail", (Throwable)exception);
                throw new ServerException(exception.getMessage());
            }
        }
    }

    @GET
    @Path(value="list")
    @Produces(value={"application/json"})
    public List<GitHubRepository> listRepositories(@HeaderParam(value="X-Oauth-Token") String oauthToken) throws ApiException {
        try {
            return this.gitHubDTOFactory.createRepositoriesList((PagedIterable<GHRepository>)this.gitHubFactory.oauthConnect(oauthToken).getMyself().listRepositories()).getRepositories();
        }
        catch (IOException e) {
            LOG.error("Get list repositories fail", (Throwable)e);
            throw new ServerException(e.getMessage());
        }
    }

    @GET
    @Path(value="forks/{user}/{repository}")
    @Produces(value={"application/json"})
    public GitHubRepositoryList forks(@PathParam(value="user") String user, @PathParam(value="repository") String repository, @HeaderParam(value="X-Oauth-Token") String oauthToken) throws ApiException {
        GitHubRepositoryList gitHubRepositoryList;
        try {
            gitHubRepositoryList = this.gitHubDTOFactory.createRepositoriesList();
            for (GHRepository ghRepository : this.gitHubFactory.oauthConnect(oauthToken).getMyself().listRepositories()) {
                if (!ghRepository.isFork() || !ghRepository.getName().equals(repository)) continue;
                gitHubRepositoryList = this.gitHubDTOFactory.createRepositoriesList(ghRepository);
                break;
            }
        }
        catch (IOException e) {
            LOG.error("Get forks fail", (Throwable)e);
            throw new ServerException(e.getMessage());
        }
        return gitHubRepositoryList;
    }

    @GET
    @Path(value="createfork/{user}/{repository}")
    @Produces(value={"application/json"})
    public GitHubRepository fork(@PathParam(value="user") String user, @PathParam(value="repository") String repository, @HeaderParam(value="X-Oauth-Token") String oauthToken) throws ApiException {
        try {
            return this.gitHubDTOFactory.createRepository(this.gitHubFactory.oauthConnect(oauthToken).getUser(user).getRepository(repository).fork());
        }
        catch (IOException e) {
            LOG.error("Fork fail", (Throwable)e);
            throw new ServerException(e.getMessage());
        }
    }

    @POST
    @Path(value="issuecomments/{user}/{repository}/{issue}")
    @Produces(value={"application/json"})
    public void commentIssue(@PathParam(value="user") String user, @PathParam(value="repository") String repository, @PathParam(value="issue") String issue, @HeaderParam(value="X-Oauth-Token") String oauthToken, GitHubIssueCommentInput input) throws ApiException {
        try {
            this.gitHubFactory.oauthConnect(oauthToken).getUser(user).getRepository(repository).getIssue(Integer.getInteger(issue).intValue()).comment(input.getBody());
        }
        catch (IOException e) {
            LOG.error("Comment issue fail", (Throwable)e);
            throw new ServerException(e.getMessage());
        }
    }

    @GET
    @Path(value="pullrequests/{user}/{repository}")
    @Produces(value={"application/json"})
    public GitHubPullRequestList listPullRequestsByRepository(@PathParam(value="user") String user, @PathParam(value="repository") String repository, @QueryParam(value="head") String head, @HeaderParam(value="X-Oauth-Token") String oauthToken) throws ApiException {
        try {
            return this.gitHubDTOFactory.createPullRequestsList((PagedIterable<GHPullRequest>)this.gitHubFactory.oauthConnect(oauthToken).getUser(user).getRepository(repository).queryPullRequests().head(head).state(GHIssueState.OPEN).list());
        }
        catch (IOException e) {
            LOG.error("Getting list of pull request by repositories", (Throwable)e);
            throw new ServerException(e.getMessage());
        }
    }

    @GET
    @Path(value="pullrequests/{user}/{repository}/{pullRequestId}")
    @Produces(value={"application/json"})
    public GitHubPullRequestList getPullRequestsById(@PathParam(value="user") String user, @PathParam(value="repository") String repository, @PathParam(value="pullRequestId") String pullRequestId, @HeaderParam(value="X-Oauth-Token") String oauthToken) throws ApiException {
        try {
            return this.gitHubDTOFactory.createPullRequestsList(this.gitHubFactory.oauthConnect(oauthToken).getUser(user).getRepository(repository).getPullRequest(Integer.valueOf(pullRequestId).intValue()));
        }
        catch (IOException e) {
            LOG.error("Getting list of pull request by id", (Throwable)e);
            throw new ServerException(e.getMessage());
        }
    }

    @POST
    @Path(value="pullrequest/{user}/{repository}")
    @Produces(value={"application/json"})
    public GitHubPullRequest createPullRequest(@PathParam(value="user") String user, @PathParam(value="repository") String repository, @HeaderParam(value="X-Oauth-Token") String oauthToken, GitHubPullRequestCreationInput input) throws ApiException {
        try {
            GHPullRequest pullRequest = this.gitHubFactory.oauthConnect(oauthToken).getUser(user).getRepository(repository).createPullRequest(input.getTitle(), input.getHead(), input.getBase(), input.getBody());
            return this.gitHubDTOFactory.createPullRequest(pullRequest);
        }
        catch (Exception e) {
            if (!e.getMessage().contains("No commits between master and master")) {
                LOG.error("Creating  pull request fail", (Throwable)e);
            }
            throw new ServerException(e.getMessage());
        }
    }

    @PUT
    @Path(value="pullrequest/{user}/{repository}/{pullRequestId}")
    @Produces(value={"application/json"})
    public GitHubPullRequest updatePullRequest(@PathParam(value="user") String user, @PathParam(value="repository") String repository, @PathParam(value="pullRequestId") String pullRequestId, @HeaderParam(value="X-Oauth-Token") String oauthToken, GitHubPullRequest pullRequest) throws ServerException, UnauthorizedException {
        try {
            String title;
            GHPullRequest ghPullRequest = this.gitHubFactory.oauthConnect(oauthToken).getUser(user).getRepository(repository).getPullRequest(Integer.valueOf(pullRequestId).intValue());
            String body = pullRequest.getBody();
            if (body != null && !body.equals(ghPullRequest.getBody())) {
                ghPullRequest.setBody(body);
            }
            if ((title = pullRequest.getTitle()) != null && !title.equals(ghPullRequest.getTitle())) {
                ghPullRequest.setTitle(title);
            }
            return this.gitHubDTOFactory.createPullRequest(ghPullRequest);
        }
        catch (IOException ioEx) {
            throw new ServerException(ioEx.getMessage());
        }
    }

    @GET
    @Path(value="orgs")
    @Produces(value={"application/json"})
    public List<GitHubUser> listOrganizations(@HeaderParam(value="X-Oauth-Token") String oauthToken) throws ApiException {
        try {
            return this.gitHubDTOFactory.createCollaborators((GHPersonSet<? extends GHPerson>)this.gitHubFactory.oauthConnect(oauthToken).getMyself().getAllOrganizations()).getCollaborators();
        }
        catch (IOException e) {
            LOG.error("Getting list of available organizations fail", (Throwable)e);
            throw new ServerException(e.getMessage());
        }
    }

    @GET
    @Path(value="user")
    @Produces(value={"application/json"})
    public GitHubUser getUserInfo(@HeaderParam(value="X-Oauth-Token") String oauthToken) throws ApiException {
        try {
            return this.gitHubDTOFactory.createUser((GHPerson)GitHub.connectUsingOAuth((String)oauthToken).getMyself());
        }
        catch (IOException e) {
            LOG.error("Getting user info fail", (Throwable)e);
            throw new ServerException(e.getMessage());
        }
    }

    @GET
    @Path(value="collaborators/{user}/{repository}")
    @Produces(value={"application/json"})
    public Collaborators collaborators(@PathParam(value="user") String user, @PathParam(value="repository") String repository, @HeaderParam(value="X-Oauth-Token") String oauthToken) throws ApiException {
        try {
            return this.gitHubDTOFactory.createCollaborators((GHPersonSet<? extends GHPerson>)this.gitHubFactory.oauthConnect(oauthToken).getUser(user).getRepository(repository).getCollaborators());
        }
        catch (IOException e) {
            LOG.error("Get collaborators fail", (Throwable)e);
            throw new ServerException(e.getMessage());
        }
    }

    @POST
    @Path(value="ssh/generate")
    public void updateSSHKey(@HeaderParam(value="X-Oauth-Token") String oauthToken) throws ApiException {
        String host = "github.com";
        SshPairDto sshPair = null;
        try {
            sshPair = this.sshServiceClient.getPair("vcs", "github.com");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (sshPair != null) {
            if (sshPair.getPublicKey() == null) {
                this.sshServiceClient.removePair("vcs", "github.com");
                sshPair = this.sshServiceClient.generatePair(((GenerateSshPairRequest)DtoFactory.newDto(GenerateSshPairRequest.class)).withService("vcs").withName("github.com"));
            }
        } else {
            sshPair = this.sshServiceClient.generatePair(((GenerateSshPairRequest)DtoFactory.newDto(GenerateSshPairRequest.class)).withService("vcs").withName("github.com"));
        }
        try {
            this.githubKeyUploader.uploadKey(sshPair.getPublicKey(), oauthToken);
        }
        catch (IOException e) {
            LOG.error("Upload github ssh key fail", (Throwable)e);
            throw new GitException(e.getMessage(), (Throwable)e);
        }
    }
}

