/*******************************************************************************
 * Copyright (c) 2012-2016 Red Hat, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Red Hat, Inc. - initial API and implementation
 *******************************************************************************/


// GENERATED SOURCE. DO NOT EDIT.
package org.eclipse.che.plugin.github.server.dto;

import org.eclipse.che.dto.server.JsonSerializable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;

import java.util.List;
import java.util.Map;


@SuppressWarnings({"unchecked", "cast", "MissingOverride"})
public class DtoServerImpls implements org.eclipse.che.dto.server.DtoFactoryVisitor {

  private static final Gson gson = org.eclipse.che.dto.server.DtoFactory.getInstance().getGson();

  @Override
  public void accept(org.eclipse.che.dto.server.DtoFactory dtoFactory) {
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.Collaborators.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.plugin.github.shared.Collaborators>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.Collaborators> getImplClass() {
            return CollaboratorsImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.Collaborators newInstance() {
            return CollaboratorsImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.Collaborators fromJson(String json) {
            return CollaboratorsImpl.fromJsonString(json);
        }

        public org.eclipse.che.plugin.github.shared.Collaborators fromJson(com.google.gson.JsonElement json) {
            return CollaboratorsImpl.fromJsonElement(json);
        }

        public org.eclipse.che.plugin.github.shared.Collaborators clone(org.eclipse.che.plugin.github.shared.Collaborators origin) {
            return new CollaboratorsImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubIssueComment.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubIssueComment>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubIssueComment> getImplClass() {
            return GitHubIssueCommentImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubIssueComment newInstance() {
            return GitHubIssueCommentImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubIssueComment fromJson(String json) {
            return GitHubIssueCommentImpl.fromJsonString(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubIssueComment fromJson(com.google.gson.JsonElement json) {
            return GitHubIssueCommentImpl.fromJsonElement(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubIssueComment clone(org.eclipse.che.plugin.github.shared.GitHubIssueComment origin) {
            return new GitHubIssueCommentImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput> getImplClass() {
            return GitHubIssueCommentInputImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput newInstance() {
            return GitHubIssueCommentInputImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput fromJson(String json) {
            return GitHubIssueCommentInputImpl.fromJsonString(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput fromJson(com.google.gson.JsonElement json) {
            return GitHubIssueCommentInputImpl.fromJsonElement(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput clone(org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput origin) {
            return new GitHubIssueCommentInputImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubKey.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubKey>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubKey> getImplClass() {
            return GitHubKeyImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubKey newInstance() {
            return GitHubKeyImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubKey fromJson(String json) {
            return GitHubKeyImpl.fromJsonString(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubKey fromJson(com.google.gson.JsonElement json) {
            return GitHubKeyImpl.fromJsonElement(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubKey clone(org.eclipse.che.plugin.github.shared.GitHubKey origin) {
            return new GitHubKeyImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubPullRequest.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubPullRequest>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubPullRequest> getImplClass() {
            return GitHubPullRequestImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequest newInstance() {
            return GitHubPullRequestImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequest fromJson(String json) {
            return GitHubPullRequestImpl.fromJsonString(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequest fromJson(com.google.gson.JsonElement json) {
            return GitHubPullRequestImpl.fromJsonElement(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequest clone(org.eclipse.che.plugin.github.shared.GitHubPullRequest origin) {
            return new GitHubPullRequestImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput> getImplClass() {
            return GitHubPullRequestCreationInputImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput newInstance() {
            return GitHubPullRequestCreationInputImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput fromJson(String json) {
            return GitHubPullRequestCreationInputImpl.fromJsonString(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput fromJson(com.google.gson.JsonElement json) {
            return GitHubPullRequestCreationInputImpl.fromJsonElement(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput clone(org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput origin) {
            return new GitHubPullRequestCreationInputImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubPullRequestHead.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubPullRequestHead>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubPullRequestHead> getImplClass() {
            return GitHubPullRequestHeadImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead newInstance() {
            return GitHubPullRequestHeadImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead fromJson(String json) {
            return GitHubPullRequestHeadImpl.fromJsonString(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead fromJson(com.google.gson.JsonElement json) {
            return GitHubPullRequestHeadImpl.fromJsonElement(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead clone(org.eclipse.che.plugin.github.shared.GitHubPullRequestHead origin) {
            return new GitHubPullRequestHeadImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubPullRequestList.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubPullRequestList>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubPullRequestList> getImplClass() {
            return GitHubPullRequestListImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestList newInstance() {
            return GitHubPullRequestListImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestList fromJson(String json) {
            return GitHubPullRequestListImpl.fromJsonString(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestList fromJson(com.google.gson.JsonElement json) {
            return GitHubPullRequestListImpl.fromJsonElement(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubPullRequestList clone(org.eclipse.che.plugin.github.shared.GitHubPullRequestList origin) {
            return new GitHubPullRequestListImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubRepository.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubRepository>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubRepository> getImplClass() {
            return GitHubRepositoryImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubRepository newInstance() {
            return GitHubRepositoryImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubRepository fromJson(String json) {
            return GitHubRepositoryImpl.fromJsonString(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubRepository fromJson(com.google.gson.JsonElement json) {
            return GitHubRepositoryImpl.fromJsonElement(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubRepository clone(org.eclipse.che.plugin.github.shared.GitHubRepository origin) {
            return new GitHubRepositoryImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubRepositoryList.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubRepositoryList>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubRepositoryList> getImplClass() {
            return GitHubRepositoryListImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubRepositoryList newInstance() {
            return GitHubRepositoryListImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubRepositoryList fromJson(String json) {
            return GitHubRepositoryListImpl.fromJsonString(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubRepositoryList fromJson(com.google.gson.JsonElement json) {
            return GitHubRepositoryListImpl.fromJsonElement(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubRepositoryList clone(org.eclipse.che.plugin.github.shared.GitHubRepositoryList origin) {
            return new GitHubRepositoryListImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.plugin.github.shared.GitHubUser.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.plugin.github.shared.GitHubUser>() {
        public Class<? extends org.eclipse.che.plugin.github.shared.GitHubUser> getImplClass() {
            return GitHubUserImpl.class;
        }

        public org.eclipse.che.plugin.github.shared.GitHubUser newInstance() {
            return GitHubUserImpl.make();
        }

        public org.eclipse.che.plugin.github.shared.GitHubUser fromJson(String json) {
            return GitHubUserImpl.fromJsonString(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubUser fromJson(com.google.gson.JsonElement json) {
            return GitHubUserImpl.fromJsonElement(json);
        }

        public org.eclipse.che.plugin.github.shared.GitHubUser clone(org.eclipse.che.plugin.github.shared.GitHubUser origin) {
            return new GitHubUserImpl(origin);
        }
    });
  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class CollaboratorsImpl implements org.eclipse.che.plugin.github.shared.Collaborators, JsonSerializable  {

    public static CollaboratorsImpl make() {
        return new CollaboratorsImpl();
    }

    public CollaboratorsImpl() {
    }

    protected java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser> collaborators;

    @Override
    public java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser> getCollaborators() {
      ensureCollaborators();
      return (java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser>)(new org.eclipse.che.dto.server.JsonArrayImpl(collaborators));
    }

    public void setCollaborators(java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser> v) {
      this.collaborators = v;
    }

    public void addCollaborators(org.eclipse.che.plugin.github.shared.GitHubUser v) {
      ensureCollaborators();
      collaborators.add(v);
    }

    public void clearCollaborators() {
      ensureCollaborators();
      collaborators.clear();
    }

    protected void ensureCollaborators() {
      if (collaborators == null) {
        collaborators = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubUser>();
      }
    }
    @Override
    public boolean equals(Object o) {
      if (!(o instanceof CollaboratorsImpl)) {
        return false;
      }
      CollaboratorsImpl other = (CollaboratorsImpl) o;
      this.ensureCollaborators();
      other.ensureCollaborators();
      
      if (this.collaborators != null) {
        if (!this.collaborators.equals(other.collaborators)) {
          return false;
        }
      } else {
        if (other.collaborators != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      ensureCollaborators();
      hash = hash * 31 + (collaborators != null ? collaborators.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
        return gson.toJsonTree(this);
    }
    @Override
    public void toJson(java.io.Writer w) {
        gson.toJson(this, w);
    }
    @Override
    public String toJson() {
      return gson.toJson(this);
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static CollaboratorsImpl fromJsonElement(JsonElement jsonElem) {
      return gson.fromJson(jsonElem, CollaboratorsImpl.class);
    }
    public static CollaboratorsImpl fromJsonString(String jsonString) {
      return gson.fromJson(jsonString, CollaboratorsImpl.class);
    }

    public CollaboratorsImpl(org.eclipse.che.plugin.github.shared.Collaborators origin) {
      java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser> collaboratorsIn = origin.getCollaborators();
      if (collaboratorsIn != null) {
        java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser> collaboratorsOut = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubUser>();
        for (org.eclipse.che.plugin.github.shared.GitHubUser collaboratorsIn_ : collaboratorsIn) {
            collaboratorsOut.add(collaboratorsIn_ == null ? null : new GitHubUserImpl(collaboratorsIn_));
        }
        this.collaborators = collaboratorsOut;
      }
    }

    public org.eclipse.che.plugin.github.shared.Collaborators withCollaborators(java.util.List<org.eclipse.che.plugin.github.shared.GitHubUser> v) {
      this.collaborators = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class GitHubIssueCommentImpl implements org.eclipse.che.plugin.github.shared.GitHubIssueComment, JsonSerializable  {

    public static GitHubIssueCommentImpl make() {
        return new GitHubIssueCommentImpl();
    }

    public GitHubIssueCommentImpl() {
    }

    protected java.lang.String url;
    protected java.lang.String body;
    protected java.lang.String id;

    @Override
    public java.lang.String getUrl() {
      return (java.lang.String)(url);
    }

    public void setUrl(java.lang.String v) {
      this.url = v;
    }

    @Override
    public java.lang.String getBody() {
      return (java.lang.String)(body);
    }

    public void setBody(java.lang.String v) {
      this.body = v;
    }

    @Override
    public java.lang.String getId() {
      return (java.lang.String)(id);
    }

    public void setId(java.lang.String v) {
      this.id = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubIssueCommentImpl)) {
        return false;
      }
      GitHubIssueCommentImpl other = (GitHubIssueCommentImpl) o;
      if (this.url != null) {
        if (!this.url.equals(other.url)) {
          return false;
        }
      } else {
        if (other.url != null) {
          return false;
        }
      }
      if (this.body != null) {
        if (!this.body.equals(other.body)) {
          return false;
        }
      } else {
        if (other.body != null) {
          return false;
        }
      }
      if (this.id != null) {
        if (!this.id.equals(other.id)) {
          return false;
        }
      } else {
        if (other.id != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (url != null ? url.hashCode() : 0);
      hash = hash * 31 + (body != null ? body.hashCode() : 0);
      hash = hash * 31 + (id != null ? id.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
        return gson.toJsonTree(this);
    }
    @Override
    public void toJson(java.io.Writer w) {
        gson.toJson(this, w);
    }
    @Override
    public String toJson() {
      return gson.toJson(this);
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubIssueCommentImpl fromJsonElement(JsonElement jsonElem) {
      return gson.fromJson(jsonElem, GitHubIssueCommentImpl.class);
    }
    public static GitHubIssueCommentImpl fromJsonString(String jsonString) {
      return gson.fromJson(jsonString, GitHubIssueCommentImpl.class);
    }

    public GitHubIssueCommentImpl(org.eclipse.che.plugin.github.shared.GitHubIssueComment origin) {
      this.url = origin.getUrl();
      this.body = origin.getBody();
      this.id = origin.getId();
    }

    public org.eclipse.che.plugin.github.shared.GitHubIssueComment withUrl(java.lang.String v) {
      this.url = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubIssueComment withBody(java.lang.String v) {
      this.body = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubIssueComment withId(java.lang.String v) {
      this.id = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class GitHubIssueCommentInputImpl implements org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput, JsonSerializable  {

    public static GitHubIssueCommentInputImpl make() {
        return new GitHubIssueCommentInputImpl();
    }

    public GitHubIssueCommentInputImpl() {
    }

    protected java.lang.String body;

    @Override
    public java.lang.String getBody() {
      return (java.lang.String)(body);
    }

    public void setBody(java.lang.String v) {
      this.body = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubIssueCommentInputImpl)) {
        return false;
      }
      GitHubIssueCommentInputImpl other = (GitHubIssueCommentInputImpl) o;
      if (this.body != null) {
        if (!this.body.equals(other.body)) {
          return false;
        }
      } else {
        if (other.body != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (body != null ? body.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
        return gson.toJsonTree(this);
    }
    @Override
    public void toJson(java.io.Writer w) {
        gson.toJson(this, w);
    }
    @Override
    public String toJson() {
      return gson.toJson(this);
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubIssueCommentInputImpl fromJsonElement(JsonElement jsonElem) {
      return gson.fromJson(jsonElem, GitHubIssueCommentInputImpl.class);
    }
    public static GitHubIssueCommentInputImpl fromJsonString(String jsonString) {
      return gson.fromJson(jsonString, GitHubIssueCommentInputImpl.class);
    }

    public GitHubIssueCommentInputImpl(org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput origin) {
      this.body = origin.getBody();
    }

    public org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput withBody(java.lang.String v) {
      this.body = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class GitHubKeyImpl implements org.eclipse.che.plugin.github.shared.GitHubKey, JsonSerializable  {

    public static GitHubKeyImpl make() {
        return new GitHubKeyImpl();
    }

    public GitHubKeyImpl() {
    }

    protected java.lang.String url;
    protected java.lang.String key;
    protected java.lang.String title;
    protected int id;

    @Override
    public java.lang.String getUrl() {
      return (java.lang.String)(url);
    }

    public void setUrl(java.lang.String v) {
      this.url = v;
    }

    @Override
    public java.lang.String getKey() {
      return (java.lang.String)(key);
    }

    public void setKey(java.lang.String v) {
      this.key = v;
    }

    @Override
    public java.lang.String getTitle() {
      return (java.lang.String)(title);
    }

    public void setTitle(java.lang.String v) {
      this.title = v;
    }

    @Override
    public int getId() {
      return (int)(id);
    }

    public void setId(int v) {
      this.id = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubKeyImpl)) {
        return false;
      }
      GitHubKeyImpl other = (GitHubKeyImpl) o;
      if (this.url != null) {
        if (!this.url.equals(other.url)) {
          return false;
        }
      } else {
        if (other.url != null) {
          return false;
        }
      }
      if (this.key != null) {
        if (!this.key.equals(other.key)) {
          return false;
        }
      } else {
        if (other.key != null) {
          return false;
        }
      }
      if (this.title != null) {
        if (!this.title.equals(other.title)) {
          return false;
        }
      } else {
        if (other.title != null) {
          return false;
        }
      }
      if (this.id != other.id) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (url != null ? url.hashCode() : 0);
      hash = hash * 31 + (key != null ? key.hashCode() : 0);
      hash = hash * 31 + (title != null ? title.hashCode() : 0);
      hash = hash * 31 + java.lang.Integer.valueOf(id).hashCode();
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
        return gson.toJsonTree(this);
    }
    @Override
    public void toJson(java.io.Writer w) {
        gson.toJson(this, w);
    }
    @Override
    public String toJson() {
      return gson.toJson(this);
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubKeyImpl fromJsonElement(JsonElement jsonElem) {
      return gson.fromJson(jsonElem, GitHubKeyImpl.class);
    }
    public static GitHubKeyImpl fromJsonString(String jsonString) {
      return gson.fromJson(jsonString, GitHubKeyImpl.class);
    }

    public GitHubKeyImpl(org.eclipse.che.plugin.github.shared.GitHubKey origin) {
      this.url = origin.getUrl();
      this.key = origin.getKey();
      this.title = origin.getTitle();
      this.id = origin.getId();
    }

    public org.eclipse.che.plugin.github.shared.GitHubKey withUrl(java.lang.String v) {
      this.url = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubKey withKey(java.lang.String v) {
      this.key = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubKey withTitle(java.lang.String v) {
      this.title = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubKey withId(int v) {
      this.id = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class GitHubPullRequestImpl implements org.eclipse.che.plugin.github.shared.GitHubPullRequest, JsonSerializable  {

    public static GitHubPullRequestImpl make() {
        return new GitHubPullRequestImpl();
    }

    public GitHubPullRequestImpl() {
    }

    protected java.lang.String number;
    protected boolean mergeable;
    protected java.lang.String url;
    protected java.lang.String title;
    protected java.lang.String state;
    protected java.lang.String body;
    protected org.eclipse.che.plugin.github.shared.GitHubPullRequestHead head;
    protected java.lang.String htmlUrl;
    protected org.eclipse.che.plugin.github.shared.GitHubUser mergedBy;
    protected java.lang.String id;
    protected boolean merged;

    @Override
    public java.lang.String getNumber() {
      return (java.lang.String)(number);
    }

    public void setNumber(java.lang.String v) {
      this.number = v;
    }

    @Override
    public boolean getMergeable() {
      return (boolean)(mergeable);
    }

    public void setMergeable(boolean v) {
      this.mergeable = v;
    }

    @Override
    public java.lang.String getUrl() {
      return (java.lang.String)(url);
    }

    public void setUrl(java.lang.String v) {
      this.url = v;
    }

    @Override
    public java.lang.String getTitle() {
      return (java.lang.String)(title);
    }

    public void setTitle(java.lang.String v) {
      this.title = v;
    }

    @Override
    public java.lang.String getState() {
      return (java.lang.String)(state);
    }

    public void setState(java.lang.String v) {
      this.state = v;
    }

    @Override
    public java.lang.String getBody() {
      return (java.lang.String)(body);
    }

    public void setBody(java.lang.String v) {
      this.body = v;
    }

    @Override
    public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead getHead() {
      return (org.eclipse.che.plugin.github.shared.GitHubPullRequestHead)(head);
    }

    public void setHead(org.eclipse.che.plugin.github.shared.GitHubPullRequestHead v) {
      this.head = v;
    }

    @Override
    public java.lang.String getHtmlUrl() {
      return (java.lang.String)(htmlUrl);
    }

    public void setHtmlUrl(java.lang.String v) {
      this.htmlUrl = v;
    }

    @Override
    public org.eclipse.che.plugin.github.shared.GitHubUser getMergedBy() {
      return (org.eclipse.che.plugin.github.shared.GitHubUser)(mergedBy);
    }

    public void setMergedBy(org.eclipse.che.plugin.github.shared.GitHubUser v) {
      this.mergedBy = v;
    }

    @Override
    public java.lang.String getId() {
      return (java.lang.String)(id);
    }

    public void setId(java.lang.String v) {
      this.id = v;
    }

    @Override
    public boolean getMerged() {
      return (boolean)(merged);
    }

    public void setMerged(boolean v) {
      this.merged = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubPullRequestImpl)) {
        return false;
      }
      GitHubPullRequestImpl other = (GitHubPullRequestImpl) o;
      if (this.number != null) {
        if (!this.number.equals(other.number)) {
          return false;
        }
      } else {
        if (other.number != null) {
          return false;
        }
      }
      if (this.mergeable != other.mergeable) {
        return false;
      }
      if (this.url != null) {
        if (!this.url.equals(other.url)) {
          return false;
        }
      } else {
        if (other.url != null) {
          return false;
        }
      }
      if (this.title != null) {
        if (!this.title.equals(other.title)) {
          return false;
        }
      } else {
        if (other.title != null) {
          return false;
        }
      }
      if (this.state != null) {
        if (!this.state.equals(other.state)) {
          return false;
        }
      } else {
        if (other.state != null) {
          return false;
        }
      }
      if (this.body != null) {
        if (!this.body.equals(other.body)) {
          return false;
        }
      } else {
        if (other.body != null) {
          return false;
        }
      }
      if (this.head != null) {
        if (!this.head.equals(other.head)) {
          return false;
        }
      } else {
        if (other.head != null) {
          return false;
        }
      }
      if (this.htmlUrl != null) {
        if (!this.htmlUrl.equals(other.htmlUrl)) {
          return false;
        }
      } else {
        if (other.htmlUrl != null) {
          return false;
        }
      }
      if (this.mergedBy != null) {
        if (!this.mergedBy.equals(other.mergedBy)) {
          return false;
        }
      } else {
        if (other.mergedBy != null) {
          return false;
        }
      }
      if (this.id != null) {
        if (!this.id.equals(other.id)) {
          return false;
        }
      } else {
        if (other.id != null) {
          return false;
        }
      }
      if (this.merged != other.merged) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (number != null ? number.hashCode() : 0);
      hash = hash * 31 + java.lang.Boolean.valueOf(mergeable).hashCode();
      hash = hash * 31 + (url != null ? url.hashCode() : 0);
      hash = hash * 31 + (title != null ? title.hashCode() : 0);
      hash = hash * 31 + (state != null ? state.hashCode() : 0);
      hash = hash * 31 + (body != null ? body.hashCode() : 0);
      hash = hash * 31 + (head != null ? head.hashCode() : 0);
      hash = hash * 31 + (htmlUrl != null ? htmlUrl.hashCode() : 0);
      hash = hash * 31 + (mergedBy != null ? mergedBy.hashCode() : 0);
      hash = hash * 31 + (id != null ? id.hashCode() : 0);
      hash = hash * 31 + java.lang.Boolean.valueOf(merged).hashCode();
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
        return gson.toJsonTree(this);
    }
    @Override
    public void toJson(java.io.Writer w) {
        gson.toJson(this, w);
    }
    @Override
    public String toJson() {
      return gson.toJson(this);
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubPullRequestImpl fromJsonElement(JsonElement jsonElem) {
      return gson.fromJson(jsonElem, GitHubPullRequestImpl.class);
    }
    public static GitHubPullRequestImpl fromJsonString(String jsonString) {
      return gson.fromJson(jsonString, GitHubPullRequestImpl.class);
    }

    public GitHubPullRequestImpl(org.eclipse.che.plugin.github.shared.GitHubPullRequest origin) {
      this.number = origin.getNumber();
      this.mergeable = origin.getMergeable();
      this.url = origin.getUrl();
      this.title = origin.getTitle();
      this.state = origin.getState();
      this.body = origin.getBody();
      org.eclipse.che.plugin.github.shared.GitHubPullRequestHead headIn = origin.getHead();
      this.head = headIn == null ? null : new GitHubPullRequestHeadImpl(headIn);
      this.htmlUrl = origin.getHtmlUrl();
      org.eclipse.che.plugin.github.shared.GitHubUser mergedByIn = origin.getMergedBy();
      this.mergedBy = mergedByIn == null ? null : new GitHubUserImpl(mergedByIn);
      this.id = origin.getId();
      this.merged = origin.getMerged();
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withNumber(java.lang.String v) {
      this.number = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withMergeable(boolean v) {
      this.mergeable = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withUrl(java.lang.String v) {
      this.url = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withTitle(java.lang.String v) {
      this.title = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withState(java.lang.String v) {
      this.state = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withBody(java.lang.String v) {
      this.body = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withHead(org.eclipse.che.plugin.github.shared.GitHubPullRequestHead v) {
      this.head = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withHtmlUrl(java.lang.String v) {
      this.htmlUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withMergedBy(org.eclipse.che.plugin.github.shared.GitHubUser v) {
      this.mergedBy = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withId(java.lang.String v) {
      this.id = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequest withMerged(boolean v) {
      this.merged = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class GitHubPullRequestCreationInputImpl implements org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput, JsonSerializable  {

    public static GitHubPullRequestCreationInputImpl make() {
        return new GitHubPullRequestCreationInputImpl();
    }

    public GitHubPullRequestCreationInputImpl() {
    }

    protected java.lang.String title;
    protected java.lang.String body;
    protected java.lang.String head;
    protected java.lang.String base;

    @Override
    public java.lang.String getTitle() {
      return (java.lang.String)(title);
    }

    public void setTitle(java.lang.String v) {
      this.title = v;
    }

    @Override
    public java.lang.String getBody() {
      return (java.lang.String)(body);
    }

    public void setBody(java.lang.String v) {
      this.body = v;
    }

    @Override
    public java.lang.String getHead() {
      return (java.lang.String)(head);
    }

    public void setHead(java.lang.String v) {
      this.head = v;
    }

    @Override
    public java.lang.String getBase() {
      return (java.lang.String)(base);
    }

    public void setBase(java.lang.String v) {
      this.base = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubPullRequestCreationInputImpl)) {
        return false;
      }
      GitHubPullRequestCreationInputImpl other = (GitHubPullRequestCreationInputImpl) o;
      if (this.title != null) {
        if (!this.title.equals(other.title)) {
          return false;
        }
      } else {
        if (other.title != null) {
          return false;
        }
      }
      if (this.body != null) {
        if (!this.body.equals(other.body)) {
          return false;
        }
      } else {
        if (other.body != null) {
          return false;
        }
      }
      if (this.head != null) {
        if (!this.head.equals(other.head)) {
          return false;
        }
      } else {
        if (other.head != null) {
          return false;
        }
      }
      if (this.base != null) {
        if (!this.base.equals(other.base)) {
          return false;
        }
      } else {
        if (other.base != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (title != null ? title.hashCode() : 0);
      hash = hash * 31 + (body != null ? body.hashCode() : 0);
      hash = hash * 31 + (head != null ? head.hashCode() : 0);
      hash = hash * 31 + (base != null ? base.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
        return gson.toJsonTree(this);
    }
    @Override
    public void toJson(java.io.Writer w) {
        gson.toJson(this, w);
    }
    @Override
    public String toJson() {
      return gson.toJson(this);
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubPullRequestCreationInputImpl fromJsonElement(JsonElement jsonElem) {
      return gson.fromJson(jsonElem, GitHubPullRequestCreationInputImpl.class);
    }
    public static GitHubPullRequestCreationInputImpl fromJsonString(String jsonString) {
      return gson.fromJson(jsonString, GitHubPullRequestCreationInputImpl.class);
    }

    public GitHubPullRequestCreationInputImpl(org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput origin) {
      this.title = origin.getTitle();
      this.body = origin.getBody();
      this.head = origin.getHead();
      this.base = origin.getBase();
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput withTitle(java.lang.String v) {
      this.title = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput withBody(java.lang.String v) {
      this.body = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput withHead(java.lang.String v) {
      this.head = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput withBase(java.lang.String v) {
      this.base = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class GitHubPullRequestHeadImpl implements org.eclipse.che.plugin.github.shared.GitHubPullRequestHead, JsonSerializable  {

    public static GitHubPullRequestHeadImpl make() {
        return new GitHubPullRequestHeadImpl();
    }

    public GitHubPullRequestHeadImpl() {
    }

    protected java.lang.String label;
    protected java.lang.String ref;
    protected java.lang.String sha;

    @Override
    public java.lang.String getLabel() {
      return (java.lang.String)(label);
    }

    public void setLabel(java.lang.String v) {
      this.label = v;
    }

    @Override
    public java.lang.String getRef() {
      return (java.lang.String)(ref);
    }

    public void setRef(java.lang.String v) {
      this.ref = v;
    }

    @Override
    public java.lang.String getSha() {
      return (java.lang.String)(sha);
    }

    public void setSha(java.lang.String v) {
      this.sha = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubPullRequestHeadImpl)) {
        return false;
      }
      GitHubPullRequestHeadImpl other = (GitHubPullRequestHeadImpl) o;
      if (this.label != null) {
        if (!this.label.equals(other.label)) {
          return false;
        }
      } else {
        if (other.label != null) {
          return false;
        }
      }
      if (this.ref != null) {
        if (!this.ref.equals(other.ref)) {
          return false;
        }
      } else {
        if (other.ref != null) {
          return false;
        }
      }
      if (this.sha != null) {
        if (!this.sha.equals(other.sha)) {
          return false;
        }
      } else {
        if (other.sha != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (label != null ? label.hashCode() : 0);
      hash = hash * 31 + (ref != null ? ref.hashCode() : 0);
      hash = hash * 31 + (sha != null ? sha.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
        return gson.toJsonTree(this);
    }
    @Override
    public void toJson(java.io.Writer w) {
        gson.toJson(this, w);
    }
    @Override
    public String toJson() {
      return gson.toJson(this);
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubPullRequestHeadImpl fromJsonElement(JsonElement jsonElem) {
      return gson.fromJson(jsonElem, GitHubPullRequestHeadImpl.class);
    }
    public static GitHubPullRequestHeadImpl fromJsonString(String jsonString) {
      return gson.fromJson(jsonString, GitHubPullRequestHeadImpl.class);
    }

    public GitHubPullRequestHeadImpl(org.eclipse.che.plugin.github.shared.GitHubPullRequestHead origin) {
      this.label = origin.getLabel();
      this.ref = origin.getRef();
      this.sha = origin.getSha();
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead withLabel(java.lang.String v) {
      this.label = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead withRef(java.lang.String v) {
      this.ref = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestHead withSha(java.lang.String v) {
      this.sha = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class GitHubPullRequestListImpl implements org.eclipse.che.plugin.github.shared.GitHubPullRequestList, JsonSerializable  {

    public static GitHubPullRequestListImpl make() {
        return new GitHubPullRequestListImpl();
    }

    public GitHubPullRequestListImpl() {
    }

    protected java.lang.String firstPage;
    protected java.lang.String lastPage;
    protected java.lang.String nextPage;
    protected java.lang.String prevPage;
    protected java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest> pullRequests;

    @Override
    public java.lang.String getFirstPage() {
      return (java.lang.String)(firstPage);
    }

    public void setFirstPage(java.lang.String v) {
      this.firstPage = v;
    }

    @Override
    public java.lang.String getLastPage() {
      return (java.lang.String)(lastPage);
    }

    public void setLastPage(java.lang.String v) {
      this.lastPage = v;
    }

    @Override
    public java.lang.String getNextPage() {
      return (java.lang.String)(nextPage);
    }

    public void setNextPage(java.lang.String v) {
      this.nextPage = v;
    }

    @Override
    public java.lang.String getPrevPage() {
      return (java.lang.String)(prevPage);
    }

    public void setPrevPage(java.lang.String v) {
      this.prevPage = v;
    }

    @Override
    public java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest> getPullRequests() {
      ensurePullRequests();
      return (java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest>)(new org.eclipse.che.dto.server.JsonArrayImpl(pullRequests));
    }

    public void setPullRequests(java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest> v) {
      this.pullRequests = v;
    }

    public void addPullRequests(org.eclipse.che.plugin.github.shared.GitHubPullRequest v) {
      ensurePullRequests();
      pullRequests.add(v);
    }

    public void clearPullRequests() {
      ensurePullRequests();
      pullRequests.clear();
    }

    protected void ensurePullRequests() {
      if (pullRequests == null) {
        pullRequests = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubPullRequest>();
      }
    }
    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubPullRequestListImpl)) {
        return false;
      }
      GitHubPullRequestListImpl other = (GitHubPullRequestListImpl) o;
      if (this.firstPage != null) {
        if (!this.firstPage.equals(other.firstPage)) {
          return false;
        }
      } else {
        if (other.firstPage != null) {
          return false;
        }
      }
      if (this.lastPage != null) {
        if (!this.lastPage.equals(other.lastPage)) {
          return false;
        }
      } else {
        if (other.lastPage != null) {
          return false;
        }
      }
      if (this.nextPage != null) {
        if (!this.nextPage.equals(other.nextPage)) {
          return false;
        }
      } else {
        if (other.nextPage != null) {
          return false;
        }
      }
      if (this.prevPage != null) {
        if (!this.prevPage.equals(other.prevPage)) {
          return false;
        }
      } else {
        if (other.prevPage != null) {
          return false;
        }
      }
      this.ensurePullRequests();
      other.ensurePullRequests();
      
      if (this.pullRequests != null) {
        if (!this.pullRequests.equals(other.pullRequests)) {
          return false;
        }
      } else {
        if (other.pullRequests != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (firstPage != null ? firstPage.hashCode() : 0);
      hash = hash * 31 + (lastPage != null ? lastPage.hashCode() : 0);
      hash = hash * 31 + (nextPage != null ? nextPage.hashCode() : 0);
      hash = hash * 31 + (prevPage != null ? prevPage.hashCode() : 0);
      ensurePullRequests();
      hash = hash * 31 + (pullRequests != null ? pullRequests.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
        return gson.toJsonTree(this);
    }
    @Override
    public void toJson(java.io.Writer w) {
        gson.toJson(this, w);
    }
    @Override
    public String toJson() {
      return gson.toJson(this);
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubPullRequestListImpl fromJsonElement(JsonElement jsonElem) {
      return gson.fromJson(jsonElem, GitHubPullRequestListImpl.class);
    }
    public static GitHubPullRequestListImpl fromJsonString(String jsonString) {
      return gson.fromJson(jsonString, GitHubPullRequestListImpl.class);
    }

    public GitHubPullRequestListImpl(org.eclipse.che.plugin.github.shared.GitHubPullRequestList origin) {
      this.firstPage = origin.getFirstPage();
      this.lastPage = origin.getLastPage();
      this.nextPage = origin.getNextPage();
      this.prevPage = origin.getPrevPage();
      java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest> pullRequestsIn = origin.getPullRequests();
      if (pullRequestsIn != null) {
        java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest> pullRequestsOut = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubPullRequest>();
        for (org.eclipse.che.plugin.github.shared.GitHubPullRequest pullRequestsIn_ : pullRequestsIn) {
            pullRequestsOut.add(pullRequestsIn_ == null ? null : new GitHubPullRequestImpl(pullRequestsIn_));
        }
        this.pullRequests = pullRequestsOut;
      }
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestList withFirstPage(java.lang.String v) {
      this.firstPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestList withLastPage(java.lang.String v) {
      this.lastPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestList withNextPage(java.lang.String v) {
      this.nextPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestList withPrevPage(java.lang.String v) {
      this.prevPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubPullRequestList withPullRequests(java.util.List<org.eclipse.che.plugin.github.shared.GitHubPullRequest> v) {
      this.pullRequests = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class GitHubRepositoryImpl implements org.eclipse.che.plugin.github.shared.GitHubRepository, JsonSerializable  {

    public static GitHubRepositoryImpl make() {
        return new GitHubRepositoryImpl();
    }

    public GitHubRepositoryImpl() {
    }

    protected java.lang.String language;
    protected org.eclipse.che.plugin.github.shared.GitHubRepository parent;
    protected java.lang.String name;
    protected java.lang.String sshUrl;
    protected java.lang.String gitUrl;
    protected java.lang.String ownerLogin;
    protected java.lang.String updatedAt;
    protected java.lang.String homepage;
    protected java.lang.String description;
    protected boolean fork;
    protected boolean hasIssues;
    protected java.lang.String url;
    protected int openedIssues;
    protected java.lang.String createdAt;
    protected int size;
    protected boolean privateRepo;
    protected int forks;
    protected int watchers;
    protected java.lang.String htmlUrl;
    protected boolean hasDownloads;
    protected boolean hasWiki;
    protected java.lang.String cloneUrl;
    protected java.lang.String pushedAt;

    @Override
    public java.lang.String getLanguage() {
      return (java.lang.String)(language);
    }

    public void setLanguage(java.lang.String v) {
      this.language = v;
    }

    @org.eclipse.che.commons.annotation.Nullable
    @Override
    public org.eclipse.che.plugin.github.shared.GitHubRepository getParent() {
      return (org.eclipse.che.plugin.github.shared.GitHubRepository)(parent);
    }

    public void setParent(org.eclipse.che.plugin.github.shared.GitHubRepository v) {
      this.parent = v;
    }

    @Override
    public java.lang.String getName() {
      return (java.lang.String)(name);
    }

    public void setName(java.lang.String v) {
      this.name = v;
    }

    @Override
    public java.lang.String getSshUrl() {
      return (java.lang.String)(sshUrl);
    }

    public void setSshUrl(java.lang.String v) {
      this.sshUrl = v;
    }

    @Override
    public java.lang.String getGitUrl() {
      return (java.lang.String)(gitUrl);
    }

    public void setGitUrl(java.lang.String v) {
      this.gitUrl = v;
    }

    @Override
    public java.lang.String getOwnerLogin() {
      return (java.lang.String)(ownerLogin);
    }

    public void setOwnerLogin(java.lang.String v) {
      this.ownerLogin = v;
    }

    @Override
    public java.lang.String getUpdatedAt() {
      return (java.lang.String)(updatedAt);
    }

    public void setUpdatedAt(java.lang.String v) {
      this.updatedAt = v;
    }

    @Override
    public java.lang.String getHomepage() {
      return (java.lang.String)(homepage);
    }

    public void setHomepage(java.lang.String v) {
      this.homepage = v;
    }

    @Override
    public java.lang.String getDescription() {
      return (java.lang.String)(description);
    }

    public void setDescription(java.lang.String v) {
      this.description = v;
    }

    @Override
    public boolean isFork() {
      return (boolean)(fork);
    }

    public void setFork(boolean v) {
      this.fork = v;
    }

    @Override
    public boolean isHasIssues() {
      return (boolean)(hasIssues);
    }

    public void setHasIssues(boolean v) {
      this.hasIssues = v;
    }

    @Override
    public java.lang.String getUrl() {
      return (java.lang.String)(url);
    }

    public void setUrl(java.lang.String v) {
      this.url = v;
    }

    @Override
    public int getOpenedIssues() {
      return (int)(openedIssues);
    }

    public void setOpenedIssues(int v) {
      this.openedIssues = v;
    }

    @Override
    public java.lang.String getCreatedAt() {
      return (java.lang.String)(createdAt);
    }

    public void setCreatedAt(java.lang.String v) {
      this.createdAt = v;
    }

    @Override
    public int getSize() {
      return (int)(size);
    }

    public void setSize(int v) {
      this.size = v;
    }

    @Override
    public boolean isPrivateRepo() {
      return (boolean)(privateRepo);
    }

    public void setPrivateRepo(boolean v) {
      this.privateRepo = v;
    }

    @Override
    public int getForks() {
      return (int)(forks);
    }

    public void setForks(int v) {
      this.forks = v;
    }

    @Override
    public int getWatchers() {
      return (int)(watchers);
    }

    public void setWatchers(int v) {
      this.watchers = v;
    }

    @Override
    public java.lang.String getHtmlUrl() {
      return (java.lang.String)(htmlUrl);
    }

    public void setHtmlUrl(java.lang.String v) {
      this.htmlUrl = v;
    }

    @Override
    public boolean isHasDownloads() {
      return (boolean)(hasDownloads);
    }

    public void setHasDownloads(boolean v) {
      this.hasDownloads = v;
    }

    @Override
    public boolean isHasWiki() {
      return (boolean)(hasWiki);
    }

    public void setHasWiki(boolean v) {
      this.hasWiki = v;
    }

    @Override
    public java.lang.String getCloneUrl() {
      return (java.lang.String)(cloneUrl);
    }

    public void setCloneUrl(java.lang.String v) {
      this.cloneUrl = v;
    }

    @Override
    public java.lang.String getPushedAt() {
      return (java.lang.String)(pushedAt);
    }

    public void setPushedAt(java.lang.String v) {
      this.pushedAt = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubRepositoryImpl)) {
        return false;
      }
      GitHubRepositoryImpl other = (GitHubRepositoryImpl) o;
      if (this.language != null) {
        if (!this.language.equals(other.language)) {
          return false;
        }
      } else {
        if (other.language != null) {
          return false;
        }
      }
      if (this.parent != null) {
        if (!this.parent.equals(other.parent)) {
          return false;
        }
      } else {
        if (other.parent != null) {
          return false;
        }
      }
      if (this.name != null) {
        if (!this.name.equals(other.name)) {
          return false;
        }
      } else {
        if (other.name != null) {
          return false;
        }
      }
      if (this.sshUrl != null) {
        if (!this.sshUrl.equals(other.sshUrl)) {
          return false;
        }
      } else {
        if (other.sshUrl != null) {
          return false;
        }
      }
      if (this.gitUrl != null) {
        if (!this.gitUrl.equals(other.gitUrl)) {
          return false;
        }
      } else {
        if (other.gitUrl != null) {
          return false;
        }
      }
      if (this.ownerLogin != null) {
        if (!this.ownerLogin.equals(other.ownerLogin)) {
          return false;
        }
      } else {
        if (other.ownerLogin != null) {
          return false;
        }
      }
      if (this.updatedAt != null) {
        if (!this.updatedAt.equals(other.updatedAt)) {
          return false;
        }
      } else {
        if (other.updatedAt != null) {
          return false;
        }
      }
      if (this.homepage != null) {
        if (!this.homepage.equals(other.homepage)) {
          return false;
        }
      } else {
        if (other.homepage != null) {
          return false;
        }
      }
      if (this.description != null) {
        if (!this.description.equals(other.description)) {
          return false;
        }
      } else {
        if (other.description != null) {
          return false;
        }
      }
      if (this.fork != other.fork) {
        return false;
      }
      if (this.hasIssues != other.hasIssues) {
        return false;
      }
      if (this.url != null) {
        if (!this.url.equals(other.url)) {
          return false;
        }
      } else {
        if (other.url != null) {
          return false;
        }
      }
      if (this.openedIssues != other.openedIssues) {
        return false;
      }
      if (this.createdAt != null) {
        if (!this.createdAt.equals(other.createdAt)) {
          return false;
        }
      } else {
        if (other.createdAt != null) {
          return false;
        }
      }
      if (this.size != other.size) {
        return false;
      }
      if (this.privateRepo != other.privateRepo) {
        return false;
      }
      if (this.forks != other.forks) {
        return false;
      }
      if (this.watchers != other.watchers) {
        return false;
      }
      if (this.htmlUrl != null) {
        if (!this.htmlUrl.equals(other.htmlUrl)) {
          return false;
        }
      } else {
        if (other.htmlUrl != null) {
          return false;
        }
      }
      if (this.hasDownloads != other.hasDownloads) {
        return false;
      }
      if (this.hasWiki != other.hasWiki) {
        return false;
      }
      if (this.cloneUrl != null) {
        if (!this.cloneUrl.equals(other.cloneUrl)) {
          return false;
        }
      } else {
        if (other.cloneUrl != null) {
          return false;
        }
      }
      if (this.pushedAt != null) {
        if (!this.pushedAt.equals(other.pushedAt)) {
          return false;
        }
      } else {
        if (other.pushedAt != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (language != null ? language.hashCode() : 0);
      hash = hash * 31 + (parent != null ? parent.hashCode() : 0);
      hash = hash * 31 + (name != null ? name.hashCode() : 0);
      hash = hash * 31 + (sshUrl != null ? sshUrl.hashCode() : 0);
      hash = hash * 31 + (gitUrl != null ? gitUrl.hashCode() : 0);
      hash = hash * 31 + (ownerLogin != null ? ownerLogin.hashCode() : 0);
      hash = hash * 31 + (updatedAt != null ? updatedAt.hashCode() : 0);
      hash = hash * 31 + (homepage != null ? homepage.hashCode() : 0);
      hash = hash * 31 + (description != null ? description.hashCode() : 0);
      hash = hash * 31 + java.lang.Boolean.valueOf(fork).hashCode();
      hash = hash * 31 + java.lang.Boolean.valueOf(hasIssues).hashCode();
      hash = hash * 31 + (url != null ? url.hashCode() : 0);
      hash = hash * 31 + java.lang.Integer.valueOf(openedIssues).hashCode();
      hash = hash * 31 + (createdAt != null ? createdAt.hashCode() : 0);
      hash = hash * 31 + java.lang.Integer.valueOf(size).hashCode();
      hash = hash * 31 + java.lang.Boolean.valueOf(privateRepo).hashCode();
      hash = hash * 31 + java.lang.Integer.valueOf(forks).hashCode();
      hash = hash * 31 + java.lang.Integer.valueOf(watchers).hashCode();
      hash = hash * 31 + (htmlUrl != null ? htmlUrl.hashCode() : 0);
      hash = hash * 31 + java.lang.Boolean.valueOf(hasDownloads).hashCode();
      hash = hash * 31 + java.lang.Boolean.valueOf(hasWiki).hashCode();
      hash = hash * 31 + (cloneUrl != null ? cloneUrl.hashCode() : 0);
      hash = hash * 31 + (pushedAt != null ? pushedAt.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
        return gson.toJsonTree(this);
    }
    @Override
    public void toJson(java.io.Writer w) {
        gson.toJson(this, w);
    }
    @Override
    public String toJson() {
      return gson.toJson(this);
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubRepositoryImpl fromJsonElement(JsonElement jsonElem) {
      return gson.fromJson(jsonElem, GitHubRepositoryImpl.class);
    }
    public static GitHubRepositoryImpl fromJsonString(String jsonString) {
      return gson.fromJson(jsonString, GitHubRepositoryImpl.class);
    }

    public GitHubRepositoryImpl(org.eclipse.che.plugin.github.shared.GitHubRepository origin) {
      this.language = origin.getLanguage();
      org.eclipse.che.plugin.github.shared.GitHubRepository parentIn = origin.getParent();
      this.parent = parentIn == null ? null : new GitHubRepositoryImpl(parentIn);
      this.name = origin.getName();
      this.sshUrl = origin.getSshUrl();
      this.gitUrl = origin.getGitUrl();
      this.ownerLogin = origin.getOwnerLogin();
      this.updatedAt = origin.getUpdatedAt();
      this.homepage = origin.getHomepage();
      this.description = origin.getDescription();
      this.fork = origin.isFork();
      this.hasIssues = origin.isHasIssues();
      this.url = origin.getUrl();
      this.openedIssues = origin.getOpenedIssues();
      this.createdAt = origin.getCreatedAt();
      this.size = origin.getSize();
      this.privateRepo = origin.isPrivateRepo();
      this.forks = origin.getForks();
      this.watchers = origin.getWatchers();
      this.htmlUrl = origin.getHtmlUrl();
      this.hasDownloads = origin.isHasDownloads();
      this.hasWiki = origin.isHasWiki();
      this.cloneUrl = origin.getCloneUrl();
      this.pushedAt = origin.getPushedAt();
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withLanguage(java.lang.String v) {
      this.language = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withParent(org.eclipse.che.plugin.github.shared.GitHubRepository v) {
      this.parent = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withName(java.lang.String v) {
      this.name = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withSshUrl(java.lang.String v) {
      this.sshUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withGitUrl(java.lang.String v) {
      this.gitUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withOwnerLogin(java.lang.String v) {
      this.ownerLogin = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withUpdatedAt(java.lang.String v) {
      this.updatedAt = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withHomepage(java.lang.String v) {
      this.homepage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withDescription(java.lang.String v) {
      this.description = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withFork(boolean v) {
      this.fork = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withHasIssues(boolean v) {
      this.hasIssues = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withUrl(java.lang.String v) {
      this.url = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withOpenedIssues(int v) {
      this.openedIssues = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withCreatedAt(java.lang.String v) {
      this.createdAt = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withSize(int v) {
      this.size = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withPrivateRepo(boolean v) {
      this.privateRepo = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withForks(int v) {
      this.forks = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withWatchers(int v) {
      this.watchers = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withHtmlUrl(java.lang.String v) {
      this.htmlUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withHasDownloads(boolean v) {
      this.hasDownloads = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withHasWiki(boolean v) {
      this.hasWiki = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withCloneUrl(java.lang.String v) {
      this.cloneUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepository withPushedAt(java.lang.String v) {
      this.pushedAt = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class GitHubRepositoryListImpl implements org.eclipse.che.plugin.github.shared.GitHubRepositoryList, JsonSerializable  {

    public static GitHubRepositoryListImpl make() {
        return new GitHubRepositoryListImpl();
    }

    public GitHubRepositoryListImpl() {
    }

    protected java.lang.String firstPage;
    protected java.lang.String lastPage;
    protected java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository> repositories;
    protected java.lang.String nextPage;
    protected java.lang.String prevPage;

    @Override
    public java.lang.String getFirstPage() {
      return (java.lang.String)(firstPage);
    }

    public void setFirstPage(java.lang.String v) {
      this.firstPage = v;
    }

    @Override
    public java.lang.String getLastPage() {
      return (java.lang.String)(lastPage);
    }

    public void setLastPage(java.lang.String v) {
      this.lastPage = v;
    }

    @Override
    public java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository> getRepositories() {
      ensureRepositories();
      return (java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository>)(new org.eclipse.che.dto.server.JsonArrayImpl(repositories));
    }

    public void setRepositories(java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository> v) {
      this.repositories = v;
    }

    public void addRepositories(org.eclipse.che.plugin.github.shared.GitHubRepository v) {
      ensureRepositories();
      repositories.add(v);
    }

    public void clearRepositories() {
      ensureRepositories();
      repositories.clear();
    }

    protected void ensureRepositories() {
      if (repositories == null) {
        repositories = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubRepository>();
      }
    }
    @Override
    public java.lang.String getNextPage() {
      return (java.lang.String)(nextPage);
    }

    public void setNextPage(java.lang.String v) {
      this.nextPage = v;
    }

    @Override
    public java.lang.String getPrevPage() {
      return (java.lang.String)(prevPage);
    }

    public void setPrevPage(java.lang.String v) {
      this.prevPage = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubRepositoryListImpl)) {
        return false;
      }
      GitHubRepositoryListImpl other = (GitHubRepositoryListImpl) o;
      if (this.firstPage != null) {
        if (!this.firstPage.equals(other.firstPage)) {
          return false;
        }
      } else {
        if (other.firstPage != null) {
          return false;
        }
      }
      if (this.lastPage != null) {
        if (!this.lastPage.equals(other.lastPage)) {
          return false;
        }
      } else {
        if (other.lastPage != null) {
          return false;
        }
      }
      this.ensureRepositories();
      other.ensureRepositories();
      
      if (this.repositories != null) {
        if (!this.repositories.equals(other.repositories)) {
          return false;
        }
      } else {
        if (other.repositories != null) {
          return false;
        }
      }
      if (this.nextPage != null) {
        if (!this.nextPage.equals(other.nextPage)) {
          return false;
        }
      } else {
        if (other.nextPage != null) {
          return false;
        }
      }
      if (this.prevPage != null) {
        if (!this.prevPage.equals(other.prevPage)) {
          return false;
        }
      } else {
        if (other.prevPage != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (firstPage != null ? firstPage.hashCode() : 0);
      hash = hash * 31 + (lastPage != null ? lastPage.hashCode() : 0);
      ensureRepositories();
      hash = hash * 31 + (repositories != null ? repositories.hashCode() : 0);
      hash = hash * 31 + (nextPage != null ? nextPage.hashCode() : 0);
      hash = hash * 31 + (prevPage != null ? prevPage.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
        return gson.toJsonTree(this);
    }
    @Override
    public void toJson(java.io.Writer w) {
        gson.toJson(this, w);
    }
    @Override
    public String toJson() {
      return gson.toJson(this);
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubRepositoryListImpl fromJsonElement(JsonElement jsonElem) {
      return gson.fromJson(jsonElem, GitHubRepositoryListImpl.class);
    }
    public static GitHubRepositoryListImpl fromJsonString(String jsonString) {
      return gson.fromJson(jsonString, GitHubRepositoryListImpl.class);
    }

    public GitHubRepositoryListImpl(org.eclipse.che.plugin.github.shared.GitHubRepositoryList origin) {
      this.firstPage = origin.getFirstPage();
      this.lastPage = origin.getLastPage();
      java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository> repositoriesIn = origin.getRepositories();
      if (repositoriesIn != null) {
        java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository> repositoriesOut = new java.util.ArrayList<org.eclipse.che.plugin.github.shared.GitHubRepository>();
        for (org.eclipse.che.plugin.github.shared.GitHubRepository repositoriesIn_ : repositoriesIn) {
            repositoriesOut.add(repositoriesIn_ == null ? null : new GitHubRepositoryImpl(repositoriesIn_));
        }
        this.repositories = repositoriesOut;
      }
      this.nextPage = origin.getNextPage();
      this.prevPage = origin.getPrevPage();
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepositoryList withFirstPage(java.lang.String v) {
      this.firstPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepositoryList withLastPage(java.lang.String v) {
      this.lastPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepositoryList withRepositories(java.util.List<org.eclipse.che.plugin.github.shared.GitHubRepository> v) {
      this.repositories = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepositoryList withNextPage(java.lang.String v) {
      this.nextPage = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubRepositoryList withPrevPage(java.lang.String v) {
      this.prevPage = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class GitHubUserImpl implements org.eclipse.che.plugin.github.shared.GitHubUser, JsonSerializable  {

    public static GitHubUserImpl make() {
        return new GitHubUserImpl();
    }

    public GitHubUserImpl() {
    }

    protected java.lang.String avatarUrl;
    protected java.lang.String location;
    protected java.lang.String name;
    protected java.lang.String id;
    protected int followers;
    protected int publicGists;
    protected int following;
    protected java.lang.String login;
    protected java.lang.String url;
    protected java.lang.String company;
    protected int publicRepos;
    protected java.lang.String type;
    protected java.lang.String htmlUrl;
    protected java.lang.String email;
    protected java.lang.String bio;
    protected java.lang.String gravatarId;

    @Override
    public java.lang.String getAvatarUrl() {
      return (java.lang.String)(avatarUrl);
    }

    public void setAvatarUrl(java.lang.String v) {
      this.avatarUrl = v;
    }

    @Override
    public java.lang.String getLocation() {
      return (java.lang.String)(location);
    }

    public void setLocation(java.lang.String v) {
      this.location = v;
    }

    @Override
    public java.lang.String getName() {
      return (java.lang.String)(name);
    }

    public void setName(java.lang.String v) {
      this.name = v;
    }

    @Override
    public java.lang.String getId() {
      return (java.lang.String)(id);
    }

    public void setId(java.lang.String v) {
      this.id = v;
    }

    @Override
    public int getFollowers() {
      return (int)(followers);
    }

    public void setFollowers(int v) {
      this.followers = v;
    }

    @Override
    public int getPublicGists() {
      return (int)(publicGists);
    }

    public void setPublicGists(int v) {
      this.publicGists = v;
    }

    @Override
    public int getFollowing() {
      return (int)(following);
    }

    public void setFollowing(int v) {
      this.following = v;
    }

    @Override
    public java.lang.String getLogin() {
      return (java.lang.String)(login);
    }

    public void setLogin(java.lang.String v) {
      this.login = v;
    }

    @Override
    public java.lang.String getUrl() {
      return (java.lang.String)(url);
    }

    public void setUrl(java.lang.String v) {
      this.url = v;
    }

    @Override
    public java.lang.String getCompany() {
      return (java.lang.String)(company);
    }

    public void setCompany(java.lang.String v) {
      this.company = v;
    }

    @Override
    public int getPublicRepos() {
      return (int)(publicRepos);
    }

    public void setPublicRepos(int v) {
      this.publicRepos = v;
    }

    @Override
    public java.lang.String getType() {
      return (java.lang.String)(type);
    }

    public void setType(java.lang.String v) {
      this.type = v;
    }

    @Override
    public java.lang.String getHtmlUrl() {
      return (java.lang.String)(htmlUrl);
    }

    public void setHtmlUrl(java.lang.String v) {
      this.htmlUrl = v;
    }

    @Override
    public java.lang.String getEmail() {
      return (java.lang.String)(email);
    }

    public void setEmail(java.lang.String v) {
      this.email = v;
    }

    @Override
    public java.lang.String getBio() {
      return (java.lang.String)(bio);
    }

    public void setBio(java.lang.String v) {
      this.bio = v;
    }

    @Override
    public java.lang.String getGravatarId() {
      return (java.lang.String)(gravatarId);
    }

    public void setGravatarId(java.lang.String v) {
      this.gravatarId = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof GitHubUserImpl)) {
        return false;
      }
      GitHubUserImpl other = (GitHubUserImpl) o;
      if (this.avatarUrl != null) {
        if (!this.avatarUrl.equals(other.avatarUrl)) {
          return false;
        }
      } else {
        if (other.avatarUrl != null) {
          return false;
        }
      }
      if (this.location != null) {
        if (!this.location.equals(other.location)) {
          return false;
        }
      } else {
        if (other.location != null) {
          return false;
        }
      }
      if (this.name != null) {
        if (!this.name.equals(other.name)) {
          return false;
        }
      } else {
        if (other.name != null) {
          return false;
        }
      }
      if (this.id != null) {
        if (!this.id.equals(other.id)) {
          return false;
        }
      } else {
        if (other.id != null) {
          return false;
        }
      }
      if (this.followers != other.followers) {
        return false;
      }
      if (this.publicGists != other.publicGists) {
        return false;
      }
      if (this.following != other.following) {
        return false;
      }
      if (this.login != null) {
        if (!this.login.equals(other.login)) {
          return false;
        }
      } else {
        if (other.login != null) {
          return false;
        }
      }
      if (this.url != null) {
        if (!this.url.equals(other.url)) {
          return false;
        }
      } else {
        if (other.url != null) {
          return false;
        }
      }
      if (this.company != null) {
        if (!this.company.equals(other.company)) {
          return false;
        }
      } else {
        if (other.company != null) {
          return false;
        }
      }
      if (this.publicRepos != other.publicRepos) {
        return false;
      }
      if (this.type != null) {
        if (!this.type.equals(other.type)) {
          return false;
        }
      } else {
        if (other.type != null) {
          return false;
        }
      }
      if (this.htmlUrl != null) {
        if (!this.htmlUrl.equals(other.htmlUrl)) {
          return false;
        }
      } else {
        if (other.htmlUrl != null) {
          return false;
        }
      }
      if (this.email != null) {
        if (!this.email.equals(other.email)) {
          return false;
        }
      } else {
        if (other.email != null) {
          return false;
        }
      }
      if (this.bio != null) {
        if (!this.bio.equals(other.bio)) {
          return false;
        }
      } else {
        if (other.bio != null) {
          return false;
        }
      }
      if (this.gravatarId != null) {
        if (!this.gravatarId.equals(other.gravatarId)) {
          return false;
        }
      } else {
        if (other.gravatarId != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (avatarUrl != null ? avatarUrl.hashCode() : 0);
      hash = hash * 31 + (location != null ? location.hashCode() : 0);
      hash = hash * 31 + (name != null ? name.hashCode() : 0);
      hash = hash * 31 + (id != null ? id.hashCode() : 0);
      hash = hash * 31 + java.lang.Integer.valueOf(followers).hashCode();
      hash = hash * 31 + java.lang.Integer.valueOf(publicGists).hashCode();
      hash = hash * 31 + java.lang.Integer.valueOf(following).hashCode();
      hash = hash * 31 + (login != null ? login.hashCode() : 0);
      hash = hash * 31 + (url != null ? url.hashCode() : 0);
      hash = hash * 31 + (company != null ? company.hashCode() : 0);
      hash = hash * 31 + java.lang.Integer.valueOf(publicRepos).hashCode();
      hash = hash * 31 + (type != null ? type.hashCode() : 0);
      hash = hash * 31 + (htmlUrl != null ? htmlUrl.hashCode() : 0);
      hash = hash * 31 + (email != null ? email.hashCode() : 0);
      hash = hash * 31 + (bio != null ? bio.hashCode() : 0);
      hash = hash * 31 + (gravatarId != null ? gravatarId.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
        return gson.toJsonTree(this);
    }
    @Override
    public void toJson(java.io.Writer w) {
        gson.toJson(this, w);
    }
    @Override
    public String toJson() {
      return gson.toJson(this);
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static GitHubUserImpl fromJsonElement(JsonElement jsonElem) {
      return gson.fromJson(jsonElem, GitHubUserImpl.class);
    }
    public static GitHubUserImpl fromJsonString(String jsonString) {
      return gson.fromJson(jsonString, GitHubUserImpl.class);
    }

    public GitHubUserImpl(org.eclipse.che.plugin.github.shared.GitHubUser origin) {
      this.avatarUrl = origin.getAvatarUrl();
      this.location = origin.getLocation();
      this.name = origin.getName();
      this.id = origin.getId();
      this.followers = origin.getFollowers();
      this.publicGists = origin.getPublicGists();
      this.following = origin.getFollowing();
      this.login = origin.getLogin();
      this.url = origin.getUrl();
      this.company = origin.getCompany();
      this.publicRepos = origin.getPublicRepos();
      this.type = origin.getType();
      this.htmlUrl = origin.getHtmlUrl();
      this.email = origin.getEmail();
      this.bio = origin.getBio();
      this.gravatarId = origin.getGravatarId();
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withAvatarUrl(java.lang.String v) {
      this.avatarUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withLocation(java.lang.String v) {
      this.location = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withName(java.lang.String v) {
      this.name = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withId(java.lang.String v) {
      this.id = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withFollowers(int v) {
      this.followers = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withPublicGists(int v) {
      this.publicGists = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withFollowing(int v) {
      this.following = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withLogin(java.lang.String v) {
      this.login = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withUrl(java.lang.String v) {
      this.url = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withCompany(java.lang.String v) {
      this.company = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withPublicRepos(int v) {
      this.publicRepos = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withType(java.lang.String v) {
      this.type = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withHtmlUrl(java.lang.String v) {
      this.htmlUrl = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withEmail(java.lang.String v) {
      this.email = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withBio(java.lang.String v) {
      this.bio = v;
      return this;
    }

    public org.eclipse.che.plugin.github.shared.GitHubUser withGravatarId(java.lang.String v) {
      this.gravatarId = v;
      return this;
    }

  }


}