/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.github.server;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.che.api.core.ApiException;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.plugin.github.shared.Collaborators;
import org.eclipse.che.plugin.github.shared.GitHubPullRequest;
import org.eclipse.che.plugin.github.shared.GitHubPullRequestHead;
import org.eclipse.che.plugin.github.shared.GitHubPullRequestList;
import org.eclipse.che.plugin.github.shared.GitHubRepository;
import org.eclipse.che.plugin.github.shared.GitHubRepositoryList;
import org.eclipse.che.plugin.github.shared.GitHubUser;
import org.kohsuke.github.GHCommitPointer;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.PagedIterable;

public class GitHubDTOFactory {
    public GitHubRepositoryList createRepositoriesList(PagedIterable<GHRepository> ghRepositoriesList) throws ApiException, IOException {
        GitHubRepositoryList dtoRepositoriesList = (GitHubRepositoryList)DtoFactory.getInstance().createDto(GitHubRepositoryList.class);
        ArrayList<GitHubRepository> dtoRepositories = new ArrayList<GitHubRepository>();
        for (GHRepository ghRepository : ghRepositoriesList) {
            dtoRepositories.add(this.createRepository(ghRepository));
        }
        dtoRepositoriesList.setRepositories(dtoRepositories);
        return dtoRepositoriesList;
    }

    public GitHubRepositoryList createRepositoriesList(GHRepository ghRepository) throws ApiException, IOException {
        GitHubRepositoryList dtoRepositoriesList = (GitHubRepositoryList)DtoFactory.getInstance().createDto(GitHubRepositoryList.class);
        ArrayList<GitHubRepository> dtoRepositories = new ArrayList<GitHubRepository>();
        dtoRepositories.add(this.createRepository(ghRepository));
        dtoRepositoriesList.setRepositories(dtoRepositories);
        return dtoRepositoriesList;
    }

    public GitHubRepositoryList createRepositoriesList() throws IOException {
        return (GitHubRepositoryList)DtoFactory.getInstance().createDto(GitHubRepositoryList.class);
    }

    public GitHubRepository createRepository(GHRepository ghRepository) throws ApiException, IOException {
        GitHubRepository dtoRepository = (GitHubRepository)DtoFactory.getInstance().createDto(GitHubRepository.class);
        dtoRepository.setName(ghRepository.getName());
        dtoRepository.setUrl(String.valueOf(ghRepository.getUrl()));
        dtoRepository.setHomepage(ghRepository.getHomepage());
        dtoRepository.setForks(ghRepository.getForks());
        dtoRepository.setLanguage(ghRepository.getLanguage());
        dtoRepository.setFork(ghRepository.isFork());
        dtoRepository.setWatchers(ghRepository.getWatchers());
        dtoRepository.setPrivateRepo(ghRepository.isPrivate());
        dtoRepository.setSize(ghRepository.getSize());
        dtoRepository.setDescription(ghRepository.getDescription());
        dtoRepository.setSshUrl(ghRepository.getSshUrl());
        dtoRepository.setHtmlUrl(ghRepository.gitHttpTransportUrl());
        dtoRepository.setUpdatedAt(String.valueOf(ghRepository.getUpdatedAt()));
        dtoRepository.setGitUrl(ghRepository.getGitTransportUrl());
        dtoRepository.setHasWiki(ghRepository.hasWiki());
        dtoRepository.setCloneUrl(String.valueOf(ghRepository.getUrl()));
        dtoRepository.setOpenedIssues(ghRepository.getOpenIssueCount());
        dtoRepository.setCreatedAt(String.valueOf(ghRepository.getCreatedAt()));
        dtoRepository.setPushedAt(String.valueOf(ghRepository.getPushedAt()));
        dtoRepository.setHasDownloads(ghRepository.hasDownloads());
        dtoRepository.setHasIssues(ghRepository.hasIssues());
        dtoRepository.setOwnerLogin(ghRepository.getOwnerName());
        if (ghRepository.isFork() && ghRepository.getParent() != null) {
            dtoRepository.setParent(this.createRepository(ghRepository.getParent()));
        }
        return dtoRepository;
    }

    public GitHubPullRequestList createPullRequestsList(PagedIterable<GHPullRequest> ghPullRequestsList) throws IOException {
        GitHubPullRequestList gitHubPullRequestList = (GitHubPullRequestList)DtoFactory.getInstance().createDto(GitHubPullRequestList.class);
        ArrayList<GitHubPullRequest> dtoPullRequestsList = new ArrayList<GitHubPullRequest>();
        for (GHPullRequest ghPullRequest : ghPullRequestsList) {
            dtoPullRequestsList.add(this.createPullRequest(ghPullRequest));
        }
        gitHubPullRequestList.setPullRequests(dtoPullRequestsList);
        return gitHubPullRequestList;
    }

    public GitHubPullRequestList createPullRequestsList(GHPullRequest ghPullRequest) throws IOException {
        GitHubPullRequestList gitHubPullRequestList = (GitHubPullRequestList)DtoFactory.getInstance().createDto(GitHubPullRequestList.class);
        ArrayList<GitHubPullRequest> dtoPullRequestsList = new ArrayList<GitHubPullRequest>();
        dtoPullRequestsList.add(this.createPullRequest(ghPullRequest));
        gitHubPullRequestList.setPullRequests(dtoPullRequestsList);
        return gitHubPullRequestList;
    }

    public GitHubPullRequest createPullRequest(GHPullRequest ghPullRequest) throws IOException {
        GitHubPullRequest dtoPullRequest = (GitHubPullRequest)DtoFactory.getInstance().createDto(GitHubPullRequest.class);
        dtoPullRequest.setId(String.valueOf(ghPullRequest.getId()));
        dtoPullRequest.setUrl(String.valueOf(ghPullRequest.getUrl()));
        dtoPullRequest.setHtmlUrl(String.valueOf(ghPullRequest.getHtmlUrl()));
        dtoPullRequest.setNumber(String.valueOf(ghPullRequest.getNumber()));
        dtoPullRequest.setState(ghPullRequest.getState().toString());
        dtoPullRequest.setHead(this.createPullRequestHead(ghPullRequest.getHead()));
        dtoPullRequest.setMerged(ghPullRequest.isMerged());
        dtoPullRequest.setBody(ghPullRequest.getBody());
        dtoPullRequest.setTitle(ghPullRequest.getTitle());
        if (ghPullRequest.getMergedBy() != null) {
            dtoPullRequest.setMergedBy(this.createUser((GHPerson)ghPullRequest.getMergedBy()));
        }
        if (ghPullRequest.getMergeable() != null) {
            dtoPullRequest.setMergeable(ghPullRequest.getMergeable().booleanValue());
        }
        return dtoPullRequest;
    }

    public Collaborators createCollaborators(GHPersonSet<? extends GHPerson> ghPersons) throws IOException {
        Collaborators collaborators = (Collaborators)DtoFactory.getInstance().createDto(Collaborators.class);
        for (GHPerson ghPerson : ghPersons) {
            collaborators.getCollaborators().add(this.createUser(ghPerson));
        }
        return collaborators;
    }

    public GitHubUser createUser(GHPerson ghPerson) throws IOException {
        GitHubUser dtoUser = (GitHubUser)DtoFactory.getInstance().createDto(GitHubUser.class);
        dtoUser.setId(String.valueOf(ghPerson.getId()));
        dtoUser.setHtmlUrl(ghPerson.getHtmlUrl().toString());
        dtoUser.setAvatarUrl(ghPerson.getAvatarUrl());
        dtoUser.setBio(ghPerson.getBlog());
        dtoUser.setCompany(ghPerson.getCompany());
        dtoUser.setEmail(ghPerson.getEmail());
        dtoUser.setFollowers(ghPerson.getFollowersCount());
        dtoUser.setFollowing(ghPerson.getFollowingCount());
        dtoUser.setLocation(ghPerson.getLocation());
        dtoUser.setLogin(ghPerson.getLogin());
        dtoUser.setName(ghPerson.getName());
        dtoUser.setPublicGists(ghPerson.getPublicGistCount());
        dtoUser.setPublicRepos(ghPerson.getPublicRepoCount());
        dtoUser.setUrl(String.valueOf(ghPerson.getUrl()));
        dtoUser.setGravatarId(ghPerson.getGravatarId());
        return dtoUser;
    }

    public GitHubPullRequestHead createPullRequestHead(GHCommitPointer ghPullRequestHead) {
        GitHubPullRequestHead dtoPullRequestHead = (GitHubPullRequestHead)DtoFactory.getInstance().createDto(GitHubPullRequestHead.class);
        dtoPullRequestHead.setLabel(ghPullRequestHead.getLabel());
        dtoPullRequestHead.setRef(ghPullRequestHead.getRef());
        dtoPullRequestHead.setSha(ghPullRequestHead.getSha());
        return dtoPullRequestHead;
    }
}

