/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.github.server.dto;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.che.commons.annotation.Nullable;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.dto.server.DtoFactoryVisitor;
import org.eclipse.che.dto.server.DtoProvider;
import org.eclipse.che.dto.server.JsonArrayImpl;
import org.eclipse.che.dto.server.JsonSerializable;
import org.eclipse.che.dto.shared.DTOImpl;
import org.eclipse.che.plugin.github.shared.Collaborators;
import org.eclipse.che.plugin.github.shared.GitHubIssueComment;
import org.eclipse.che.plugin.github.shared.GitHubIssueCommentInput;
import org.eclipse.che.plugin.github.shared.GitHubKey;
import org.eclipse.che.plugin.github.shared.GitHubPullRequest;
import org.eclipse.che.plugin.github.shared.GitHubPullRequestCreationInput;
import org.eclipse.che.plugin.github.shared.GitHubPullRequestHead;
import org.eclipse.che.plugin.github.shared.GitHubPullRequestList;
import org.eclipse.che.plugin.github.shared.GitHubRepository;
import org.eclipse.che.plugin.github.shared.GitHubRepositoryList;
import org.eclipse.che.plugin.github.shared.GitHubUser;

public class DtoServerImpls
implements DtoFactoryVisitor {
    private static final Gson gson = DtoFactory.getInstance().getGson();

    public void accept(DtoFactory dtoFactory) {
        dtoFactory.registerProvider(Collaborators.class, (DtoProvider)new DtoProvider<Collaborators>(){

            public Class<? extends Collaborators> getImplClass() {
                return CollaboratorsImpl.class;
            }

            public Collaborators newInstance() {
                return CollaboratorsImpl.make();
            }

            public Collaborators fromJson(String json) {
                return CollaboratorsImpl.fromJsonString(json);
            }

            public Collaborators fromJson(JsonElement json) {
                return CollaboratorsImpl.fromJsonElement(json);
            }

            public Collaborators clone(Collaborators origin) {
                return new CollaboratorsImpl(origin);
            }
        });
        dtoFactory.registerProvider(GitHubIssueComment.class, (DtoProvider)new DtoProvider<GitHubIssueComment>(){

            public Class<? extends GitHubIssueComment> getImplClass() {
                return GitHubIssueCommentImpl.class;
            }

            public GitHubIssueComment newInstance() {
                return GitHubIssueCommentImpl.make();
            }

            public GitHubIssueComment fromJson(String json) {
                return GitHubIssueCommentImpl.fromJsonString(json);
            }

            public GitHubIssueComment fromJson(JsonElement json) {
                return GitHubIssueCommentImpl.fromJsonElement(json);
            }

            public GitHubIssueComment clone(GitHubIssueComment origin) {
                return new GitHubIssueCommentImpl(origin);
            }
        });
        dtoFactory.registerProvider(GitHubIssueCommentInput.class, (DtoProvider)new DtoProvider<GitHubIssueCommentInput>(){

            public Class<? extends GitHubIssueCommentInput> getImplClass() {
                return GitHubIssueCommentInputImpl.class;
            }

            public GitHubIssueCommentInput newInstance() {
                return GitHubIssueCommentInputImpl.make();
            }

            public GitHubIssueCommentInput fromJson(String json) {
                return GitHubIssueCommentInputImpl.fromJsonString(json);
            }

            public GitHubIssueCommentInput fromJson(JsonElement json) {
                return GitHubIssueCommentInputImpl.fromJsonElement(json);
            }

            public GitHubIssueCommentInput clone(GitHubIssueCommentInput origin) {
                return new GitHubIssueCommentInputImpl(origin);
            }
        });
        dtoFactory.registerProvider(GitHubKey.class, (DtoProvider)new DtoProvider<GitHubKey>(){

            public Class<? extends GitHubKey> getImplClass() {
                return GitHubKeyImpl.class;
            }

            public GitHubKey newInstance() {
                return GitHubKeyImpl.make();
            }

            public GitHubKey fromJson(String json) {
                return GitHubKeyImpl.fromJsonString(json);
            }

            public GitHubKey fromJson(JsonElement json) {
                return GitHubKeyImpl.fromJsonElement(json);
            }

            public GitHubKey clone(GitHubKey origin) {
                return new GitHubKeyImpl(origin);
            }
        });
        dtoFactory.registerProvider(GitHubPullRequest.class, (DtoProvider)new DtoProvider<GitHubPullRequest>(){

            public Class<? extends GitHubPullRequest> getImplClass() {
                return GitHubPullRequestImpl.class;
            }

            public GitHubPullRequest newInstance() {
                return GitHubPullRequestImpl.make();
            }

            public GitHubPullRequest fromJson(String json) {
                return GitHubPullRequestImpl.fromJsonString(json);
            }

            public GitHubPullRequest fromJson(JsonElement json) {
                return GitHubPullRequestImpl.fromJsonElement(json);
            }

            public GitHubPullRequest clone(GitHubPullRequest origin) {
                return new GitHubPullRequestImpl(origin);
            }
        });
        dtoFactory.registerProvider(GitHubPullRequestCreationInput.class, (DtoProvider)new DtoProvider<GitHubPullRequestCreationInput>(){

            public Class<? extends GitHubPullRequestCreationInput> getImplClass() {
                return GitHubPullRequestCreationInputImpl.class;
            }

            public GitHubPullRequestCreationInput newInstance() {
                return GitHubPullRequestCreationInputImpl.make();
            }

            public GitHubPullRequestCreationInput fromJson(String json) {
                return GitHubPullRequestCreationInputImpl.fromJsonString(json);
            }

            public GitHubPullRequestCreationInput fromJson(JsonElement json) {
                return GitHubPullRequestCreationInputImpl.fromJsonElement(json);
            }

            public GitHubPullRequestCreationInput clone(GitHubPullRequestCreationInput origin) {
                return new GitHubPullRequestCreationInputImpl(origin);
            }
        });
        dtoFactory.registerProvider(GitHubPullRequestHead.class, (DtoProvider)new DtoProvider<GitHubPullRequestHead>(){

            public Class<? extends GitHubPullRequestHead> getImplClass() {
                return GitHubPullRequestHeadImpl.class;
            }

            public GitHubPullRequestHead newInstance() {
                return GitHubPullRequestHeadImpl.make();
            }

            public GitHubPullRequestHead fromJson(String json) {
                return GitHubPullRequestHeadImpl.fromJsonString(json);
            }

            public GitHubPullRequestHead fromJson(JsonElement json) {
                return GitHubPullRequestHeadImpl.fromJsonElement(json);
            }

            public GitHubPullRequestHead clone(GitHubPullRequestHead origin) {
                return new GitHubPullRequestHeadImpl(origin);
            }
        });
        dtoFactory.registerProvider(GitHubPullRequestList.class, (DtoProvider)new DtoProvider<GitHubPullRequestList>(){

            public Class<? extends GitHubPullRequestList> getImplClass() {
                return GitHubPullRequestListImpl.class;
            }

            public GitHubPullRequestList newInstance() {
                return GitHubPullRequestListImpl.make();
            }

            public GitHubPullRequestList fromJson(String json) {
                return GitHubPullRequestListImpl.fromJsonString(json);
            }

            public GitHubPullRequestList fromJson(JsonElement json) {
                return GitHubPullRequestListImpl.fromJsonElement(json);
            }

            public GitHubPullRequestList clone(GitHubPullRequestList origin) {
                return new GitHubPullRequestListImpl(origin);
            }
        });
        dtoFactory.registerProvider(GitHubRepository.class, (DtoProvider)new DtoProvider<GitHubRepository>(){

            public Class<? extends GitHubRepository> getImplClass() {
                return GitHubRepositoryImpl.class;
            }

            public GitHubRepository newInstance() {
                return GitHubRepositoryImpl.make();
            }

            public GitHubRepository fromJson(String json) {
                return GitHubRepositoryImpl.fromJsonString(json);
            }

            public GitHubRepository fromJson(JsonElement json) {
                return GitHubRepositoryImpl.fromJsonElement(json);
            }

            public GitHubRepository clone(GitHubRepository origin) {
                return new GitHubRepositoryImpl(origin);
            }
        });
        dtoFactory.registerProvider(GitHubRepositoryList.class, (DtoProvider)new DtoProvider<GitHubRepositoryList>(){

            public Class<? extends GitHubRepositoryList> getImplClass() {
                return GitHubRepositoryListImpl.class;
            }

            public GitHubRepositoryList newInstance() {
                return GitHubRepositoryListImpl.make();
            }

            public GitHubRepositoryList fromJson(String json) {
                return GitHubRepositoryListImpl.fromJsonString(json);
            }

            public GitHubRepositoryList fromJson(JsonElement json) {
                return GitHubRepositoryListImpl.fromJsonElement(json);
            }

            public GitHubRepositoryList clone(GitHubRepositoryList origin) {
                return new GitHubRepositoryListImpl(origin);
            }
        });
        dtoFactory.registerProvider(GitHubUser.class, (DtoProvider)new DtoProvider<GitHubUser>(){

            public Class<? extends GitHubUser> getImplClass() {
                return GitHubUserImpl.class;
            }

            public GitHubUser newInstance() {
                return GitHubUserImpl.make();
            }

            public GitHubUser fromJson(String json) {
                return GitHubUserImpl.fromJsonString(json);
            }

            public GitHubUser fromJson(JsonElement json) {
                return GitHubUserImpl.fromJsonElement(json);
            }

            public GitHubUser clone(GitHubUser origin) {
                return new GitHubUserImpl(origin);
            }
        });
    }

    @DTOImpl(value="server")
    public static class GitHubUserImpl
    implements GitHubUser,
    JsonSerializable {
        protected String avatarUrl;
        protected String location;
        protected String name;
        protected String id;
        protected int followers;
        protected int publicGists;
        protected int following;
        protected String login;
        protected String url;
        protected String company;
        protected int publicRepos;
        protected String type;
        protected String htmlUrl;
        protected String email;
        protected String bio;
        protected String gravatarId;

        public static GitHubUserImpl make() {
            return new GitHubUserImpl();
        }

        public GitHubUserImpl() {
        }

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public void setAvatarUrl(String v) {
            this.avatarUrl = v;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String v) {
            this.location = v;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String v) {
            this.name = v;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String v) {
            this.id = v;
        }

        public int getFollowers() {
            return this.followers;
        }

        public void setFollowers(int v) {
            this.followers = v;
        }

        public int getPublicGists() {
            return this.publicGists;
        }

        public void setPublicGists(int v) {
            this.publicGists = v;
        }

        public int getFollowing() {
            return this.following;
        }

        public void setFollowing(int v) {
            this.following = v;
        }

        public String getLogin() {
            return this.login;
        }

        public void setLogin(String v) {
            this.login = v;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String v) {
            this.url = v;
        }

        public String getCompany() {
            return this.company;
        }

        public void setCompany(String v) {
            this.company = v;
        }

        public int getPublicRepos() {
            return this.publicRepos;
        }

        public void setPublicRepos(int v) {
            this.publicRepos = v;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String v) {
            this.type = v;
        }

        public String getHtmlUrl() {
            return this.htmlUrl;
        }

        public void setHtmlUrl(String v) {
            this.htmlUrl = v;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String v) {
            this.email = v;
        }

        public String getBio() {
            return this.bio;
        }

        public void setBio(String v) {
            this.bio = v;
        }

        public String getGravatarId() {
            return this.gravatarId;
        }

        public void setGravatarId(String v) {
            this.gravatarId = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GitHubUserImpl)) {
                return false;
            }
            GitHubUserImpl other = (GitHubUserImpl)o;
            if (this.avatarUrl != null ? !this.avatarUrl.equals(other.avatarUrl) : other.avatarUrl != null) {
                return false;
            }
            if (this.location != null ? !this.location.equals(other.location) : other.location != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(other.name) : other.name != null) {
                return false;
            }
            if (this.id != null ? !this.id.equals(other.id) : other.id != null) {
                return false;
            }
            if (this.followers != other.followers) {
                return false;
            }
            if (this.publicGists != other.publicGists) {
                return false;
            }
            if (this.following != other.following) {
                return false;
            }
            if (this.login != null ? !this.login.equals(other.login) : other.login != null) {
                return false;
            }
            if (this.url != null ? !this.url.equals(other.url) : other.url != null) {
                return false;
            }
            if (this.company != null ? !this.company.equals(other.company) : other.company != null) {
                return false;
            }
            if (this.publicRepos != other.publicRepos) {
                return false;
            }
            if (this.type != null ? !this.type.equals(other.type) : other.type != null) {
                return false;
            }
            if (this.htmlUrl != null ? !this.htmlUrl.equals(other.htmlUrl) : other.htmlUrl != null) {
                return false;
            }
            if (this.email != null ? !this.email.equals(other.email) : other.email != null) {
                return false;
            }
            if (this.bio != null ? !this.bio.equals(other.bio) : other.bio != null) {
                return false;
            }
            return !(this.gravatarId != null ? !this.gravatarId.equals(other.gravatarId) : other.gravatarId != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.avatarUrl != null ? this.avatarUrl.hashCode() : 0);
            hash = hash * 31 + (this.location != null ? this.location.hashCode() : 0);
            hash = hash * 31 + (this.name != null ? this.name.hashCode() : 0);
            hash = hash * 31 + (this.id != null ? this.id.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.followers).hashCode();
            hash = hash * 31 + Integer.valueOf(this.publicGists).hashCode();
            hash = hash * 31 + Integer.valueOf(this.following).hashCode();
            hash = hash * 31 + (this.login != null ? this.login.hashCode() : 0);
            hash = hash * 31 + (this.url != null ? this.url.hashCode() : 0);
            hash = hash * 31 + (this.company != null ? this.company.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.publicRepos).hashCode();
            hash = hash * 31 + (this.type != null ? this.type.hashCode() : 0);
            hash = hash * 31 + (this.htmlUrl != null ? this.htmlUrl.hashCode() : 0);
            hash = hash * 31 + (this.email != null ? this.email.hashCode() : 0);
            hash = hash * 31 + (this.bio != null ? this.bio.hashCode() : 0);
            hash = hash * 31 + (this.gravatarId != null ? this.gravatarId.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static GitHubUserImpl fromJsonElement(JsonElement jsonElem) {
            return (GitHubUserImpl)gson.fromJson(jsonElem, GitHubUserImpl.class);
        }

        public static GitHubUserImpl fromJsonString(String jsonString) {
            return (GitHubUserImpl)gson.fromJson(jsonString, GitHubUserImpl.class);
        }

        public GitHubUserImpl(GitHubUser origin) {
            this.avatarUrl = origin.getAvatarUrl();
            this.location = origin.getLocation();
            this.name = origin.getName();
            this.id = origin.getId();
            this.followers = origin.getFollowers();
            this.publicGists = origin.getPublicGists();
            this.following = origin.getFollowing();
            this.login = origin.getLogin();
            this.url = origin.getUrl();
            this.company = origin.getCompany();
            this.publicRepos = origin.getPublicRepos();
            this.type = origin.getType();
            this.htmlUrl = origin.getHtmlUrl();
            this.email = origin.getEmail();
            this.bio = origin.getBio();
            this.gravatarId = origin.getGravatarId();
        }

        public GitHubUser withAvatarUrl(String v) {
            this.avatarUrl = v;
            return this;
        }

        public GitHubUser withLocation(String v) {
            this.location = v;
            return this;
        }

        public GitHubUser withName(String v) {
            this.name = v;
            return this;
        }

        public GitHubUser withId(String v) {
            this.id = v;
            return this;
        }

        public GitHubUser withFollowers(int v) {
            this.followers = v;
            return this;
        }

        public GitHubUser withPublicGists(int v) {
            this.publicGists = v;
            return this;
        }

        public GitHubUser withFollowing(int v) {
            this.following = v;
            return this;
        }

        public GitHubUser withLogin(String v) {
            this.login = v;
            return this;
        }

        public GitHubUser withUrl(String v) {
            this.url = v;
            return this;
        }

        public GitHubUser withCompany(String v) {
            this.company = v;
            return this;
        }

        public GitHubUser withPublicRepos(int v) {
            this.publicRepos = v;
            return this;
        }

        public GitHubUser withType(String v) {
            this.type = v;
            return this;
        }

        public GitHubUser withHtmlUrl(String v) {
            this.htmlUrl = v;
            return this;
        }

        public GitHubUser withEmail(String v) {
            this.email = v;
            return this;
        }

        public GitHubUser withBio(String v) {
            this.bio = v;
            return this;
        }

        public GitHubUser withGravatarId(String v) {
            this.gravatarId = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class GitHubRepositoryListImpl
    implements GitHubRepositoryList,
    JsonSerializable {
        protected String firstPage;
        protected String lastPage;
        protected List<GitHubRepository> repositories;
        protected String nextPage;
        protected String prevPage;

        public static GitHubRepositoryListImpl make() {
            return new GitHubRepositoryListImpl();
        }

        public GitHubRepositoryListImpl() {
        }

        public String getFirstPage() {
            return this.firstPage;
        }

        public void setFirstPage(String v) {
            this.firstPage = v;
        }

        public String getLastPage() {
            return this.lastPage;
        }

        public void setLastPage(String v) {
            this.lastPage = v;
        }

        public List<GitHubRepository> getRepositories() {
            this.ensureRepositories();
            return new JsonArrayImpl(this.repositories);
        }

        public void setRepositories(List<GitHubRepository> v) {
            this.repositories = v;
        }

        public void addRepositories(GitHubRepository v) {
            this.ensureRepositories();
            this.repositories.add(v);
        }

        public void clearRepositories() {
            this.ensureRepositories();
            this.repositories.clear();
        }

        protected void ensureRepositories() {
            if (this.repositories == null) {
                this.repositories = new ArrayList<GitHubRepository>();
            }
        }

        public String getNextPage() {
            return this.nextPage;
        }

        public void setNextPage(String v) {
            this.nextPage = v;
        }

        public String getPrevPage() {
            return this.prevPage;
        }

        public void setPrevPage(String v) {
            this.prevPage = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GitHubRepositoryListImpl)) {
                return false;
            }
            GitHubRepositoryListImpl other = (GitHubRepositoryListImpl)o;
            if (this.firstPage != null ? !this.firstPage.equals(other.firstPage) : other.firstPage != null) {
                return false;
            }
            if (this.lastPage != null ? !this.lastPage.equals(other.lastPage) : other.lastPage != null) {
                return false;
            }
            this.ensureRepositories();
            other.ensureRepositories();
            if (this.repositories != null ? !this.repositories.equals(other.repositories) : other.repositories != null) {
                return false;
            }
            if (this.nextPage != null ? !this.nextPage.equals(other.nextPage) : other.nextPage != null) {
                return false;
            }
            return !(this.prevPage != null ? !this.prevPage.equals(other.prevPage) : other.prevPage != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.firstPage != null ? this.firstPage.hashCode() : 0);
            hash = hash * 31 + (this.lastPage != null ? this.lastPage.hashCode() : 0);
            this.ensureRepositories();
            hash = hash * 31 + (this.repositories != null ? this.repositories.hashCode() : 0);
            hash = hash * 31 + (this.nextPage != null ? this.nextPage.hashCode() : 0);
            hash = hash * 31 + (this.prevPage != null ? this.prevPage.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static GitHubRepositoryListImpl fromJsonElement(JsonElement jsonElem) {
            return (GitHubRepositoryListImpl)gson.fromJson(jsonElem, GitHubRepositoryListImpl.class);
        }

        public static GitHubRepositoryListImpl fromJsonString(String jsonString) {
            return (GitHubRepositoryListImpl)gson.fromJson(jsonString, GitHubRepositoryListImpl.class);
        }

        public GitHubRepositoryListImpl(GitHubRepositoryList origin) {
            this.firstPage = origin.getFirstPage();
            this.lastPage = origin.getLastPage();
            List repositoriesIn = origin.getRepositories();
            if (repositoriesIn != null) {
                ArrayList<GitHubRepository> repositoriesOut = new ArrayList<GitHubRepository>();
                for (GitHubRepository repositoriesIn_ : repositoriesIn) {
                    repositoriesOut.add(repositoriesIn_ == null ? null : new GitHubRepositoryImpl(repositoriesIn_));
                }
                this.repositories = repositoriesOut;
            }
            this.nextPage = origin.getNextPage();
            this.prevPage = origin.getPrevPage();
        }

        public GitHubRepositoryList withFirstPage(String v) {
            this.firstPage = v;
            return this;
        }

        public GitHubRepositoryList withLastPage(String v) {
            this.lastPage = v;
            return this;
        }

        public GitHubRepositoryList withRepositories(List<GitHubRepository> v) {
            this.repositories = v;
            return this;
        }

        public GitHubRepositoryList withNextPage(String v) {
            this.nextPage = v;
            return this;
        }

        public GitHubRepositoryList withPrevPage(String v) {
            this.prevPage = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class GitHubRepositoryImpl
    implements GitHubRepository,
    JsonSerializable {
        protected String language;
        protected GitHubRepository parent;
        protected String name;
        protected String sshUrl;
        protected String gitUrl;
        protected String ownerLogin;
        protected String updatedAt;
        protected String homepage;
        protected String description;
        protected boolean fork;
        protected boolean hasIssues;
        protected String url;
        protected int openedIssues;
        protected String createdAt;
        protected int size;
        protected boolean privateRepo;
        protected int forks;
        protected int watchers;
        protected String htmlUrl;
        protected boolean hasDownloads;
        protected boolean hasWiki;
        protected String cloneUrl;
        protected String pushedAt;

        public static GitHubRepositoryImpl make() {
            return new GitHubRepositoryImpl();
        }

        public GitHubRepositoryImpl() {
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String v) {
            this.language = v;
        }

        @Nullable
        public GitHubRepository getParent() {
            return this.parent;
        }

        public void setParent(GitHubRepository v) {
            this.parent = v;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String v) {
            this.name = v;
        }

        public String getSshUrl() {
            return this.sshUrl;
        }

        public void setSshUrl(String v) {
            this.sshUrl = v;
        }

        public String getGitUrl() {
            return this.gitUrl;
        }

        public void setGitUrl(String v) {
            this.gitUrl = v;
        }

        public String getOwnerLogin() {
            return this.ownerLogin;
        }

        public void setOwnerLogin(String v) {
            this.ownerLogin = v;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String v) {
            this.updatedAt = v;
        }

        public String getHomepage() {
            return this.homepage;
        }

        public void setHomepage(String v) {
            this.homepage = v;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String v) {
            this.description = v;
        }

        public boolean isFork() {
            return this.fork;
        }

        public void setFork(boolean v) {
            this.fork = v;
        }

        public boolean isHasIssues() {
            return this.hasIssues;
        }

        public void setHasIssues(boolean v) {
            this.hasIssues = v;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String v) {
            this.url = v;
        }

        public int getOpenedIssues() {
            return this.openedIssues;
        }

        public void setOpenedIssues(int v) {
            this.openedIssues = v;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String v) {
            this.createdAt = v;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int v) {
            this.size = v;
        }

        public boolean isPrivateRepo() {
            return this.privateRepo;
        }

        public void setPrivateRepo(boolean v) {
            this.privateRepo = v;
        }

        public int getForks() {
            return this.forks;
        }

        public void setForks(int v) {
            this.forks = v;
        }

        public int getWatchers() {
            return this.watchers;
        }

        public void setWatchers(int v) {
            this.watchers = v;
        }

        public String getHtmlUrl() {
            return this.htmlUrl;
        }

        public void setHtmlUrl(String v) {
            this.htmlUrl = v;
        }

        public boolean isHasDownloads() {
            return this.hasDownloads;
        }

        public void setHasDownloads(boolean v) {
            this.hasDownloads = v;
        }

        public boolean isHasWiki() {
            return this.hasWiki;
        }

        public void setHasWiki(boolean v) {
            this.hasWiki = v;
        }

        public String getCloneUrl() {
            return this.cloneUrl;
        }

        public void setCloneUrl(String v) {
            this.cloneUrl = v;
        }

        public String getPushedAt() {
            return this.pushedAt;
        }

        public void setPushedAt(String v) {
            this.pushedAt = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GitHubRepositoryImpl)) {
                return false;
            }
            GitHubRepositoryImpl other = (GitHubRepositoryImpl)o;
            if (this.language != null ? !this.language.equals(other.language) : other.language != null) {
                return false;
            }
            if (this.parent != null ? !this.parent.equals(other.parent) : other.parent != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(other.name) : other.name != null) {
                return false;
            }
            if (this.sshUrl != null ? !this.sshUrl.equals(other.sshUrl) : other.sshUrl != null) {
                return false;
            }
            if (this.gitUrl != null ? !this.gitUrl.equals(other.gitUrl) : other.gitUrl != null) {
                return false;
            }
            if (this.ownerLogin != null ? !this.ownerLogin.equals(other.ownerLogin) : other.ownerLogin != null) {
                return false;
            }
            if (this.updatedAt != null ? !this.updatedAt.equals(other.updatedAt) : other.updatedAt != null) {
                return false;
            }
            if (this.homepage != null ? !this.homepage.equals(other.homepage) : other.homepage != null) {
                return false;
            }
            if (this.description != null ? !this.description.equals(other.description) : other.description != null) {
                return false;
            }
            if (this.fork != other.fork) {
                return false;
            }
            if (this.hasIssues != other.hasIssues) {
                return false;
            }
            if (this.url != null ? !this.url.equals(other.url) : other.url != null) {
                return false;
            }
            if (this.openedIssues != other.openedIssues) {
                return false;
            }
            if (this.createdAt != null ? !this.createdAt.equals(other.createdAt) : other.createdAt != null) {
                return false;
            }
            if (this.size != other.size) {
                return false;
            }
            if (this.privateRepo != other.privateRepo) {
                return false;
            }
            if (this.forks != other.forks) {
                return false;
            }
            if (this.watchers != other.watchers) {
                return false;
            }
            if (this.htmlUrl != null ? !this.htmlUrl.equals(other.htmlUrl) : other.htmlUrl != null) {
                return false;
            }
            if (this.hasDownloads != other.hasDownloads) {
                return false;
            }
            if (this.hasWiki != other.hasWiki) {
                return false;
            }
            if (this.cloneUrl != null ? !this.cloneUrl.equals(other.cloneUrl) : other.cloneUrl != null) {
                return false;
            }
            return !(this.pushedAt != null ? !this.pushedAt.equals(other.pushedAt) : other.pushedAt != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.language != null ? this.language.hashCode() : 0);
            hash = hash * 31 + (this.parent != null ? this.parent.hashCode() : 0);
            hash = hash * 31 + (this.name != null ? this.name.hashCode() : 0);
            hash = hash * 31 + (this.sshUrl != null ? this.sshUrl.hashCode() : 0);
            hash = hash * 31 + (this.gitUrl != null ? this.gitUrl.hashCode() : 0);
            hash = hash * 31 + (this.ownerLogin != null ? this.ownerLogin.hashCode() : 0);
            hash = hash * 31 + (this.updatedAt != null ? this.updatedAt.hashCode() : 0);
            hash = hash * 31 + (this.homepage != null ? this.homepage.hashCode() : 0);
            hash = hash * 31 + (this.description != null ? this.description.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.fork).hashCode();
            hash = hash * 31 + Boolean.valueOf(this.hasIssues).hashCode();
            hash = hash * 31 + (this.url != null ? this.url.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.openedIssues).hashCode();
            hash = hash * 31 + (this.createdAt != null ? this.createdAt.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.size).hashCode();
            hash = hash * 31 + Boolean.valueOf(this.privateRepo).hashCode();
            hash = hash * 31 + Integer.valueOf(this.forks).hashCode();
            hash = hash * 31 + Integer.valueOf(this.watchers).hashCode();
            hash = hash * 31 + (this.htmlUrl != null ? this.htmlUrl.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.hasDownloads).hashCode();
            hash = hash * 31 + Boolean.valueOf(this.hasWiki).hashCode();
            hash = hash * 31 + (this.cloneUrl != null ? this.cloneUrl.hashCode() : 0);
            hash = hash * 31 + (this.pushedAt != null ? this.pushedAt.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static GitHubRepositoryImpl fromJsonElement(JsonElement jsonElem) {
            return (GitHubRepositoryImpl)gson.fromJson(jsonElem, GitHubRepositoryImpl.class);
        }

        public static GitHubRepositoryImpl fromJsonString(String jsonString) {
            return (GitHubRepositoryImpl)gson.fromJson(jsonString, GitHubRepositoryImpl.class);
        }

        public GitHubRepositoryImpl(GitHubRepository origin) {
            this.language = origin.getLanguage();
            GitHubRepository parentIn = origin.getParent();
            this.parent = parentIn == null ? null : new GitHubRepositoryImpl(parentIn);
            this.name = origin.getName();
            this.sshUrl = origin.getSshUrl();
            this.gitUrl = origin.getGitUrl();
            this.ownerLogin = origin.getOwnerLogin();
            this.updatedAt = origin.getUpdatedAt();
            this.homepage = origin.getHomepage();
            this.description = origin.getDescription();
            this.fork = origin.isFork();
            this.hasIssues = origin.isHasIssues();
            this.url = origin.getUrl();
            this.openedIssues = origin.getOpenedIssues();
            this.createdAt = origin.getCreatedAt();
            this.size = origin.getSize();
            this.privateRepo = origin.isPrivateRepo();
            this.forks = origin.getForks();
            this.watchers = origin.getWatchers();
            this.htmlUrl = origin.getHtmlUrl();
            this.hasDownloads = origin.isHasDownloads();
            this.hasWiki = origin.isHasWiki();
            this.cloneUrl = origin.getCloneUrl();
            this.pushedAt = origin.getPushedAt();
        }

        public GitHubRepository withLanguage(String v) {
            this.language = v;
            return this;
        }

        public GitHubRepository withParent(GitHubRepository v) {
            this.parent = v;
            return this;
        }

        public GitHubRepository withName(String v) {
            this.name = v;
            return this;
        }

        public GitHubRepository withSshUrl(String v) {
            this.sshUrl = v;
            return this;
        }

        public GitHubRepository withGitUrl(String v) {
            this.gitUrl = v;
            return this;
        }

        public GitHubRepository withOwnerLogin(String v) {
            this.ownerLogin = v;
            return this;
        }

        public GitHubRepository withUpdatedAt(String v) {
            this.updatedAt = v;
            return this;
        }

        public GitHubRepository withHomepage(String v) {
            this.homepage = v;
            return this;
        }

        public GitHubRepository withDescription(String v) {
            this.description = v;
            return this;
        }

        public GitHubRepository withFork(boolean v) {
            this.fork = v;
            return this;
        }

        public GitHubRepository withHasIssues(boolean v) {
            this.hasIssues = v;
            return this;
        }

        public GitHubRepository withUrl(String v) {
            this.url = v;
            return this;
        }

        public GitHubRepository withOpenedIssues(int v) {
            this.openedIssues = v;
            return this;
        }

        public GitHubRepository withCreatedAt(String v) {
            this.createdAt = v;
            return this;
        }

        public GitHubRepository withSize(int v) {
            this.size = v;
            return this;
        }

        public GitHubRepository withPrivateRepo(boolean v) {
            this.privateRepo = v;
            return this;
        }

        public GitHubRepository withForks(int v) {
            this.forks = v;
            return this;
        }

        public GitHubRepository withWatchers(int v) {
            this.watchers = v;
            return this;
        }

        public GitHubRepository withHtmlUrl(String v) {
            this.htmlUrl = v;
            return this;
        }

        public GitHubRepository withHasDownloads(boolean v) {
            this.hasDownloads = v;
            return this;
        }

        public GitHubRepository withHasWiki(boolean v) {
            this.hasWiki = v;
            return this;
        }

        public GitHubRepository withCloneUrl(String v) {
            this.cloneUrl = v;
            return this;
        }

        public GitHubRepository withPushedAt(String v) {
            this.pushedAt = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class GitHubPullRequestListImpl
    implements GitHubPullRequestList,
    JsonSerializable {
        protected String firstPage;
        protected String lastPage;
        protected String nextPage;
        protected String prevPage;
        protected List<GitHubPullRequest> pullRequests;

        public static GitHubPullRequestListImpl make() {
            return new GitHubPullRequestListImpl();
        }

        public GitHubPullRequestListImpl() {
        }

        public String getFirstPage() {
            return this.firstPage;
        }

        public void setFirstPage(String v) {
            this.firstPage = v;
        }

        public String getLastPage() {
            return this.lastPage;
        }

        public void setLastPage(String v) {
            this.lastPage = v;
        }

        public String getNextPage() {
            return this.nextPage;
        }

        public void setNextPage(String v) {
            this.nextPage = v;
        }

        public String getPrevPage() {
            return this.prevPage;
        }

        public void setPrevPage(String v) {
            this.prevPage = v;
        }

        public List<GitHubPullRequest> getPullRequests() {
            this.ensurePullRequests();
            return new JsonArrayImpl(this.pullRequests);
        }

        public void setPullRequests(List<GitHubPullRequest> v) {
            this.pullRequests = v;
        }

        public void addPullRequests(GitHubPullRequest v) {
            this.ensurePullRequests();
            this.pullRequests.add(v);
        }

        public void clearPullRequests() {
            this.ensurePullRequests();
            this.pullRequests.clear();
        }

        protected void ensurePullRequests() {
            if (this.pullRequests == null) {
                this.pullRequests = new ArrayList<GitHubPullRequest>();
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof GitHubPullRequestListImpl)) {
                return false;
            }
            GitHubPullRequestListImpl other = (GitHubPullRequestListImpl)o;
            if (this.firstPage != null ? !this.firstPage.equals(other.firstPage) : other.firstPage != null) {
                return false;
            }
            if (this.lastPage != null ? !this.lastPage.equals(other.lastPage) : other.lastPage != null) {
                return false;
            }
            if (this.nextPage != null ? !this.nextPage.equals(other.nextPage) : other.nextPage != null) {
                return false;
            }
            if (this.prevPage != null ? !this.prevPage.equals(other.prevPage) : other.prevPage != null) {
                return false;
            }
            this.ensurePullRequests();
            other.ensurePullRequests();
            return !(this.pullRequests != null ? !this.pullRequests.equals(other.pullRequests) : other.pullRequests != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.firstPage != null ? this.firstPage.hashCode() : 0);
            hash = hash * 31 + (this.lastPage != null ? this.lastPage.hashCode() : 0);
            hash = hash * 31 + (this.nextPage != null ? this.nextPage.hashCode() : 0);
            hash = hash * 31 + (this.prevPage != null ? this.prevPage.hashCode() : 0);
            this.ensurePullRequests();
            hash = hash * 31 + (this.pullRequests != null ? this.pullRequests.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static GitHubPullRequestListImpl fromJsonElement(JsonElement jsonElem) {
            return (GitHubPullRequestListImpl)gson.fromJson(jsonElem, GitHubPullRequestListImpl.class);
        }

        public static GitHubPullRequestListImpl fromJsonString(String jsonString) {
            return (GitHubPullRequestListImpl)gson.fromJson(jsonString, GitHubPullRequestListImpl.class);
        }

        public GitHubPullRequestListImpl(GitHubPullRequestList origin) {
            this.firstPage = origin.getFirstPage();
            this.lastPage = origin.getLastPage();
            this.nextPage = origin.getNextPage();
            this.prevPage = origin.getPrevPage();
            List pullRequestsIn = origin.getPullRequests();
            if (pullRequestsIn != null) {
                ArrayList<GitHubPullRequest> pullRequestsOut = new ArrayList<GitHubPullRequest>();
                for (GitHubPullRequest pullRequestsIn_ : pullRequestsIn) {
                    pullRequestsOut.add(pullRequestsIn_ == null ? null : new GitHubPullRequestImpl(pullRequestsIn_));
                }
                this.pullRequests = pullRequestsOut;
            }
        }

        public GitHubPullRequestList withFirstPage(String v) {
            this.firstPage = v;
            return this;
        }

        public GitHubPullRequestList withLastPage(String v) {
            this.lastPage = v;
            return this;
        }

        public GitHubPullRequestList withNextPage(String v) {
            this.nextPage = v;
            return this;
        }

        public GitHubPullRequestList withPrevPage(String v) {
            this.prevPage = v;
            return this;
        }

        public GitHubPullRequestList withPullRequests(List<GitHubPullRequest> v) {
            this.pullRequests = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class GitHubPullRequestHeadImpl
    implements GitHubPullRequestHead,
    JsonSerializable {
        protected String label;
        protected String ref;
        protected String sha;

        public static GitHubPullRequestHeadImpl make() {
            return new GitHubPullRequestHeadImpl();
        }

        public GitHubPullRequestHeadImpl() {
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String v) {
            this.label = v;
        }

        public String getRef() {
            return this.ref;
        }

        public void setRef(String v) {
            this.ref = v;
        }

        public String getSha() {
            return this.sha;
        }

        public void setSha(String v) {
            this.sha = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GitHubPullRequestHeadImpl)) {
                return false;
            }
            GitHubPullRequestHeadImpl other = (GitHubPullRequestHeadImpl)o;
            if (this.label != null ? !this.label.equals(other.label) : other.label != null) {
                return false;
            }
            if (this.ref != null ? !this.ref.equals(other.ref) : other.ref != null) {
                return false;
            }
            return !(this.sha != null ? !this.sha.equals(other.sha) : other.sha != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.label != null ? this.label.hashCode() : 0);
            hash = hash * 31 + (this.ref != null ? this.ref.hashCode() : 0);
            hash = hash * 31 + (this.sha != null ? this.sha.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static GitHubPullRequestHeadImpl fromJsonElement(JsonElement jsonElem) {
            return (GitHubPullRequestHeadImpl)gson.fromJson(jsonElem, GitHubPullRequestHeadImpl.class);
        }

        public static GitHubPullRequestHeadImpl fromJsonString(String jsonString) {
            return (GitHubPullRequestHeadImpl)gson.fromJson(jsonString, GitHubPullRequestHeadImpl.class);
        }

        public GitHubPullRequestHeadImpl(GitHubPullRequestHead origin) {
            this.label = origin.getLabel();
            this.ref = origin.getRef();
            this.sha = origin.getSha();
        }

        public GitHubPullRequestHead withLabel(String v) {
            this.label = v;
            return this;
        }

        public GitHubPullRequestHead withRef(String v) {
            this.ref = v;
            return this;
        }

        public GitHubPullRequestHead withSha(String v) {
            this.sha = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class GitHubPullRequestCreationInputImpl
    implements GitHubPullRequestCreationInput,
    JsonSerializable {
        protected String title;
        protected String body;
        protected String head;
        protected String base;

        public static GitHubPullRequestCreationInputImpl make() {
            return new GitHubPullRequestCreationInputImpl();
        }

        public GitHubPullRequestCreationInputImpl() {
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String v) {
            this.title = v;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String v) {
            this.body = v;
        }

        public String getHead() {
            return this.head;
        }

        public void setHead(String v) {
            this.head = v;
        }

        public String getBase() {
            return this.base;
        }

        public void setBase(String v) {
            this.base = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GitHubPullRequestCreationInputImpl)) {
                return false;
            }
            GitHubPullRequestCreationInputImpl other = (GitHubPullRequestCreationInputImpl)o;
            if (this.title != null ? !this.title.equals(other.title) : other.title != null) {
                return false;
            }
            if (this.body != null ? !this.body.equals(other.body) : other.body != null) {
                return false;
            }
            if (this.head != null ? !this.head.equals(other.head) : other.head != null) {
                return false;
            }
            return !(this.base != null ? !this.base.equals(other.base) : other.base != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.title != null ? this.title.hashCode() : 0);
            hash = hash * 31 + (this.body != null ? this.body.hashCode() : 0);
            hash = hash * 31 + (this.head != null ? this.head.hashCode() : 0);
            hash = hash * 31 + (this.base != null ? this.base.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static GitHubPullRequestCreationInputImpl fromJsonElement(JsonElement jsonElem) {
            return (GitHubPullRequestCreationInputImpl)gson.fromJson(jsonElem, GitHubPullRequestCreationInputImpl.class);
        }

        public static GitHubPullRequestCreationInputImpl fromJsonString(String jsonString) {
            return (GitHubPullRequestCreationInputImpl)gson.fromJson(jsonString, GitHubPullRequestCreationInputImpl.class);
        }

        public GitHubPullRequestCreationInputImpl(GitHubPullRequestCreationInput origin) {
            this.title = origin.getTitle();
            this.body = origin.getBody();
            this.head = origin.getHead();
            this.base = origin.getBase();
        }

        public GitHubPullRequestCreationInput withTitle(String v) {
            this.title = v;
            return this;
        }

        public GitHubPullRequestCreationInput withBody(String v) {
            this.body = v;
            return this;
        }

        public GitHubPullRequestCreationInput withHead(String v) {
            this.head = v;
            return this;
        }

        public GitHubPullRequestCreationInput withBase(String v) {
            this.base = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class GitHubPullRequestImpl
    implements GitHubPullRequest,
    JsonSerializable {
        protected String number;
        protected String url;
        protected boolean mergeable;
        protected String title;
        protected String state;
        protected String body;
        protected GitHubPullRequestHead head;
        protected String htmlUrl;
        protected GitHubUser mergedBy;
        protected String id;
        protected boolean merged;

        public static GitHubPullRequestImpl make() {
            return new GitHubPullRequestImpl();
        }

        public GitHubPullRequestImpl() {
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String v) {
            this.number = v;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String v) {
            this.url = v;
        }

        public boolean getMergeable() {
            return this.mergeable;
        }

        public void setMergeable(boolean v) {
            this.mergeable = v;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String v) {
            this.title = v;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String v) {
            this.state = v;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String v) {
            this.body = v;
        }

        public GitHubPullRequestHead getHead() {
            return this.head;
        }

        public void setHead(GitHubPullRequestHead v) {
            this.head = v;
        }

        public String getHtmlUrl() {
            return this.htmlUrl;
        }

        public void setHtmlUrl(String v) {
            this.htmlUrl = v;
        }

        public GitHubUser getMergedBy() {
            return this.mergedBy;
        }

        public void setMergedBy(GitHubUser v) {
            this.mergedBy = v;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String v) {
            this.id = v;
        }

        public boolean getMerged() {
            return this.merged;
        }

        public void setMerged(boolean v) {
            this.merged = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GitHubPullRequestImpl)) {
                return false;
            }
            GitHubPullRequestImpl other = (GitHubPullRequestImpl)o;
            if (this.number != null ? !this.number.equals(other.number) : other.number != null) {
                return false;
            }
            if (this.url != null ? !this.url.equals(other.url) : other.url != null) {
                return false;
            }
            if (this.mergeable != other.mergeable) {
                return false;
            }
            if (this.title != null ? !this.title.equals(other.title) : other.title != null) {
                return false;
            }
            if (this.state != null ? !this.state.equals(other.state) : other.state != null) {
                return false;
            }
            if (this.body != null ? !this.body.equals(other.body) : other.body != null) {
                return false;
            }
            if (this.head != null ? !this.head.equals(other.head) : other.head != null) {
                return false;
            }
            if (this.htmlUrl != null ? !this.htmlUrl.equals(other.htmlUrl) : other.htmlUrl != null) {
                return false;
            }
            if (this.mergedBy != null ? !this.mergedBy.equals(other.mergedBy) : other.mergedBy != null) {
                return false;
            }
            if (this.id != null ? !this.id.equals(other.id) : other.id != null) {
                return false;
            }
            return this.merged == other.merged;
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.number != null ? this.number.hashCode() : 0);
            hash = hash * 31 + (this.url != null ? this.url.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.mergeable).hashCode();
            hash = hash * 31 + (this.title != null ? this.title.hashCode() : 0);
            hash = hash * 31 + (this.state != null ? this.state.hashCode() : 0);
            hash = hash * 31 + (this.body != null ? this.body.hashCode() : 0);
            hash = hash * 31 + (this.head != null ? this.head.hashCode() : 0);
            hash = hash * 31 + (this.htmlUrl != null ? this.htmlUrl.hashCode() : 0);
            hash = hash * 31 + (this.mergedBy != null ? this.mergedBy.hashCode() : 0);
            hash = hash * 31 + (this.id != null ? this.id.hashCode() : 0);
            hash = hash * 31 + Boolean.valueOf(this.merged).hashCode();
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static GitHubPullRequestImpl fromJsonElement(JsonElement jsonElem) {
            return (GitHubPullRequestImpl)gson.fromJson(jsonElem, GitHubPullRequestImpl.class);
        }

        public static GitHubPullRequestImpl fromJsonString(String jsonString) {
            return (GitHubPullRequestImpl)gson.fromJson(jsonString, GitHubPullRequestImpl.class);
        }

        public GitHubPullRequestImpl(GitHubPullRequest origin) {
            this.number = origin.getNumber();
            this.url = origin.getUrl();
            this.mergeable = origin.getMergeable();
            this.title = origin.getTitle();
            this.state = origin.getState();
            this.body = origin.getBody();
            GitHubPullRequestHead headIn = origin.getHead();
            this.head = headIn == null ? null : new GitHubPullRequestHeadImpl(headIn);
            this.htmlUrl = origin.getHtmlUrl();
            GitHubUser mergedByIn = origin.getMergedBy();
            this.mergedBy = mergedByIn == null ? null : new GitHubUserImpl(mergedByIn);
            this.id = origin.getId();
            this.merged = origin.getMerged();
        }

        public GitHubPullRequest withNumber(String v) {
            this.number = v;
            return this;
        }

        public GitHubPullRequest withUrl(String v) {
            this.url = v;
            return this;
        }

        public GitHubPullRequest withMergeable(boolean v) {
            this.mergeable = v;
            return this;
        }

        public GitHubPullRequest withTitle(String v) {
            this.title = v;
            return this;
        }

        public GitHubPullRequest withState(String v) {
            this.state = v;
            return this;
        }

        public GitHubPullRequest withBody(String v) {
            this.body = v;
            return this;
        }

        public GitHubPullRequest withHead(GitHubPullRequestHead v) {
            this.head = v;
            return this;
        }

        public GitHubPullRequest withHtmlUrl(String v) {
            this.htmlUrl = v;
            return this;
        }

        public GitHubPullRequest withMergedBy(GitHubUser v) {
            this.mergedBy = v;
            return this;
        }

        public GitHubPullRequest withId(String v) {
            this.id = v;
            return this;
        }

        public GitHubPullRequest withMerged(boolean v) {
            this.merged = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class GitHubKeyImpl
    implements GitHubKey,
    JsonSerializable {
        protected String url;
        protected String key;
        protected String title;
        protected int id;

        public static GitHubKeyImpl make() {
            return new GitHubKeyImpl();
        }

        public GitHubKeyImpl() {
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String v) {
            this.url = v;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String v) {
            this.key = v;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String v) {
            this.title = v;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int v) {
            this.id = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GitHubKeyImpl)) {
                return false;
            }
            GitHubKeyImpl other = (GitHubKeyImpl)o;
            if (this.url != null ? !this.url.equals(other.url) : other.url != null) {
                return false;
            }
            if (this.key != null ? !this.key.equals(other.key) : other.key != null) {
                return false;
            }
            if (this.title != null ? !this.title.equals(other.title) : other.title != null) {
                return false;
            }
            return this.id == other.id;
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.url != null ? this.url.hashCode() : 0);
            hash = hash * 31 + (this.key != null ? this.key.hashCode() : 0);
            hash = hash * 31 + (this.title != null ? this.title.hashCode() : 0);
            hash = hash * 31 + Integer.valueOf(this.id).hashCode();
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static GitHubKeyImpl fromJsonElement(JsonElement jsonElem) {
            return (GitHubKeyImpl)gson.fromJson(jsonElem, GitHubKeyImpl.class);
        }

        public static GitHubKeyImpl fromJsonString(String jsonString) {
            return (GitHubKeyImpl)gson.fromJson(jsonString, GitHubKeyImpl.class);
        }

        public GitHubKeyImpl(GitHubKey origin) {
            this.url = origin.getUrl();
            this.key = origin.getKey();
            this.title = origin.getTitle();
            this.id = origin.getId();
        }

        public GitHubKey withUrl(String v) {
            this.url = v;
            return this;
        }

        public GitHubKey withKey(String v) {
            this.key = v;
            return this;
        }

        public GitHubKey withTitle(String v) {
            this.title = v;
            return this;
        }

        public GitHubKey withId(int v) {
            this.id = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class GitHubIssueCommentInputImpl
    implements GitHubIssueCommentInput,
    JsonSerializable {
        protected String body;

        public static GitHubIssueCommentInputImpl make() {
            return new GitHubIssueCommentInputImpl();
        }

        public GitHubIssueCommentInputImpl() {
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String v) {
            this.body = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GitHubIssueCommentInputImpl)) {
                return false;
            }
            GitHubIssueCommentInputImpl other = (GitHubIssueCommentInputImpl)o;
            return !(this.body != null ? !this.body.equals(other.body) : other.body != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.body != null ? this.body.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static GitHubIssueCommentInputImpl fromJsonElement(JsonElement jsonElem) {
            return (GitHubIssueCommentInputImpl)gson.fromJson(jsonElem, GitHubIssueCommentInputImpl.class);
        }

        public static GitHubIssueCommentInputImpl fromJsonString(String jsonString) {
            return (GitHubIssueCommentInputImpl)gson.fromJson(jsonString, GitHubIssueCommentInputImpl.class);
        }

        public GitHubIssueCommentInputImpl(GitHubIssueCommentInput origin) {
            this.body = origin.getBody();
        }

        public GitHubIssueCommentInput withBody(String v) {
            this.body = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class GitHubIssueCommentImpl
    implements GitHubIssueComment,
    JsonSerializable {
        protected String url;
        protected String body;
        protected String id;

        public static GitHubIssueCommentImpl make() {
            return new GitHubIssueCommentImpl();
        }

        public GitHubIssueCommentImpl() {
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String v) {
            this.url = v;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String v) {
            this.body = v;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String v) {
            this.id = v;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GitHubIssueCommentImpl)) {
                return false;
            }
            GitHubIssueCommentImpl other = (GitHubIssueCommentImpl)o;
            if (this.url != null ? !this.url.equals(other.url) : other.url != null) {
                return false;
            }
            if (this.body != null ? !this.body.equals(other.body) : other.body != null) {
                return false;
            }
            return !(this.id != null ? !this.id.equals(other.id) : other.id != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.url != null ? this.url.hashCode() : 0);
            hash = hash * 31 + (this.body != null ? this.body.hashCode() : 0);
            hash = hash * 31 + (this.id != null ? this.id.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static GitHubIssueCommentImpl fromJsonElement(JsonElement jsonElem) {
            return (GitHubIssueCommentImpl)gson.fromJson(jsonElem, GitHubIssueCommentImpl.class);
        }

        public static GitHubIssueCommentImpl fromJsonString(String jsonString) {
            return (GitHubIssueCommentImpl)gson.fromJson(jsonString, GitHubIssueCommentImpl.class);
        }

        public GitHubIssueCommentImpl(GitHubIssueComment origin) {
            this.url = origin.getUrl();
            this.body = origin.getBody();
            this.id = origin.getId();
        }

        public GitHubIssueComment withUrl(String v) {
            this.url = v;
            return this;
        }

        public GitHubIssueComment withBody(String v) {
            this.body = v;
            return this;
        }

        public GitHubIssueComment withId(String v) {
            this.id = v;
            return this;
        }
    }

    @DTOImpl(value="server")
    public static class CollaboratorsImpl
    implements Collaborators,
    JsonSerializable {
        protected List<GitHubUser> collaborators;

        public static CollaboratorsImpl make() {
            return new CollaboratorsImpl();
        }

        public CollaboratorsImpl() {
        }

        public List<GitHubUser> getCollaborators() {
            this.ensureCollaborators();
            return new JsonArrayImpl(this.collaborators);
        }

        public void setCollaborators(List<GitHubUser> v) {
            this.collaborators = v;
        }

        public void addCollaborators(GitHubUser v) {
            this.ensureCollaborators();
            this.collaborators.add(v);
        }

        public void clearCollaborators() {
            this.ensureCollaborators();
            this.collaborators.clear();
        }

        protected void ensureCollaborators() {
            if (this.collaborators == null) {
                this.collaborators = new ArrayList<GitHubUser>();
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof CollaboratorsImpl)) {
                return false;
            }
            CollaboratorsImpl other = (CollaboratorsImpl)o;
            this.ensureCollaborators();
            other.ensureCollaborators();
            return !(this.collaborators != null ? !this.collaborators.equals(other.collaborators) : other.collaborators != null);
        }

        public int hashCode() {
            int hash = 7;
            this.ensureCollaborators();
            hash = hash * 31 + (this.collaborators != null ? this.collaborators.hashCode() : 0);
            return hash;
        }

        public JsonElement toJsonElement() {
            return gson.toJsonTree((Object)this);
        }

        public void toJson(Writer w) {
            gson.toJson((Object)this, (Appendable)w);
        }

        public String toJson() {
            return gson.toJson((Object)this);
        }

        public String toString() {
            return this.toJson();
        }

        public static CollaboratorsImpl fromJsonElement(JsonElement jsonElem) {
            return (CollaboratorsImpl)gson.fromJson(jsonElem, CollaboratorsImpl.class);
        }

        public static CollaboratorsImpl fromJsonString(String jsonString) {
            return (CollaboratorsImpl)gson.fromJson(jsonString, CollaboratorsImpl.class);
        }

        public CollaboratorsImpl(Collaborators origin) {
            List collaboratorsIn = origin.getCollaborators();
            if (collaboratorsIn != null) {
                ArrayList<GitHubUser> collaboratorsOut = new ArrayList<GitHubUser>();
                for (GitHubUser collaboratorsIn_ : collaboratorsIn) {
                    collaboratorsOut.add(collaboratorsIn_ == null ? null : new GitHubUserImpl(collaboratorsIn_));
                }
                this.collaborators = collaboratorsOut;
            }
        }

        public Collaborators withCollaborators(List<GitHubUser> v) {
            this.collaborators = v;
            return this;
        }
    }
}

