/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.github.shared;

import com.google.common.base.Strings;

public class GitHubUrlUtils {
    public static String toHttpsIfNeed(String gitUrl) {
        if (Strings.isNullOrEmpty((String)gitUrl)) {
            return gitUrl;
        }
        String gitRepoUrl = gitUrl;
        if (gitUrl.startsWith("git@")) {
            gitRepoUrl = gitUrl.replaceFirst("git@", "https://");
            gitRepoUrl = gitRepoUrl.replaceFirst(".com:", ".com/");
        }
        if (gitRepoUrl.endsWith(".git")) {
            gitRepoUrl = gitRepoUrl.substring(0, gitRepoUrl.lastIndexOf(".git"));
        }
        return gitRepoUrl;
    }

    public static String getBlobUrl(String rootGitRepoUrl, String ref, String path) {
        return GitHubUrlUtils.getBlobUrl(rootGitRepoUrl, ref, path, 0, 0);
    }

    public static String getBlobUrl(String rootGitRepoUrl, String ref, String path, int lineStart, int lineEnd) {
        return rootGitRepoUrl + "/blob/" + ref + "/" + path + (lineStart > 0 ? "#L" + lineStart : "") + (lineEnd > 0 ? "-L" + lineEnd : "");
    }

    public static String getTreeUrl(String rootGitRepoUrl, String ref, String path) {
        return rootGitRepoUrl + "/tree/" + ref + "/" + path;
    }

    public static boolean isGitHubUrl(String rootGitRepoUrl) {
        if (Strings.isNullOrEmpty((String)rootGitRepoUrl)) {
            return false;
        }
        return rootGitRepoUrl.startsWith("git@") || rootGitRepoUrl.startsWith("https://github.com");
    }
}

