/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.jdb.server.model;

import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import org.eclipse.che.api.debug.shared.model.Method;
import org.eclipse.che.api.debug.shared.model.impl.LocationImpl;
import org.eclipse.che.api.debugger.server.exceptions.DebuggerException;
import org.eclipse.che.plugin.jdb.server.model.JdbMethod;
import org.eclipse.che.plugin.jdb.server.utils.JavaDebuggerUtils;

public class JdbLocation
implements org.eclipse.che.api.debug.shared.model.Location {
    private static final JavaDebuggerUtils debuggerUtil = new JavaDebuggerUtils();
    private final Method method;
    private final org.eclipse.che.api.debug.shared.model.Location internal;
    private final StackFrame jdiStackFrame;

    public JdbLocation(StackFrame stackFrame) {
        this(stackFrame, (Method)new JdbMethod(stackFrame));
    }

    public JdbLocation(org.eclipse.che.api.debug.shared.model.Location internal, Method method) {
        this.method = method;
        this.internal = internal;
        this.jdiStackFrame = null;
    }

    public JdbLocation(Location jdiLocation) {
        this.internal = this.getLocation(jdiLocation);
        this.method = null;
        this.jdiStackFrame = null;
    }

    public JdbLocation(StackFrame jdiStackFrame, Method method) {
        this.jdiStackFrame = jdiStackFrame;
        this.internal = this.getLocation(jdiStackFrame.location());
        this.method = method;
    }

    public String getTarget() {
        return this.internal.getTarget();
    }

    public int getLineNumber() {
        return this.internal.getLineNumber();
    }

    public boolean isExternalResource() {
        return this.internal.isExternalResource();
    }

    public int getExternalResourceId() {
        return this.internal.getExternalResourceId();
    }

    public String getResourceProjectPath() {
        return this.internal.getResourceProjectPath();
    }

    public Method getMethod() {
        return this.method;
    }

    public long getThreadId() {
        return this.jdiStackFrame == null ? -1L : this.jdiStackFrame.thread().uniqueID();
    }

    private org.eclipse.che.api.debug.shared.model.Location getLocation(Location jdiLocation) {
        try {
            return debuggerUtil.getLocation(jdiLocation);
        }
        catch (DebuggerException e) {
            return new LocationImpl(jdiLocation.declaringType().name(), jdiLocation.lineNumber());
        }
    }
}

