/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.jdb.server.model;

import com.sun.jdi.LocalVariable;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import org.eclipse.che.api.debug.shared.model.SimpleValue;
import org.eclipse.che.api.debug.shared.model.Variable;
import org.eclipse.che.api.debug.shared.model.VariablePath;
import org.eclipse.che.api.debug.shared.model.impl.VariablePathImpl;
import org.eclipse.che.plugin.jdb.server.model.JdbNullValue;
import org.eclipse.che.plugin.jdb.server.model.JdbType;
import org.eclipse.che.plugin.jdb.server.model.JdbValue;

public class JdbVariable
implements Variable {
    private final LocalVariable jdiVariable;
    private final SimpleValue value;

    public JdbVariable(StackFrame jdiStackFrame, LocalVariable jdiVariable) {
        Value jdiValue = jdiStackFrame.getValue(jdiVariable);
        this.jdiVariable = jdiVariable;
        this.value = jdiValue == null ? new JdbNullValue() : new JdbValue(jdiValue, this.getVariablePath());
    }

    public JdbVariable(SimpleValue value, LocalVariable jdiVariable) {
        this.jdiVariable = jdiVariable;
        this.value = value;
    }

    public String getName() {
        return this.jdiVariable.name();
    }

    public boolean isPrimitive() {
        return JdbType.isPrimitive(this.jdiVariable.signature());
    }

    public SimpleValue getValue() {
        return this.value;
    }

    public String getType() {
        return this.jdiVariable.typeName();
    }

    public VariablePath getVariablePath() {
        return new VariablePathImpl(this.getName());
    }
}

