/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.jdb.server.utils;

import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.eclipse.che.api.debug.shared.model.impl.LocationImpl;
import org.eclipse.che.api.debugger.server.exceptions.DebuggerException;
import org.eclipse.che.commons.annotation.Nullable;
import org.eclipse.che.commons.lang.Pair;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;

public class JavaDebuggerUtils {
    private static final JavaModel MODEL = JavaModelManager.getJavaModelManager().getJavaModel();

    public org.eclipse.che.api.debug.shared.model.Location getLocation(Location location) throws DebuggerException {
        List<IType> types;
        String fqn = location.declaringType().name();
        try {
            Pair<char[][], char[][]> fqnPair = this.prepareFqnToSearch(fqn);
            types = this.findTypeByFqn((char[][])fqnPair.first, (char[][])fqnPair.second, SearchEngine.createWorkspaceScope());
        }
        catch (JavaModelException e) {
            throw new DebuggerException("Can't find class models by fqn: " + fqn, (Exception)((Object)e));
        }
        if (types.isEmpty()) {
            throw new DebuggerException("Type with fully qualified name: " + fqn + " was not found");
        }
        IType type = types.get(0);
        String typeProjectPath = type.getJavaProject().getPath().toOSString();
        if (type.isBinary()) {
            IClassFile classFile = type.getClassFile();
            int libId = classFile.getAncestor(3).hashCode();
            return new LocationImpl(fqn, location.lineNumber(), true, libId, typeProjectPath, null, -1L);
        }
        ICompilationUnit compilationUnit = type.getCompilationUnit();
        typeProjectPath = type.getJavaProject().getPath().toOSString();
        String resourcePath = compilationUnit.getPath().toOSString();
        return new LocationImpl(resourcePath, location.lineNumber(), false, -1, typeProjectPath, null, -1L);
    }

    private Pair<char[][], char[][]> prepareFqnToSearch(@NotNull String fqn) {
        char[][] names;
        char[][] packages;
        String outerClassFqn = this.extractOuterClassFqn(fqn);
        int lastDotIndex = outerClassFqn.trim().lastIndexOf(46);
        if (lastDotIndex == -1) {
            packages = new char[][]{};
            names = new char[][]{outerClassFqn.toCharArray()};
        } else {
            String packageLine = fqn.substring(0, lastDotIndex);
            packages = new char[][]{packageLine.toCharArray()};
            String nameLine = fqn.substring(lastDotIndex + 1, outerClassFqn.length());
            names = new char[][]{nameLine.toCharArray()};
        }
        return new Pair((Object)packages, (Object)names);
    }

    private String extractOuterClassFqn(String fqn) {
        if (fqn.contains("$")) {
            return fqn.substring(0, fqn.indexOf("$"));
        }
        if (fqn.contains("$$")) {
            return fqn.substring(0, fqn.indexOf("$$"));
        }
        return fqn;
    }

    private List<IType> findTypeByFqn(char[][] packages, char[][] names, IJavaSearchScope scope) throws JavaModelException {
        final ArrayList<IType> result = new ArrayList<IType>();
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.searchAllTypeNames(packages, names, scope, new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch typeNameMatch) {
                result.add(typeNameMatch.getType());
            }
        }, 3, (IProgressMonitor)new NullProgressMonitor());
        return result;
    }

    public String findFqnByPosition(org.eclipse.che.api.debug.shared.model.Location location) throws DebuggerException {
        IMember iMember;
        IPath path = Path.fromOSString((String)location.getTarget());
        IJavaProject project = this.getJavaProject(path);
        if (project == null) {
            if (location.getResourceProjectPath() != null) {
                project = MODEL.getJavaProject(location.getResourceProjectPath());
            } else {
                return location.getTarget();
            }
        }
        String fqn = null;
        for (int i = path.segmentCount(); i > 0; --i) {
            try {
                IClasspathEntry classpathEntry = ((JavaProject)project).getClasspathEntryFor(path.removeLastSegments(i));
                if (classpathEntry == null) continue;
                fqn = path.removeFirstSegments(path.segmentCount() - i).removeFileExtension().toString().replace("/", ".");
                break;
            }
            catch (JavaModelException e) {
                return location.getTarget();
            }
        }
        if (fqn == null) {
            return location.getTarget();
        }
        try {
            String source;
            IType outerClass = project.findType(fqn);
            if (outerClass == null) {
                return location.getTarget();
            }
            if (outerClass.isBinary()) {
                IClassFile classFile = outerClass.getClassFile();
                source = classFile.getSource();
            } else {
                ICompilationUnit unit = outerClass.getCompilationUnit();
                source = unit.getSource();
            }
            Document document = new Document(source);
            IRegion region = document.getLineInformation(location.getLineNumber());
            int start = region.getOffset();
            int end = start + region.getLength();
            iMember = this.binSearch(outerClass, start, end);
        }
        catch (JavaModelException e) {
            throw new DebuggerException(String.format("Unable to find source for class with fqn '%s' in the project '%s'", location.getTarget(), project), (Exception)((Object)e));
        }
        catch (BadLocationException e) {
            throw new DebuggerException("Unable to calculate breakpoint location", (Exception)((Object)e));
        }
        if (iMember instanceof IType) {
            return ((IType)iMember).getFullyQualifiedName();
        }
        if (iMember != null) {
            fqn = iMember.getDeclaringType().getFullyQualifiedName();
            while (!(iMember instanceof CompilationUnit)) {
                if (iMember instanceof SourceType && !((SourceType)iMember).isAnonymous() && iMember.getParent() instanceof SourceMethod) {
                    fqn = fqn.replace("$" + iMember.getElementName(), "$1" + iMember.getElementName());
                }
                iMember = iMember.getParent();
            }
            return fqn;
        }
        throw new DebuggerException("Unable to calculate breakpoint location");
    }

    private IJavaProject getJavaProject(IPath path) throws DebuggerException {
        IJavaProject project = null;
        block2: for (int i = 1; i < path.segmentCount(); ++i) {
            IPath projectPath = path.removeLastSegments(i);
            try {
                for (IJavaProject p : MODEL.getJavaProjects()) {
                    if (!p.getPath().equals((Object)projectPath)) continue;
                    project = p;
                    break block2;
                }
                continue;
            }
            catch (JavaModelException e) {
                throw new DebuggerException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return project;
    }

    @Nullable
    private IMember binSearch(IType type, int start, int end) throws JavaModelException {
        IJavaElement je = JavaDebuggerUtils.getElementAt(type, start);
        if (je != null && !je.equals(type)) {
            return JavaDebuggerUtils.asMember(je);
        }
        if (end > start) {
            je = JavaDebuggerUtils.getElementAt(type, end);
            if (je != null && !je.equals(type)) {
                return JavaDebuggerUtils.asMember(je);
            }
            int mid = (end - start) / 2 + start;
            if (mid > start) {
                je = this.binSearch(type, start + 1, mid);
                if (je == null) {
                    je = this.binSearch(type, mid + 1, end - 1);
                }
                return JavaDebuggerUtils.asMember(je);
            }
        }
        return null;
    }

    @Nullable
    private static IMember asMember(IJavaElement element) {
        if (element instanceof IMember) {
            return (IMember)element;
        }
        return null;
    }

    private static IJavaElement getElementAt(IType type, int pos) throws JavaModelException {
        if (type.isBinary()) {
            return type.getClassFile().getElementAt(pos);
        }
        return type.getCompilationUnit().getElementAt(pos);
    }
}

