/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.jdb.server;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMCannotBeModifiedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.StepRequest;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.che.api.debug.shared.dto.BreakpointDto;
import org.eclipse.che.api.debug.shared.dto.action.ResumeActionDto;
import org.eclipse.che.api.debug.shared.model.Breakpoint;
import org.eclipse.che.api.debug.shared.model.BreakpointConfiguration;
import org.eclipse.che.api.debug.shared.model.DebuggerInfo;
import org.eclipse.che.api.debug.shared.model.Field;
import org.eclipse.che.api.debug.shared.model.Location;
import org.eclipse.che.api.debug.shared.model.SimpleValue;
import org.eclipse.che.api.debug.shared.model.StackFrameDump;
import org.eclipse.che.api.debug.shared.model.SuspendPolicy;
import org.eclipse.che.api.debug.shared.model.ThreadState;
import org.eclipse.che.api.debug.shared.model.ThreadStatus;
import org.eclipse.che.api.debug.shared.model.Variable;
import org.eclipse.che.api.debug.shared.model.VariablePath;
import org.eclipse.che.api.debug.shared.model.action.ResumeAction;
import org.eclipse.che.api.debug.shared.model.action.StartAction;
import org.eclipse.che.api.debug.shared.model.action.StepIntoAction;
import org.eclipse.che.api.debug.shared.model.action.StepOutAction;
import org.eclipse.che.api.debug.shared.model.action.StepOverAction;
import org.eclipse.che.api.debug.shared.model.event.DebuggerEvent;
import org.eclipse.che.api.debug.shared.model.impl.BreakpointImpl;
import org.eclipse.che.api.debug.shared.model.impl.DebuggerInfoImpl;
import org.eclipse.che.api.debug.shared.model.impl.ThreadStateImpl;
import org.eclipse.che.api.debug.shared.model.impl.event.BreakpointActivatedEventImpl;
import org.eclipse.che.api.debug.shared.model.impl.event.DisconnectEventImpl;
import org.eclipse.che.api.debug.shared.model.impl.event.SuspendEventImpl;
import org.eclipse.che.api.debugger.server.Debugger;
import org.eclipse.che.api.debugger.server.DtoConverter;
import org.eclipse.che.api.debugger.server.exceptions.DebuggerException;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.plugin.jdb.server.BreakPointComparator;
import org.eclipse.che.plugin.jdb.server.EventsCollector;
import org.eclipse.che.plugin.jdb.server.EventsHandler;
import org.eclipse.che.plugin.jdb.server.expression.Evaluator;
import org.eclipse.che.plugin.jdb.server.expression.ExpressionException;
import org.eclipse.che.plugin.jdb.server.expression.ExpressionParser;
import org.eclipse.che.plugin.jdb.server.model.JdbLocation;
import org.eclipse.che.plugin.jdb.server.model.JdbStackFrame;
import org.eclipse.che.plugin.jdb.server.utils.JavaDebuggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDebugger
implements EventsHandler,
Debugger {
    private static final Logger LOG = LoggerFactory.getLogger(JavaDebugger.class);
    private static final JavaDebuggerUtils debuggerUtil = new JavaDebuggerUtils();
    private final String host;
    private final int port;
    private final Debugger.DebuggerCallback debuggerCallback;
    private final ConcurrentMap<String, List<Breakpoint>> deferredBreakpoints = new ConcurrentHashMap<String, List<Breakpoint>>();
    private final ConcurrentMap<String, ClassPrepareRequest> classPrepareRequests = new ConcurrentHashMap<String, ClassPrepareRequest>();
    private VirtualMachine vm;
    private EventsCollector eventsCollector;
    private ThreadReference thread;
    private JdbStackFrame stackFrame;
    private Lock lock = new ReentrantLock();
    private static final Comparator<Breakpoint> BREAKPOINT_COMPARATOR = new BreakPointComparator();

    JavaDebugger(String host, int port, Debugger.DebuggerCallback debuggerCallback) throws DebuggerException {
        this.host = host;
        this.port = port;
        this.debuggerCallback = debuggerCallback;
        this.connect();
    }

    private void connect() throws DebuggerException {
        String connectorName = "com.sun.jdi.SocketAttach";
        AttachingConnector connector = this.connector("com.sun.jdi.SocketAttach");
        if (connector == null) {
            throw new DebuggerException(String.format("Unable connect to target Java VM. Requested connector '%s' not found. ", "com.sun.jdi.SocketAttach"));
        }
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        arguments.get("hostname").setValue(this.host);
        ((Connector.IntegerArgument)arguments.get("port")).setValue(this.port);
        int attempt = 0;
        while (true) {
            try {
                Thread.sleep(2000L);
                this.vm = connector.attach(arguments);
                this.vm.suspend();
            }
            catch (IllegalConnectorArgumentsException | UnknownHostException e) {
                throw new DebuggerException(e.getMessage(), e);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                if (++attempt > 10) {
                    throw new DebuggerException(e.getMessage(), (Exception)e);
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        this.eventsCollector = new EventsCollector(this.vm.eventQueue(), this);
        LOG.debug("Connect {}:{}", (Object)this.host, (Object)this.port);
    }

    private AttachingConnector connector(String connectorName) {
        for (AttachingConnector c : Bootstrap.virtualMachineManager().attachingConnectors()) {
            if (!connectorName.equals(c.name())) continue;
            return c;
        }
        return null;
    }

    public DebuggerInfo getInfo() throws DebuggerException {
        return new DebuggerInfoImpl(this.host, this.port, this.vm.name(), this.vm.version(), 0, null);
    }

    public void start(StartAction action) throws DebuggerException {
        for (Breakpoint b : action.getBreakpoints()) {
            try {
                this.addBreakpoint(b);
            }
            catch (DebuggerException debuggerException) {}
        }
        this.vm.resume();
    }

    public void disconnect() throws DebuggerException {
        this.vm.dispose();
        LOG.debug("Close connection to {}:{}", (Object)this.host, (Object)this.port);
    }

    public void addBreakpoint(Breakpoint breakpoint) throws DebuggerException {
        List<com.sun.jdi.Location> locations;
        String className = debuggerUtil.findFqnByPosition(breakpoint.getLocation());
        int lineNumber = breakpoint.getLocation().getLineNumber();
        List<ReferenceType> classes = this.vm.classesByName(className);
        if (classes.isEmpty()) {
            this.deferBreakpoint(className, breakpoint);
            return;
        }
        ReferenceType clazz = classes.get(0);
        try {
            locations = clazz.locationsOfLine(lineNumber);
        }
        catch (AbsentInformationException | ClassNotPreparedException e) {
            throw new DebuggerException(e.getMessage(), e);
        }
        if (locations.isEmpty()) {
            throw new DebuggerException("Line " + lineNumber + " not found in class " + className);
        }
        com.sun.jdi.Location location = locations.get(0);
        if (location.method() == null) {
            throw new DebuggerException("Invalid line " + lineNumber + " in class " + className);
        }
        EventRequestManager requestManager = this.getEventManager();
        for (BreakpointRequest breakpointRequest : requestManager.breakpointRequests()) {
            if (!location.equals(breakpointRequest.location())) continue;
            LOG.debug("Breakpoint at {} already set", (Object)location);
            return;
        }
        try {
            BreakpointRequest request = requestManager.createBreakpointRequest(location);
            BreakpointConfiguration conf = breakpoint.getBreakpointConfiguration();
            if (conf != null && conf.getSuspendPolicy() != null) {
                request.setSuspendPolicy(this.toSuspendEventRequest(conf.getSuspendPolicy()));
            } else {
                request.setSuspendPolicy(2);
            }
            if (conf != null && conf.isConditionEnabled() && conf.getCondition() != null && !conf.getCondition().isEmpty()) {
                ExpressionParser parser = ExpressionParser.newInstance((String)conf.getCondition());
                request.putProperty("org.eclipse.che.ide.java.debug.condition.expression.parser", parser);
            }
            if (conf != null && conf.isHitCountEnabled() && conf.getHitCount() > 0) {
                request.addCountFilter(conf.getHitCount());
            }
            request.setEnabled(true);
        }
        catch (NativeMethodException | InvalidRequestStateException | IllegalThreadStateException e) {
            throw new DebuggerException(e.getMessage(), (Exception)e);
        }
        this.debuggerCallback.onEvent((DebuggerEvent)new BreakpointActivatedEventImpl((Breakpoint)new BreakpointImpl(breakpoint.getLocation())));
        LOG.debug("Add breakpoint: {}", (Object)location);
    }

    private void deferBreakpoint(String className, Breakpoint breakpoint) throws DebuggerException {
        ArrayList<Breakpoint> newList = new ArrayList<Breakpoint>();
        ArrayList<Breakpoint> list = this.deferredBreakpoints.putIfAbsent(className, newList);
        if (list == null) {
            list = newList;
        }
        list.add(breakpoint);
        if (!this.classPrepareRequests.containsKey(className)) {
            ClassPrepareRequest request = this.getEventManager().createClassPrepareRequest();
            request.addClassFilter(className);
            request.enable();
            this.classPrepareRequests.put(className, request);
        }
        LOG.debug("Deferred breakpoint: {}", (Object)breakpoint.getLocation().toString());
    }

    public List<Breakpoint> getAllBreakpoints() throws DebuggerException {
        List<BreakpointRequest> breakpointRequests;
        try {
            breakpointRequests = this.getEventManager().breakpointRequests();
        }
        catch (DebuggerException e) {
            Throwable cause = e.getCause();
            if (cause instanceof VMCannotBeModifiedException) {
                return Collections.emptyList();
            }
            throw e;
        }
        ArrayList<Breakpoint> breakPoints = new ArrayList<Breakpoint>(breakpointRequests.size());
        for (BreakpointRequest breakpointRequest : breakpointRequests) {
            com.sun.jdi.Location location = breakpointRequest.location();
            breakPoints.add((Breakpoint)((BreakpointDto)DtoFactory.newDto(BreakpointDto.class)).withEnabled(true).withLocation(DtoConverter.asDto((Location)new JdbLocation(location))));
        }
        breakPoints.sort(BREAKPOINT_COMPARATOR);
        return breakPoints;
    }

    public void deleteBreakpoint(Location location) throws DebuggerException {
        String className = debuggerUtil.findFqnByPosition(location);
        int lineNumber = location.getLineNumber();
        EventRequestManager requestManager = this.getEventManager();
        ArrayList<BreakpointRequest> snapshot = new ArrayList<BreakpointRequest>(requestManager.breakpointRequests());
        for (BreakpointRequest breakpointRequest : snapshot) {
            com.sun.jdi.Location jdiLocation = breakpointRequest.location();
            if (!jdiLocation.declaringType().name().equals(className) || jdiLocation.lineNumber() != lineNumber) continue;
            requestManager.deleteEventRequest(breakpointRequest);
            LOG.debug("Delete breakpoint: {}", (Object)location);
        }
        List defferedByClass = (List)this.deferredBreakpoints.get(className);
        if (defferedByClass != null) {
            defferedByClass.removeIf(breakpoint -> {
                Location l = breakpoint.getLocation();
                return l.getLineNumber() == location.getLineNumber() && l.getTarget().equals(location.getTarget());
            });
        }
    }

    public void deleteAllBreakpoints() throws DebuggerException {
        this.getEventManager().deleteAllBreakpoints();
        this.deferredBreakpoints.clear();
    }

    public void resume(ResumeAction action) throws DebuggerException {
        this.lock.lock();
        try {
            this.invalidateCurrentThread();
            this.vm.resume();
            LOG.debug("Resume VM");
        }
        catch (VMCannotBeModifiedException e) {
            throw new DebuggerException(e.getMessage(), (Exception)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public StackFrameDump dumpStackFrame() throws DebuggerException {
        this.lock.lock();
        try {
            JdbStackFrame jdbStackFrame = this.getCurrentFrame();
            return jdbStackFrame;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackFrameDump getStackFrameDump(long threadId, int frameIndex) throws DebuggerException {
        this.lock.lock();
        try {
            JdbStackFrame jdbStackFrame = new JdbStackFrame(this.getJdiStackFrame(threadId, frameIndex));
            return jdbStackFrame;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<ThreadState> getThreadDump() throws DebuggerException {
        LinkedList<ThreadState> threadStates = new LinkedList<ThreadState>();
        for (ThreadReference t : this.vm.allThreads()) {
            LinkedList<JdbStackFrame> frames = new LinkedList<JdbStackFrame>();
            try {
                for (StackFrame f : t.frames()) {
                    frames.add(new JdbStackFrame(f, Collections.emptyList(), Collections.emptyList()));
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                // empty catch block
            }
            threadStates.add((ThreadState)new ThreadStateImpl(t.uniqueID(), t.name(), t.threadGroup().name(), this.toThreadStatus(t.status()), t.isSuspended(), frames));
        }
        return threadStates;
    }

    public SimpleValue getValue(VariablePath variablePath) throws DebuggerException {
        this.lock.lock();
        try {
            SimpleValue simpleValue = this.getValue(variablePath, this.getCurrentThread().uniqueID(), 0);
            return simpleValue;
        }
        finally {
            this.lock.unlock();
        }
    }

    public SimpleValue getValue(VariablePath variablePath, long threadId, int frameIndex) throws DebuggerException {
        int offset;
        Optional<Field> targetVar;
        JdbStackFrame jdbStackFrame = new JdbStackFrame(this.getJdiStackFrame(threadId, frameIndex));
        List path = variablePath.getPath();
        if ("this".equals(path.get(0)) || "static".equals(path.get(0))) {
            targetVar = jdbStackFrame.getFields().stream().filter(f -> f.getName().equals(path.get(1))).findAny();
            offset = 2;
        } else {
            targetVar = jdbStackFrame.getVariables().stream().filter(f -> f.getName().equals(path.get(0))).findAny();
            offset = 1;
        }
        int i = offset;
        while (targetVar.isPresent() && i < path.size()) {
            int index = i++;
            targetVar = ((Variable)targetVar.get()).getValue().getVariables().stream().filter(v -> v.getName().equals(path.get(index))).findAny();
        }
        if (!targetVar.isPresent()) {
            return null;
        }
        return ((Variable)targetVar.get()).getValue();
    }

    public void setValue(Variable variable) throws DebuggerException {
        this.setValue(variable, this.getCurrentThread().uniqueID(), 0);
    }

    public void setValue(Variable variable, long threadId, int frameIndex) throws DebuggerException {
        StringBuilder expression = new StringBuilder();
        for (String s : variable.getVariablePath().getPath()) {
            if ("static".equals(s)) continue;
            if (expression.length() > 0 && !s.startsWith("[")) {
                expression.append('.');
            }
            expression.append(s);
        }
        expression.append('=');
        expression.append(variable.getValue().getString());
        this.evaluate(expression.toString(), threadId, frameIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvents(EventSet eventSet) throws DebuggerException {
        boolean resume = true;
        try {
            for (Event event : eventSet) {
                LOG.debug("New event: {}", (Object)event);
                if (event instanceof BreakpointEvent) {
                    this.lock.lock();
                    try {
                        resume = this.processBreakPointEvent((BreakpointEvent)event);
                        continue;
                    }
                    finally {
                        this.lock.unlock();
                        continue;
                    }
                }
                if (event instanceof StepEvent) {
                    this.lock.lock();
                    try {
                        resume = this.processStepEvent((StepEvent)event);
                        continue;
                    }
                    finally {
                        this.lock.unlock();
                        continue;
                    }
                }
                if (event instanceof VMDisconnectEvent) {
                    resume = this.processDisconnectEvent();
                    continue;
                }
                if (!(event instanceof ClassPrepareEvent)) continue;
                resume = this.processClassPrepareEvent((ClassPrepareEvent)event);
            }
        }
        finally {
            if (resume) {
                eventSet.resume();
            }
        }
    }

    private boolean processBreakPointEvent(BreakpointEvent event) throws DebuggerException {
        Value result;
        this.setCurrentThread(event.thread());
        ExpressionParser parser = (ExpressionParser)event.request().getProperty("org.eclipse.che.ide.java.debug.condition.expression.parser");
        boolean hitBreakpoint = parser != null ? (result = this.evaluate(parser, event.thread().uniqueID(), 0)) instanceof BooleanValue && ((BooleanValue)result).value() : true;
        if (hitBreakpoint) {
            try {
                JdbLocation location = new JdbLocation(event.thread().frame(0));
                SuspendPolicy suspendPolicy = this.toSuspendPolicy(event.request().suspendPolicy());
                this.debuggerCallback.onEvent((DebuggerEvent)new SuspendEventImpl((Location)location, suspendPolicy));
            }
            catch (IncompatibleThreadStateException e) {
                return true;
            }
        }
        return !hitBreakpoint;
    }

    private boolean processStepEvent(StepEvent event) throws DebuggerException {
        event.request().suspendPolicy();
        this.setCurrentThread(event.thread());
        try {
            StackFrame jdiFrame = event.thread().frame(0);
            JdbLocation jdbLocation = new JdbLocation(jdiFrame);
            SuspendPolicy suspendPolicy = this.toSuspendPolicy(event.request().suspendPolicy());
            this.debuggerCallback.onEvent((DebuggerEvent)new SuspendEventImpl((Location)jdbLocation, suspendPolicy));
            return false;
        }
        catch (IncompatibleThreadStateException e) {
            this.invalidateCurrentThread();
            return true;
        }
    }

    private boolean processDisconnectEvent() {
        this.debuggerCallback.onEvent((DebuggerEvent)new DisconnectEventImpl());
        this.eventsCollector.stop();
        return true;
    }

    private boolean processClassPrepareEvent(ClassPrepareEvent event) throws DebuggerException {
        this.setCurrentThread(event.thread());
        String className = event.referenceType().name();
        List breakpointsToAdd = (List)this.deferredBreakpoints.get(className);
        if (breakpointsToAdd != null) {
            for (Breakpoint b : breakpointsToAdd) {
                this.addBreakpoint(b);
            }
            this.deferredBreakpoints.remove(className);
            ClassPrepareRequest request = (ClassPrepareRequest)this.classPrepareRequests.remove(className);
            if (request != null) {
                this.getEventManager().deleteEventRequest(request);
            }
        }
        return true;
    }

    public void stepOver(StepOverAction action) throws DebuggerException {
        this.doStep(2, action.getSuspendPolicy());
    }

    public void stepInto(StepIntoAction action) throws DebuggerException {
        this.doStep(1, action.getSuspendPolicy());
    }

    public void stepOut(StepOutAction action) throws DebuggerException {
        this.doStep(3, action.getSuspendPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStep(int depth, SuspendPolicy suspendPolicy) throws DebuggerException {
        this.lock.lock();
        try {
            this.clearSteps();
            StepRequest request = this.getEventManager().createStepRequest(this.getCurrentThread(), -2, depth);
            request.addCountFilter(1);
            request.setSuspendPolicy(this.toSuspendEventRequest(suspendPolicy));
            request.enable();
            this.resume((ResumeAction)DtoFactory.newDto(ResumeActionDto.class));
        }
        finally {
            this.lock.unlock();
        }
    }

    private void clearSteps() throws DebuggerException {
        ArrayList<StepRequest> snapshot = new ArrayList<StepRequest>(this.getEventManager().stepRequests());
        for (StepRequest stepRequest : snapshot) {
            if (!stepRequest.thread().equals(this.getCurrentThread())) continue;
            this.getEventManager().deleteEventRequest(stepRequest);
        }
    }

    public String evaluate(String expression) throws DebuggerException {
        this.lock.lock();
        try {
            String string = this.evaluate(expression, this.getCurrentThread().uniqueID(), 0);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String evaluate(String expression, long threadId, int frameIndex) throws DebuggerException {
        Value result = this.evaluate(ExpressionParser.newInstance((String)expression), threadId, frameIndex);
        return result == null ? "null" : result.toString();
    }

    public Location getStackFrameLocation(long threadId, int frameIndex) throws DebuggerException {
        StackFrame jdiStackFrame = this.getJdiStackFrame(threadId, frameIndex);
        return new JdbLocation(jdiStackFrame);
    }

    private Value evaluate(ExpressionParser parser, long threadId, int frameIndex) throws DebuggerException {
        StackFrame jdiStackFrame = this.getJdiStackFrame(threadId, frameIndex);
        try {
            return parser.evaluate(new Evaluator(this.vm, jdiStackFrame));
        }
        catch (ExpressionException e) {
            throw new DebuggerException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private StackFrame getJdiStackFrame(long threadId, int frameIndex) throws DebuggerException {
        try {
            for (ThreadReference t : this.vm.allThreads()) {
                if (t.uniqueID() != threadId) continue;
                return t.frame(frameIndex);
            }
            throw new DebuggerException(String.format("Frame '%d' in thread '%d' not found.", frameIndex, threadId));
        }
        catch (IncompatibleThreadStateException e) {
            throw new DebuggerException("Thread is not suspended", (Exception)e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DebuggerException(String.format("Frame '%d' in thread '%d' not found.", frameIndex, threadId));
        }
    }

    private ThreadReference getCurrentThread() throws DebuggerException {
        if (this.thread == null) {
            throw new DebuggerException("Target Java VM is not suspended. ");
        }
        return this.thread;
    }

    private JdbStackFrame getCurrentFrame() throws DebuggerException {
        if (this.stackFrame != null) {
            return this.stackFrame;
        }
        try {
            this.stackFrame = new JdbStackFrame(this.getCurrentThread().frame(0));
        }
        catch (IncompatibleThreadStateException e) {
            throw new DebuggerException("Thread is not suspended. ", (Exception)e);
        }
        return this.stackFrame;
    }

    private void setCurrentThread(ThreadReference t) {
        this.stackFrame = null;
        this.thread = t;
    }

    private void invalidateCurrentFrame() {
        this.stackFrame = null;
    }

    private void invalidateCurrentThread() {
        this.thread = null;
        this.invalidateCurrentFrame();
    }

    private EventRequestManager getEventManager() throws DebuggerException {
        try {
            return this.vm.eventRequestManager();
        }
        catch (VMCannotBeModifiedException e) {
            throw new DebuggerException(e.getMessage(), (Exception)e);
        }
    }

    private ThreadStatus toThreadStatus(int status) {
        switch (status) {
            case 0: {
                return ThreadStatus.ZOMBIE;
            }
            case 1: {
                return ThreadStatus.RUNNING;
            }
            case 2: {
                return ThreadStatus.SLEEPING;
            }
            case 3: {
                return ThreadStatus.MONITOR;
            }
            case 4: {
                return ThreadStatus.WAIT;
            }
            case 5: {
                return ThreadStatus.NOT_STARTED;
            }
        }
        return ThreadStatus.UNKNOWN;
    }

    private SuspendPolicy toSuspendPolicy(int suspendEventRequest) {
        switch (suspendEventRequest) {
            case 1: {
                return SuspendPolicy.THREAD;
            }
            case 0: {
                return SuspendPolicy.NONE;
            }
        }
        return SuspendPolicy.ALL;
    }

    private int toSuspendEventRequest(SuspendPolicy suspendPolicy) {
        if (suspendPolicy == null) {
            return 2;
        }
        switch (suspendPolicy) {
            case NONE: {
                return 0;
            }
            case THREAD: {
                return 1;
            }
        }
        return 2;
    }
}

