/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.jdb.server;

import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.che.api.debugger.server.Debugger;
import org.eclipse.che.api.debugger.server.DebuggerFactory;
import org.eclipse.che.api.debugger.server.exceptions.DebuggerException;
import org.eclipse.che.plugin.jdb.server.JavaDebugger;

public class JavaDebuggerFactory
implements DebuggerFactory {
    private static final String TYPE = "jdb";

    public String getType() {
        return TYPE;
    }

    public Debugger create(Map<String, String> properties, Debugger.DebuggerCallback debuggerCallback) throws DebuggerException {
        int port;
        Map<String, String> normalizedProps = properties.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toLowerCase(), Map.Entry::getValue));
        String host = normalizedProps.get("host");
        if (host == null) {
            throw new DebuggerException("Can't establish connection: host property is unknown.");
        }
        String portProp = normalizedProps.get("port");
        if (portProp == null) {
            throw new DebuggerException("Can't establish connection: port property is unknown.");
        }
        try {
            port = Integer.parseInt(portProp);
        }
        catch (NumberFormatException e2) {
            throw new DebuggerException("Unknown port property format: " + portProp);
        }
        return new JavaDebugger(host, port, debuggerCallback);
    }
}

