/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.jdb.server.model;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.che.api.debug.shared.model.SimpleValue;
import org.eclipse.che.api.debug.shared.model.Variable;
import org.eclipse.che.api.debug.shared.model.VariablePath;
import org.eclipse.che.plugin.jdb.server.model.JdbArrayElement;
import org.eclipse.che.plugin.jdb.server.model.JdbField;
import org.eclipse.che.plugin.jdb.server.model.JdbFieldComparator;

public class JdbValue
implements SimpleValue {
    private final Value jdiValue;
    private final AtomicReference<List<Variable>> variables;
    private final VariablePath variablePath;

    public JdbValue(Value jdiValue, VariablePath variablePath) {
        this.jdiValue = jdiValue;
        this.variables = new AtomicReference();
        this.variablePath = variablePath;
    }

    public String getString() {
        return this.jdiValue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Variable> getVariables() {
        if (this.variables.get() == null) {
            AtomicReference<List<Variable>> atomicReference = this.variables;
            synchronized (atomicReference) {
                if (this.variables.get() == null) {
                    if (this.isPrimitive()) {
                        this.variables.set(Collections.emptyList());
                    } else if (this.isArray()) {
                        this.variables.set(new LinkedList());
                        ArrayReference array = (ArrayReference)this.jdiValue;
                        for (int i = 0; i < array.length(); ++i) {
                            this.variables.get().add(new JdbArrayElement(array.getValue(i), i, this.variablePath));
                        }
                    } else {
                        ObjectReference object = (ObjectReference)this.jdiValue;
                        this.variables.set(object.referenceType().allFields().stream().map(f -> new JdbField((Field)f, object, this.variablePath)).sorted(new JdbFieldComparator()).collect(Collectors.toList()));
                    }
                }
            }
        }
        return this.variables.get();
    }

    private boolean isArray() {
        return this.jdiValue instanceof ArrayReference;
    }

    private boolean isPrimitive() {
        return this.jdiValue instanceof PrimitiveValue;
    }
}

