/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.jdb.server.model;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.LinkedList;
import org.eclipse.che.api.debug.shared.model.Field;
import org.eclipse.che.api.debug.shared.model.SimpleValue;
import org.eclipse.che.api.debug.shared.model.VariablePath;
import org.eclipse.che.api.debug.shared.model.impl.VariablePathImpl;
import org.eclipse.che.plugin.jdb.server.model.JdbNullValue;
import org.eclipse.che.plugin.jdb.server.model.JdbType;
import org.eclipse.che.plugin.jdb.server.model.JdbValue;

public class JdbField
implements Field {
    private final com.sun.jdi.Field jdiField;
    private final ReferenceType type;
    private final ObjectReference object;
    private final VariablePath parentPath;

    public JdbField(com.sun.jdi.Field jdiField, ObjectReference object, VariablePath parentPath) {
        this.jdiField = jdiField;
        this.object = object;
        this.type = null;
        this.parentPath = parentPath;
    }

    public JdbField(com.sun.jdi.Field jdiField, ReferenceType type, VariablePath parentPath) {
        this.jdiField = jdiField;
        this.type = type;
        this.object = null;
        this.parentPath = parentPath;
    }

    public String getName() {
        return this.jdiField.name();
    }

    public boolean isIsStatic() {
        return this.jdiField.isStatic();
    }

    public boolean isIsTransient() {
        return this.jdiField.isTransient();
    }

    public boolean isIsVolatile() {
        return this.jdiField.isVolatile();
    }

    public boolean isIsFinal() {
        return this.jdiField.isFinal();
    }

    public boolean isPrimitive() {
        return JdbType.isPrimitive(this.jdiField.signature());
    }

    public SimpleValue getValue() {
        Value value;
        Value value2 = value = this.object == null ? this.type.getValue(this.jdiField) : this.object.getValue(this.jdiField);
        if (value == null) {
            return new JdbNullValue();
        }
        return new JdbValue(value, this.getVariablePath());
    }

    public String getType() {
        return this.jdiField.typeName();
    }

    public VariablePath getVariablePath() {
        LinkedList<String> pathEntries = new LinkedList<String>();
        if (this.parentPath.getPath().isEmpty()) {
            pathEntries.add(this.isIsStatic() ? "static" : "this");
        } else {
            pathEntries.addAll(this.parentPath.getPath());
        }
        pathEntries.add(this.getName());
        return new VariablePathImpl(pathEntries);
    }
}

