/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.jdb.server.model;

import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.che.api.debug.shared.model.Field;
import org.eclipse.che.api.debug.shared.model.Method;
import org.eclipse.che.api.debug.shared.model.StackFrameDump;
import org.eclipse.che.api.debug.shared.model.Variable;
import org.eclipse.che.api.debug.shared.model.VariablePath;
import org.eclipse.che.api.debug.shared.model.impl.LocationImpl;
import org.eclipse.che.api.debug.shared.model.impl.VariablePathImpl;
import org.eclipse.che.plugin.jdb.server.model.JdbField;
import org.eclipse.che.plugin.jdb.server.model.JdbFieldComparator;
import org.eclipse.che.plugin.jdb.server.model.JdbLocation;
import org.eclipse.che.plugin.jdb.server.model.JdbMethod;
import org.eclipse.che.plugin.jdb.server.model.JdbVariable;

public class JdbStackFrame
implements StackFrameDump {
    private final StackFrame jdiStackFrame;
    private final AtomicReference<List<Field>> fields;
    private final AtomicReference<List<Variable>> variables;
    private final org.eclipse.che.api.debug.shared.model.Location location;

    public JdbStackFrame(StackFrame jdiStackFrame) {
        this.jdiStackFrame = jdiStackFrame;
        Location jdiLocation = jdiStackFrame.location();
        this.location = new JdbLocation((org.eclipse.che.api.debug.shared.model.Location)new LocationImpl(jdiLocation.declaringType().name(), jdiLocation.lineNumber()), (Method)new JdbMethod(jdiStackFrame));
        this.variables = new AtomicReference();
        this.fields = new AtomicReference();
    }

    public JdbStackFrame(StackFrame jdiStackFrame, List<Field> fields, List<Variable> variables) {
        this.jdiStackFrame = jdiStackFrame;
        this.fields = new AtomicReference<List<Field>>(fields);
        this.variables = new AtomicReference<List<Variable>>(variables);
        Location jdiLocation = jdiStackFrame.location();
        this.location = new JdbLocation((org.eclipse.che.api.debug.shared.model.Location)new LocationImpl(jdiLocation.declaringType().name(), jdiLocation.lineNumber()), (Method)new JdbMethod(jdiStackFrame));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Field> getFields() {
        if (this.fields.get() == null) {
            AtomicReference<List<Field>> atomicReference = this.fields;
            synchronized (atomicReference) {
                if (this.fields.get() == null) {
                    try {
                        ObjectReference object = this.jdiStackFrame.thisObject();
                        if (object == null) {
                            ReferenceType type = this.jdiStackFrame.location().declaringType();
                            this.fields.set(this.jdiStackFrame.location().declaringType().allFields().stream().map(f -> new JdbField((com.sun.jdi.Field)f, type, (VariablePath)new VariablePathImpl(Collections.emptyList()))).sorted(new JdbFieldComparator()).collect(Collectors.toList()));
                        } else {
                            this.fields.set(object.referenceType().allFields().stream().map(f -> new JdbField((com.sun.jdi.Field)f, object, (VariablePath)new VariablePathImpl(Collections.emptyList()))).sorted(new JdbFieldComparator()).collect(Collectors.toList()));
                        }
                    }
                    catch (Exception e) {
                        this.fields.set(Collections.emptyList());
                    }
                }
            }
        }
        return this.fields.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Variable> getVariables() {
        if (this.variables.get() == null) {
            AtomicReference<List<Variable>> atomicReference = this.variables;
            synchronized (atomicReference) {
                if (this.variables.get() == null) {
                    try {
                        this.variables.set(this.jdiStackFrame.visibleVariables().stream().map(v -> new JdbVariable(this.jdiStackFrame, (LocalVariable)v)).collect(Collectors.toList()));
                    }
                    catch (Exception e) {
                        this.variables.set(Collections.emptyList());
                    }
                }
            }
        }
        return this.variables.get();
    }

    public org.eclipse.che.api.debug.shared.model.Location getLocation() {
        return this.location;
    }
}

