/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.jdb.server.model;

import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.LinkedList;
import org.eclipse.che.api.debug.shared.model.SimpleValue;
import org.eclipse.che.api.debug.shared.model.Variable;
import org.eclipse.che.api.debug.shared.model.VariablePath;
import org.eclipse.che.api.debug.shared.model.impl.VariablePathImpl;
import org.eclipse.che.plugin.jdb.server.model.JdbNullValue;
import org.eclipse.che.plugin.jdb.server.model.JdbValue;

public class JdbArrayElement
implements Variable {
    private final Value jdiValue;
    private final SimpleValue value;
    private final String name;
    private final String type;
    private final VariablePath parentPath;

    public JdbArrayElement(Value jdiValue, int index, VariablePath parentPath) {
        this.jdiValue = jdiValue;
        this.name = "[" + index + "]";
        this.parentPath = parentPath;
        this.value = jdiValue == null ? new JdbNullValue() : new JdbValue(jdiValue, this.getVariablePath());
        this.type = jdiValue == null ? "null" : jdiValue.type().name();
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimitive() {
        return this.jdiValue instanceof PrimitiveValue;
    }

    public SimpleValue getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public VariablePath getVariablePath() {
        LinkedList<String> pathEntries = new LinkedList<String>(this.parentPath.getPath());
        pathEntries.add(this.getName());
        return new VariablePathImpl(pathEntries);
    }
}

